/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.lang.reflect.InvocationTargetException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.node.EntityStateFactory;

public class SourceStateTransmitter<S extends PropertyContainer> {
    private final EntityStateFactory<S> entityStateFactory;

    public SourceStateTransmitter(EntityStateFactory<S> entityStateFactory) {
        this.entityStateFactory = entityStateFactory;
    }

    public <R> R copyPropertiesFrom(final BeanWrapper<Neo4jPersistentEntity<R>, R> wrapper, S source, Neo4jPersistentEntity<R> persistentEntity, MappingPolicy mappingPolicy) {
        Object entity = wrapper.getBean();
        final EntityState<S> entityState = this.entityStateFactory.getEntityState(entity, false);
        entityState.setPersistentState(source);
        persistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

            public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                SourceStateTransmitter.this.copyEntityStatePropertyValue(property, entityState, wrapper, property.getMappingPolicy());
            }
        });
        persistentEntity.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

            public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                SourceStateTransmitter.this.copyEntityStatePropertyValue(property, entityState, wrapper, property.getMappingPolicy());
            }
        });
        return (R)entity;
    }

    private <R> void setEntityStateValue(Neo4jPersistentProperty property, EntityState<S> entityState, BeanWrapper<Neo4jPersistentEntity<R>, R> wrapper, MappingPolicy mappingPolicy) {
        if (!entityState.isWritable(property)) {
            return;
        }
        Object value = this.getProperty(wrapper, property);
        entityState.setValue(property, value, mappingPolicy);
    }

    private Neo4jTemplate getTemplate() {
        return this.entityStateFactory.getTemplate();
    }

    private <T> T getProperty(BeanWrapper<Neo4jPersistentEntity<Object>, Object> wrapper, Neo4jPersistentProperty property, Class<T> type, boolean fieldAccessOnly) {
        return (T)wrapper.getProperty((PersistentProperty)property, type, fieldAccessOnly);
    }

    private <R> Object getProperty(BeanWrapper<Neo4jPersistentEntity<R>, R> wrapper, Neo4jPersistentProperty property) {
        try {
            return wrapper.getProperty((PersistentProperty)property);
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Error retrieving property " + property.getName() + " from " + wrapper.getBean(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException("Error retrieving property " + property.getName() + " from " + wrapper.getBean(), e.getTargetException());
        }
    }

    public <R> void setProperty(BeanWrapper<Neo4jPersistentEntity<R>, ?> wrapper, Neo4jPersistentProperty property, Object value) {
        try {
            wrapper.setProperty((PersistentProperty)property, value);
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Setting property " + property.getName() + " to " + value + " on " + wrapper.getBean(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException("Setting property " + property.getName() + " to " + value + " on " + wrapper.getBean(), e.getTargetException());
        }
    }

    private <R> Object copyEntityStatePropertyValue(Neo4jPersistentProperty property, EntityState<S> nodeState, BeanWrapper<Neo4jPersistentEntity<R>, R> wrapper, MappingPolicy mappingPolicy) {
        Object value = DoReturn.unwrap(nodeState.getValue(property, mappingPolicy));
        this.setProperty(wrapper, property, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> void copyPropertiesTo(final BeanWrapper<Neo4jPersistentEntity<R>, R> wrapper, S target, Neo4jPersistentEntity<R> persistentEntity, MappingPolicy mappingPolicy) {
        Transaction tx = this.getTemplate().beginTx();
        try {
            final EntityState<S> entityState = this.entityStateFactory.getEntityState(wrapper.getBean(), false);
            entityState.setPersistentState(target);
            entityState.persist();
            persistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<Neo4jPersistentProperty>(){

                public void doWithPersistentProperty(Neo4jPersistentProperty property) {
                    SourceStateTransmitter.this.setEntityStateValue(property, entityState, wrapper, property.getMappingPolicy());
                }
            });
            persistentEntity.doWithAssociations((AssociationHandler)new AssociationHandler<Neo4jPersistentProperty>(){

                public void doWithAssociation(Association<Neo4jPersistentProperty> association) {
                    Neo4jPersistentProperty property = (Neo4jPersistentProperty)association.getInverse();
                    SourceStateTransmitter.this.setEntityStateValue(property, entityState, wrapper, property.getMappingPolicy());
                }
            });
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

