/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.util.Assert;

class MatchClause {
    private final PersistentPropertyPath<Neo4jPersistentProperty> path;

    public MatchClause(PersistentPropertyPath<Neo4jPersistentProperty> path) {
        Assert.notNull(path);
        this.path = this.relationshipPath(path);
    }

    private PersistentPropertyPath<Neo4jPersistentProperty> relationshipPath(PersistentPropertyPath<Neo4jPersistentProperty> path) {
        return path.getLength() == 1 || ((Neo4jPersistentProperty)path.getLeafProperty()).isRelationship() ? path : this.relationshipPath((PersistentPropertyPath<Neo4jPersistentProperty>)path.getParentPath());
    }

    public boolean hasRelationship() {
        for (Neo4jPersistentProperty property : this.path) {
            if (!property.isRelationship()) continue;
            return true;
        }
        return false;
    }

    public String toString(VariableContext variableContext) {
        return this.matchPattern(variableContext, this.path);
    }

    private String matchPattern(VariableContext variableContext, PersistentPropertyPath<Neo4jPersistentProperty> relPath) {
        if (relPath.getLength() == 1) {
            Neo4jPersistentProperty property = (Neo4jPersistentProperty)relPath.getBaseProperty();
            return variableContext.getVariableFor(property.getOwner()) + QueryTemplates.getArrow(property.getRelationshipInfo()) + variableContext.getVariableFor(relPath);
        }
        RelationshipInfo info = ((Neo4jPersistentProperty)relPath.getLeafProperty()).getRelationshipInfo();
        return this.matchPattern(variableContext, (PersistentPropertyPath<Neo4jPersistentProperty>)relPath.getParentPath()) + QueryTemplates.getArrow(info) + variableContext.getVariableFor(relPath);
    }
}

