/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class GraphBackedEntityIterableWrapper<STATE extends PropertyContainer, ENTITY>
extends IterableWrapper<ENTITY, STATE> {
    private final Class<ENTITY> targetType;
    private final Neo4jTemplate template;

    public GraphBackedEntityIterableWrapper(Iterable<STATE> iterable, Class<ENTITY> targetType, Neo4jTemplate template) {
        super(iterable);
        this.targetType = targetType;
        this.template = template;
    }

    protected ENTITY underlyingObjectToObject(STATE s) {
        return this.template.createEntityFromState(s, this.targetType, this.template.getMappingPolicy(this.targetType));
    }

    public static <S extends PropertyContainer, E> GraphBackedEntityIterableWrapper<S, E> create(Iterable<S> iterable, Class<E> targetType, Neo4jTemplate template) {
        return new GraphBackedEntityIterableWrapper<S, E>(iterable, targetType, template);
    }
}

