/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.util.Assert;

public abstract class AbstractNodeRelationshipFieldAccessor<STATE extends PropertyContainer, TSTATE extends PropertyContainer>
implements FieldAccessor {
    protected final RelationshipType type;
    protected final Neo4jPersistentProperty property;
    protected final Direction direction;
    protected final Class<?> relatedType;
    protected final Neo4jTemplate template;

    public AbstractNodeRelationshipFieldAccessor(Class<?> clazz, Neo4jTemplate template, Direction direction, RelationshipType type, Neo4jPersistentProperty property) {
        this.relatedType = clazz;
        this.template = template;
        this.direction = direction;
        this.type = type;
        this.property = property;
    }

    protected MappingPolicy updateMappingPolicy(MappingPolicy mappingPolicy) {
        if (mappingPolicy != null) {
            return mappingPolicy;
        }
        return this.property.getMappingPolicy();
    }

    @Override
    public boolean isWriteable(Object entity) {
        return true;
    }

    protected STATE checkUnderlyingState(Object entity) {
        if (entity == null) {
            throw new IllegalStateException("Entity is null");
        }
        STATE node = this.getState(entity);
        if (node != null) {
            return node;
        }
        throw new IllegalStateException("Entity must have a backing Node");
    }

    protected void removeMissingRelationships(Node node, Set<Node> targetNodes) {
        for (Relationship relationship : node.getRelationships(this.type, this.direction)) {
            if (targetNodes.remove(relationship.getOtherNode(node))) continue;
            relationship.delete();
        }
    }

    protected void createAddedRelationships(Node node, Set<Node> targetNodes) {
        for (Node targetNode : targetNodes) {
            this.createSingleRelationship(node, targetNode);
        }
    }

    protected Set<Node> createSetOfTargetNodes(Object newVal) {
        if (!(newVal instanceof Set)) {
            throw new IllegalArgumentException("New value must be a Set, was: " + newVal.getClass());
        }
        HashSet<Node> nodes = new HashSet<Node>();
        for (Object value : (Set)newVal) {
            if (!this.relatedType.isInstance(value)) {
                throw new IllegalArgumentException("New value elements must be " + this.relatedType);
            }
            nodes.add((Node)this.getOrCreateState(value));
        }
        return nodes;
    }

    protected STATE getOrCreateState(Object value) {
        STATE state = this.getState(value);
        if (state != null) {
            return state;
        }
        Object saved = this.template.save(value);
        STATE newState = this.getState(saved);
        Assert.notNull(newState);
        return newState;
    }

    protected <T> ManagedFieldAccessorSet<T> createManagedSet(Object entity, Set<T> result, MappingPolicy mappingPolicy) {
        return new ManagedFieldAccessorSet(entity, result, this.property, this.template, this, mappingPolicy);
    }

    protected Set<Object> createEntitySetFromRelationshipEndNodes(Object entity, MappingPolicy mappingPolicy) {
        Iterable<TSTATE> nodes = this.getStatesFromEntity(entity);
        HashSet<Object> result = new HashSet<Object>();
        for (PropertyContainer otherNode : nodes) {
            Object target = this.template.createEntityFromState(otherNode, this.relatedType, mappingPolicy);
            result.add(target);
        }
        return result;
    }

    protected void createSingleRelationship(Node start, Node end) {
        if (end == null) {
            return;
        }
        switch (this.direction) {
            case OUTGOING: 
            case BOTH: {
                this.obtainSingleRelationship(start, end);
                break;
            }
            case INCOMING: {
                this.obtainSingleRelationship(end, start);
                break;
            }
            default: {
                throw new InvalidDataAccessApiUsageException("invalid direction " + this.direction);
            }
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    protected abstract Relationship obtainSingleRelationship(Node var1, Node var2);

    protected abstract Iterable<TSTATE> getStatesFromEntity(Object var1);

    protected abstract STATE getState(Object var1);
}

