/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Arrays;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.kernel.impl.transaction.UserTransactionImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.neo4j.config.ConfigurationCheck;
import org.springframework.data.neo4j.config.NullTransactionManager;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.Neo4jConversionServiceFactoryBean;
import org.springframework.data.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelationshipDelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.MappingInfrastructure;
import org.springframework.data.neo4j.support.Neo4jExceptionTranslator;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexProviderImpl;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityFetchHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;
import org.springframework.data.neo4j.support.mapping.TRSTypeAliasAccessor;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityInstantiator;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityStateFactory;
import org.springframework.data.neo4j.support.typerepresentation.ClassValueTypeInformationMapper;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.UserTransactionAdapter;

@Configuration
public abstract class Neo4jConfiguration {
    private GraphDatabaseService graphDatabaseService;
    private ConversionService conversionService;
    @Autowired(required=false)
    private Validator validator;

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    @Qualifier(value="conversionService")
    @Autowired(required=false)
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired
    public void setGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    @Bean
    public MappingInfrastructure mappingInfrastructure() throws Exception {
        MappingInfrastructure infrastructure = new MappingInfrastructure();
        infrastructure.setGraphDatabaseService(this.getGraphDatabaseService());
        infrastructure.setTypeRepresentationStrategyFactory(this.typeRepresentationStrategyFactory());
        infrastructure.setConversionService(this.neo4jConversionService());
        infrastructure.setMappingContext(this.mappingContext());
        infrastructure.setEntityStateHandler(this.entityStateHandler());
        infrastructure.setNodeEntityStateFactory(this.nodeEntityStateFactory());
        infrastructure.setNodeTypeRepresentationStrategy(this.nodeTypeRepresentationStrategy());
        infrastructure.setNodeEntityInstantiator(this.graphEntityInstantiator());
        infrastructure.setRelationshipEntityStateFactory(this.relationshipEntityStateFactory());
        infrastructure.setRelationshipTypeRepresentationStrategy(this.relationshipTypeRepresentationStrategy());
        infrastructure.setRelationshipEntityInstantiator(this.graphRelationshipInstantiator());
        infrastructure.setTransactionManager(this.neo4jTransactionManager());
        infrastructure.setGraphDatabase(this.graphDatabase());
        infrastructure.setIndexProvider(this.indexProvider());
        if (this.validator != null) {
            infrastructure.setValidator(this.validator);
        }
        return infrastructure;
    }

    @Bean(initMethod="postConstruct")
    public Neo4jTemplate neo4jTemplate() throws Exception {
        Neo4jTemplate neo4jTemplate = new Neo4jTemplate();
        neo4jTemplate.setInfrastructure(this.mappingInfrastructure());
        this.nodeEntityStateFactory().setTemplate(neo4jTemplate);
        this.relationshipEntityStateFactory().setTemplate(neo4jTemplate);
        return neo4jTemplate;
    }

    @Bean
    public TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy() throws Exception {
        return this.typeRepresentationStrategyFactory().getRelationshipTypeRepresentationStrategy();
    }

    @Bean
    public TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy() throws Exception {
        return this.typeRepresentationStrategyFactory().getNodeTypeRepresentationStrategy();
    }

    @Bean
    public TypeRepresentationStrategyFactory typeRepresentationStrategyFactory() throws Exception {
        return new TypeRepresentationStrategyFactory(this.graphDatabase(), this.indexProvider());
    }

    @Bean
    public EntityStateHandler entityStateHandler() throws Exception {
        return new EntityStateHandler(this.mappingContext(), this.graphDatabase());
    }

    @Bean
    public TypeMapper<Node> nodeTypeMapper() throws Exception {
        return new DefaultTypeMapper(new TRSTypeAliasAccessor<Node>(this.nodeTypeRepresentationStrategy()), Arrays.asList(new ClassValueTypeInformationMapper()));
    }

    @Bean
    public TypeMapper<Relationship> relationshipTypeMapper() throws Exception {
        return new DefaultTypeMapper(new TRSTypeAliasAccessor<Relationship>(this.relationshipTypeRepresentationStrategy()), Arrays.asList(new ClassValueTypeInformationMapper()));
    }

    @Bean
    public Neo4jEntityFetchHandler entityFetchHandler() throws Exception {
        SourceStateTransmitter<Node> nodeSourceStateTransmitter = this.nodeStateTransmitter();
        SourceStateTransmitter<Relationship> relationshipSourceStateTransmitter = new SourceStateTransmitter<Relationship>(this.relationshipEntityStateFactory());
        return new Neo4jEntityFetchHandler(this.entityStateHandler(), this.neo4jConversionService(), nodeSourceStateTransmitter, relationshipSourceStateTransmitter);
    }

    @Bean
    public SourceStateTransmitter<Node> nodeStateTransmitter() throws Exception {
        return new SourceStateTransmitter<Node>(this.nodeEntityStateFactory());
    }

    @Bean
    protected ConversionService neo4jConversionService() throws Exception {
        Neo4jConversionServiceFactoryBean neo4jConversionServiceFactoryBean = new Neo4jConversionServiceFactoryBean();
        if (this.conversionService != null) {
            neo4jConversionServiceFactoryBean.addConverters(this.conversionService);
            return this.conversionService;
        }
        return neo4jConversionServiceFactoryBean.getObject();
    }

    @Bean
    protected RelationshipEntityInstantiator graphRelationshipInstantiator() throws Exception {
        return new RelationshipEntityInstantiator(this.entityStateHandler());
    }

    @Bean
    protected EntityInstantiator<Node> graphEntityInstantiator() throws Exception {
        return new NodeEntityInstantiator(this.entityStateHandler());
    }

    @Bean
    public Neo4jMappingContext mappingContext() throws Exception {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext();
        this.nodeEntityStateFactory().setMappingContext(mappingContext);
        this.relationshipEntityStateFactory().setMappingContext(mappingContext);
        return mappingContext;
    }

    @Bean
    public RelationshipEntityStateFactory relationshipEntityStateFactory() throws Exception {
        return new RelationshipEntityStateFactory();
    }

    @Bean
    public NodeEntityStateFactory nodeEntityStateFactory() throws Exception {
        return new NodeEntityStateFactory();
    }

    @Bean
    public DelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory() throws Exception {
        NodeDelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory = new NodeDelegatingFieldAccessorFactory(this.neo4jTemplate());
        this.nodeEntityStateFactory().setNodeDelegatingFieldAccessorFactory(nodeDelegatingFieldAccessorFactory);
        return nodeDelegatingFieldAccessorFactory;
    }

    @Bean
    public DelegatingFieldAccessorFactory relationshipDelegatingFieldAccessorFactory() throws Exception {
        RelationshipDelegatingFieldAccessorFactory relationshipDelegatingFieldAccessorFactory = new RelationshipDelegatingFieldAccessorFactory(this.neo4jTemplate());
        this.relationshipEntityStateFactory().setRelationshipDelegatingFieldAccessorFactory(relationshipDelegatingFieldAccessorFactory);
        return relationshipDelegatingFieldAccessorFactory;
    }

    @Bean(name={"neo4jTransactionManager", "transactionManager"})
    @Qualifier(value="neo4jTransactionManager")
    public PlatformTransactionManager neo4jTransactionManager() {
        return this.createJtaTransactionManager();
    }

    protected JtaTransactionManager createJtaTransactionManager() {
        JtaTransactionManager jtaTm = new JtaTransactionManager();
        GraphDatabaseService gds = this.getGraphDatabaseService();
        if (gds instanceof AbstractGraphDatabase) {
            jtaTm.setTransactionManager((TransactionManager)new SpringTransactionManager(gds));
            jtaTm.setUserTransaction((UserTransaction)new UserTransactionImpl(gds));
        } else {
            NullTransactionManager tm = new NullTransactionManager();
            jtaTm.setTransactionManager((TransactionManager)tm);
            jtaTm.setUserTransaction((UserTransaction)new UserTransactionAdapter((TransactionManager)tm));
        }
        return jtaTm;
    }

    @Bean
    public GraphDatabase graphDatabase() {
        return new DelegatingGraphDatabase(this.graphDatabaseService);
    }

    @Bean
    public ConfigurationCheck configurationCheck() throws Exception {
        return new ConfigurationCheck(this.neo4jTemplate(), this.neo4jTransactionManager());
    }

    @Bean
    public PersistenceExceptionTranslator persistenceExceptionTranslator() {
        return new Neo4jExceptionTranslator();
    }

    @Bean
    public IndexProvider indexProvider() throws Exception {
        return new IndexProviderImpl(this.mappingContext(), this.graphDatabase());
    }
}

