/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.Traversal;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.typerepresentation.ClosableCombiningIterable;
import org.springframework.data.neo4j.support.typerepresentation.EntityTypeCache;

public class SubReferenceNodeTypeRepresentationStrategy
implements NodeTypeRepresentationStrategy {
    private static final Log log = LogFactory.getLog(SubReferenceNodeTypeRepresentationStrategy.class);
    public static final RelationshipType INSTANCE_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"INSTANCE_OF");
    public static final RelationshipType SUBCLASS_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"SUBCLASS_OF");
    public static final String SUBREFERENCE_NODE_COUNTER_KEY = "count";
    public static final String SUBREF_PREFIX = "SUBREF_";
    public static final String SUBREF_CLASS_KEY = "class";
    private GraphDatabase graphDatabase;
    private final EntityTypeCache typeCache;

    public SubReferenceNodeTypeRepresentationStrategy(GraphDatabase graphDatabase) {
        this.graphDatabase = graphDatabase;
        this.typeCache = new EntityTypeCache();
    }

    public static Node getSingleOtherNode(Node node, RelationshipType type, Direction direction) {
        Relationship rel = node.getSingleRelationship(type, direction);
        return rel == null ? null : rel.getOtherNode(node);
    }

    public static Integer incrementAndGetCounter(Node node, String propertyKey) {
        SubReferenceNodeTypeRepresentationStrategy.acquireWriteLock((PropertyContainer)node);
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        node.setProperty(propertyKey, (Object)(++value));
        return value;
    }

    public static Integer decrementAndGetCounter(Node node, String propertyKey, int notLowerThan) {
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        value = --value < notLowerThan ? notLowerThan : value;
        node.setProperty(propertyKey, (Object)value);
        return value;
    }

    public static void acquireWriteLock(PropertyContainer entity) {
        entity.removeProperty("___dummy_property_for_locking___");
    }

    @Override
    public void postEntityCreation(Node state, Class<?> type) {
        Node subReference = this.obtainSubreferenceNode(type);
        state.createRelationshipTo(subReference, INSTANCE_OF_RELATIONSHIP_TYPE);
        subReference.setProperty(SUBREF_CLASS_KEY, (Object)type.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created link to subref node: " + subReference + " with type: " + type.getName()));
        }
        SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(subReference, SUBREFERENCE_NODE_COUNTER_KEY);
        this.updateSuperClassSubrefs(type, subReference);
    }

    private void updateSuperClassSubrefs(Class<?> clazz, Node subReference) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Node superClassSubref = this.obtainSubreferenceNode(superClass);
            if (SubReferenceNodeTypeRepresentationStrategy.getSingleOtherNode(subReference, SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING) == null) {
                subReference.createRelationshipTo(superClassSubref, SUBCLASS_OF_RELATIONSHIP_TYPE);
            }
            superClassSubref.setProperty(SUBREF_CLASS_KEY, (Object)superClass.getName());
            Integer count = SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(superClassSubref, SUBREFERENCE_NODE_COUNTER_KEY);
            if (log.isDebugEnabled()) {
                log.debug((Object)("count on ref " + superClassSubref + " for class " + superClass.getSimpleName() + " = " + count));
            }
            this.updateSuperClassSubrefs(superClass, superClassSubref);
        }
    }

    @Override
    public long count(Class<?> entityClass) {
        Node subrefNode = this.findSubreferenceNode(entityClass);
        if (subrefNode == null) {
            return 0L;
        }
        return ((Integer)subrefNode.getProperty(SUBREFERENCE_NODE_COUNTER_KEY, (Object)0)).intValue();
    }

    @Override
    public <T> Class<T> getJavaType(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Relationship instanceOfRelationship = node.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        if (instanceOfRelationship == null) {
            throw new IllegalArgumentException("The node " + node + " is not attached to a type hierarchy.");
        }
        Node subrefNode = instanceOfRelationship.getEndNode();
        String typeName = (String)subrefNode.getProperty(SUBREF_CLASS_KEY);
        Class<T> clazz = this.resolveType(node, typeName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found class " + clazz.getSimpleName() + " for node: " + node));
        }
        return clazz;
    }

    private <T> Class<T> resolveType(Node node, String typeName) {
        Class type = this.typeCache.getClassForName(typeName);
        if (type == null) {
            throw new IllegalStateException("Unable to get type for node: " + node);
        }
        return type;
    }

    @Override
    public void preEntityRemoval(Node state) {
        Class clazz = this.getJavaType(state);
        if (clazz == null) {
            return;
        }
        Node subReference = this.obtainSubreferenceNode(clazz);
        Relationship instanceOf = state.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        instanceOf.delete();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed link to subref node: " + subReference + " with type: " + clazz.getName()));
        }
        TraversalDescription traversal = Traversal.description().depthFirst().relationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        for (Node node : traversal.traverse(subReference).nodes()) {
            Integer count = (Integer)node.getProperty(SUBREFERENCE_NODE_COUNTER_KEY);
            Integer newCount = SubReferenceNodeTypeRepresentationStrategy.decrementAndGetCounter(node, SUBREFERENCE_NODE_COUNTER_KEY, 0);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("count on ref " + node + " was " + count + " new " + newCount));
        }
    }

    @Override
    public <T> ClosableIterable<Node> findAll(Class<T> clazz) {
        Node subrefNode = this.findSubreferenceNode(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Subref: " + subrefNode));
        }
        List relIterables = this.findEntityIterables(subrefNode);
        return new ClosableCombiningIterable<Node>(relIterables);
    }

    private List<Iterable<Node>> findEntityIterables(Node subrefNode) {
        if (subrefNode == null) {
            return Collections.emptyList();
        }
        LinkedList<Iterable<Node>> result = new LinkedList<Iterable<Node>>();
        for (Relationship relationship : subrefNode.getRelationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.INCOMING)) {
            List<Iterable<Node>> entityIterables = this.findEntityIterables(relationship.getStartNode());
            result.addAll(entityIterables);
        }
        IterableWrapper<Node, Relationship> t = new IterableWrapper<Node, Relationship>(subrefNode.getRelationships(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.INCOMING)){

            protected Node underlyingObjectToObject(Relationship rel) {
                return rel.getStartNode();
            }
        };
        result.add((Iterable<Node>)t);
        return result;
    }

    public Node obtainSubreferenceNode(Class<?> entityClass) {
        return this.getOrCreateSubReferenceNode((RelationshipType)this.subRefRelationshipType(entityClass));
    }

    public Node findSubreferenceNode(Class<?> entityClass) {
        Relationship subrefRelationship = this.graphDatabase.getReferenceNode().getSingleRelationship((RelationshipType)this.subRefRelationshipType(entityClass), Direction.OUTGOING);
        return subrefRelationship != null ? subrefRelationship.getEndNode() : null;
    }

    private DynamicRelationshipType subRefRelationshipType(Class<?> clazz) {
        return DynamicRelationshipType.withName((String)(SUBREF_PREFIX + clazz.getName()));
    }

    public Node getOrCreateSubReferenceNode(RelationshipType relType) {
        return this.getOrCreateSingleOtherNode(this.graphDatabase.getReferenceNode(), relType, Direction.OUTGOING);
    }

    private Node getOrCreateSingleOtherNode(Node fromNode, RelationshipType type, Direction direction) {
        Relationship singleRelationship = fromNode.getSingleRelationship(type, direction);
        if (singleRelationship != null) {
            return singleRelationship.getOtherNode(fromNode);
        }
        Node otherNode = this.graphDatabase.createNode(null);
        fromNode.createRelationshipTo(otherNode, type);
        return otherNode;
    }
}

