/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.annotation.RelatedToVia;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class RelationshipInfo {
    private boolean isMultiple;
    private final Direction direction;
    private final String type;
    private final TypeInformation<?> targetType;
    private final boolean targetsNodes;
    private boolean readonly;
    private Neo4jPersistentEntity targetEntity;

    public Direction getDirection() {
        return this.direction;
    }

    public String getType() {
        return this.type;
    }

    public RelationshipType getRelationshipType() {
        return DynamicRelationshipType.withName((String)this.type);
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public RelationshipInfo(String type, Direction direction, TypeInformation<?> typeInformation, TypeInformation<?> concreteActualType, Neo4jMappingContext ctx) {
        this.type = type;
        this.direction = direction;
        this.isMultiple = typeInformation.isCollectionLike();
        this.targetType = concreteActualType != null ? concreteActualType : typeInformation.getActualType();
        this.targetEntity = (Neo4jPersistentEntity)ctx.getPersistentEntity(this.targetType);
        this.targetsNodes = this.targetEntity.isNodeEntity();
        this.readonly = this.isMultiple() && typeInformation.getType().equals(Iterable.class);
    }

    public static RelationshipInfo fromField(Field field, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        return new RelationshipInfo(field.getName(), Direction.OUTGOING, typeInformation, null, ctx);
    }

    public static RelationshipInfo fromField(Field field, RelatedTo annotation, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        return new RelationshipInfo(annotation.type().isEmpty() ? field.getName() : annotation.type(), annotation.direction(), typeInformation, annotation.elementClass() != Object.class ? ClassTypeInformation.from(annotation.elementClass()) : null, ctx);
    }

    public static RelationshipInfo fromField(Field field, RelatedToVia annotation, TypeInformation<?> typeInformation, Neo4jMappingContext ctx) {
        TypeInformation<?> elementClass = RelationshipInfo.elementClass(annotation, typeInformation);
        return new RelationshipInfo(RelationshipInfo.relationshipType(field, annotation, typeInformation), annotation.direction(), typeInformation, elementClass, ctx);
    }

    private static String relationshipType(Field field, RelatedToVia annotation, TypeInformation<?> typeInformation) {
        if (!annotation.type().isEmpty()) {
            return annotation.type();
        }
        TypeInformation<?> relationshipEntityType = RelationshipInfo.elementClass(annotation, typeInformation);
        RelationshipEntity relationshipEntity = relationshipEntityType.getType().getAnnotation(RelationshipEntity.class);
        if (!relationshipEntity.type().isEmpty()) {
            return relationshipEntity.type();
        }
        return field.getName();
    }

    private static TypeInformation<?> elementClass(RelatedToVia annotation, TypeInformation<?> typeInformation) {
        return annotation.elementClass() != Object.class ? ClassTypeInformation.from(annotation.elementClass()) : typeInformation.getActualType();
    }

    public TypeInformation<?> getTargetType() {
        return this.targetType;
    }

    public boolean targetsNodes() {
        return this.targetsNodes;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public Neo4jPersistentEntity getTargetEntity() {
        return this.targetEntity;
    }
}

