/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.template;

import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.QueryResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.UncategorizedGraphStoreException;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.data.neo4j.template.GraphCallback;
import org.springframework.data.neo4j.template.Neo4jExceptionTranslator;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplate
implements Neo4jOperations {
    private final GraphDatabase graphDatabase;
    private final PlatformTransactionManager transactionManager;
    private final Neo4jExceptionTranslator exceptionTranslator = new Neo4jExceptionTranslator();

    private static void notNull(Object ... pairs) {
        assert (pairs.length % 2 == 0) : "wrong number of pairs to check";
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i] == null) {
                throw new InvalidDataAccessApiUsageException("[Assertion failed] - " + pairs[i + 1] + " is required; it must not be null");
            }
            i += 2;
        }
    }

    public Neo4jTemplate(GraphDatabase graphDatabase, PlatformTransactionManager transactionManager) {
        Neo4jTemplate.notNull(graphDatabase, "graphDatabase");
        this.transactionManager = transactionManager;
        this.graphDatabase = graphDatabase;
    }

    public Neo4jTemplate(GraphDatabase graphDatabase) {
        Neo4jTemplate.notNull(graphDatabase, "graphDatabase");
        this.transactionManager = null;
        this.graphDatabase = graphDatabase;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    private <T> T doExecute(GraphCallback<T> callback) {
        Neo4jTemplate.notNull(callback, "callback");
        try {
            return callback.doWithGraph(this.graphDatabase);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
        catch (Exception e) {
            throw new UncategorizedGraphStoreException("Error executing callback", e);
        }
    }

    @Override
    public <T> T exec(final GraphCallback<T> callback) {
        if (this.transactionManager == null) {
            return this.doExecute(callback);
        }
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return Neo4jTemplate.this.doExecute(callback);
            }
        });
    }

    @Override
    public Node getReferenceNode() {
        try {
            return this.graphDatabase.getReferenceNode();
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Node createNode(final Map<String, Object> properties) {
        return this.exec(new GraphCallback<Node>(){

            @Override
            public Node doWithGraph(GraphDatabase graph) throws Exception {
                return Neo4jTemplate.this.graphDatabase.createNode(properties);
            }
        });
    }

    @Override
    public Node getNode(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.graphDatabase.getNodeById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Relationship getRelationship(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.graphDatabase.getRelationshipById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> T index(final String indexName, final T element, final String field, final Object value) {
        Neo4jTemplate.notNull(element, "element", field, "field", value, "value", indexName, "indexName");
        this.exec(new GraphCallback.WithoutResult(){

            @Override
            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                if (element instanceof Relationship) {
                    Index<Relationship> relationshipIndex = Neo4jTemplate.this.graphDatabase.createIndex(Relationship.class, indexName, false);
                    relationshipIndex.add((PropertyContainer)((Relationship)element), field, value);
                } else if (element instanceof Node) {
                    Neo4jTemplate.this.graphDatabase.createIndex(Node.class, indexName, false).add((PropertyContainer)((Node)element), field, value);
                } else {
                    throw new IllegalArgumentException("Provided element is neither node nor relationship " + element);
                }
            }
        });
        return element;
    }

    @Override
    public <T> QueryResult<T> convert(Iterable<T> iterable) {
        return new QueryResultBuilder<T>(iterable);
    }

    private QueryEngine queryEngineFor(QueryType type) {
        return this.graphDatabase.queryEngineFor(type);
    }

    @Override
    public Relationship createRelationship(final Node startNode, final Node endNode, final RelationshipType relationshipType, final Map<String, Object> properties) {
        Neo4jTemplate.notNull(startNode, "startNode", endNode, "endNode", relationshipType, "relationshipType", properties, "properties");
        return this.exec(new GraphCallback<Relationship>(){

            @Override
            public Relationship doWithGraph(GraphDatabase graph) throws Exception {
                return graph.createRelationship(startNode, endNode, relationshipType, properties);
            }
        });
    }

    @Override
    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params) {
        Neo4jTemplate.notNull(statement, "statement");
        return this.queryEngineFor(QueryType.Cypher).query(statement, params);
    }

    @Override
    public QueryResult<Object> execute(String statement, Map<String, Object> params) {
        Neo4jTemplate.notNull(statement, "statement");
        return this.queryEngineFor(QueryType.Gremlin).query(statement, params);
    }

    @Override
    public QueryResult<Path> traverse(Node startNode, TraversalDescription traversal) {
        Neo4jTemplate.notNull(startNode, "startNode", traversal, "traversal");
        try {
            return new QueryResultBuilder<Path>((Iterable<Path>)traversal.traverse(startNode));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> QueryResult<T> lookup(String indexName, String field, Object value) {
        Neo4jTemplate.notNull(field, "field", value, "value", indexName, "indexName");
        try {
            Index index = this.graphDatabase.getIndex(indexName);
            return new QueryResultBuilder((Iterable)index.get(field, value));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> QueryResult<T> lookup(String indexName, Object query) {
        Neo4jTemplate.notNull(query, "valueOrQueryObject", indexName, "indexName");
        try {
            Index index = this.graphDatabase.getIndex(indexName);
            return new QueryResultBuilder((Iterable)index.query(query));
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }
}

