/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.core.RelationshipTypeRepresentationStrategy;
import org.springframework.data.persistence.EntityInstantiator;

public class IndexingRelationshipTypeRepresentationStrategy
implements RelationshipTypeRepresentationStrategy {
    public static final String INDEX_NAME = "__types__";
    public static final String TYPE_PROPERTY_NAME = "__type__";
    public static final String INDEX_KEY = "className";
    private EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator;
    private GraphDatabaseService graphDb;
    private final Map<String, Class<?>> cache = new HashMap();

    public IndexingRelationshipTypeRepresentationStrategy(GraphDatabaseService graphDb, EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator) {
        this.graphDb = graphDb;
        this.relationshipEntityInstantiator = relationshipEntityInstantiator;
    }

    private Index<Node> getNodeTypesIndex() {
        return this.graphDb.index().forNodes(INDEX_NAME);
    }

    private Index<Relationship> getRelTypesIndex() {
        return this.graphDb.index().forRelationships(INDEX_NAME);
    }

    @Override
    public void postEntityCreation(Relationship state, Class<? extends RelationshipBacked> type) {
        this.addToTypesIndex(state, type);
        state.setProperty(TYPE_PROPERTY_NAME, (Object)type.getName());
    }

    private void addToTypesIndex(Relationship node, Class<? extends RelationshipBacked> entityClass) {
        Class<? extends RelationshipBacked> klass = entityClass;
        while (klass.getAnnotation(RelationshipEntity.class) != null) {
            this.getRelTypesIndex().add((PropertyContainer)node, INDEX_KEY, (Object)klass.getName());
            klass = klass.getSuperclass();
        }
    }

    @Override
    public <U extends RelationshipBacked> ClosableIterable<U> findAll(Class<U> clazz) {
        return this.findAllRelBacked(clazz);
    }

    private <ENTITY extends RelationshipBacked> ClosableIterable<ENTITY> findAllRelBacked(Class<ENTITY> clazz) {
        IndexHits allEntitiesOfType = this.getRelTypesIndex().get(INDEX_KEY, (Object)clazz.getName());
        return new FilteringClosableEntityIterable((IndexHits<Relationship>)allEntitiesOfType);
    }

    @Override
    public long count(Class<? extends RelationshipBacked> entityClass) {
        long count = 0L;
        Iterator iterator = this.getRelTypesIndex().get(INDEX_KEY, (Object)entityClass.getName()).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Override
    public Class<? extends RelationshipBacked> getJavaType(Relationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("Node is null");
        }
        String className = (String)relationship.getProperty(TYPE_PROPERTY_NAME);
        return this.getClassForName(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ENTITY extends GraphBacked<?>> Class<ENTITY> getClassForName(String className) {
        try {
            Class<?> result = this.cache.get(className);
            if (result != null) {
                return result;
            }
            Map<String, Class<?>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(className);
                if (result != null) {
                    return result;
                }
                result = Class.forName(className);
                this.cache.put(className, result);
                return result;
            }
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public void preEntityRemoval(Relationship state) {
        this.getRelTypesIndex().remove((PropertyContainer)state);
    }

    @Override
    public <U extends RelationshipBacked> U createEntity(Relationship state) {
        Class<? extends RelationshipBacked> javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on relationship.");
        }
        return (U)((RelationshipBacked)this.relationshipEntityInstantiator.createEntityFromState((Object)state, javaType));
    }

    @Override
    public <U extends RelationshipBacked> U createEntity(Relationship state, Class<U> type) {
        Class<? extends RelationshipBacked> javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on relationship.");
        }
        if (type.isAssignableFrom(javaType)) {
            return (U)((RelationshipBacked)this.relationshipEntityInstantiator.createEntityFromState((Object)state, javaType));
        }
        throw new IllegalArgumentException(String.format("Entity is not of type: %s (was %s)", type, javaType));
    }

    @Override
    public <U extends RelationshipBacked> U projectEntity(Relationship state, Class<U> type) {
        return (U)((RelationshipBacked)this.relationshipEntityInstantiator.createEntityFromState((Object)state, type));
    }

    private class FilteringClosableEntityIterable<ENTITY extends RelationshipBacked>
    extends FilteringIterable<ENTITY>
    implements ClosableIterable<ENTITY> {
        private final IndexHits<Relationship> indexHits;

        public FilteringClosableEntityIterable(IndexHits<Relationship> indexHits) {
            super((Iterable)new IterableWrapper<ENTITY, Relationship>((Iterable)indexHits){

                protected ENTITY underlyingObjectToObject(Relationship rel) {
                    Class<? extends RelationshipBacked> javaType = IndexingRelationshipTypeRepresentationStrategy.this.getJavaType(rel);
                    if (javaType == null) {
                        return null;
                    }
                    return (RelationshipBacked)IndexingRelationshipTypeRepresentationStrategy.this.relationshipEntityInstantiator.createEntityFromState((Object)rel, javaType);
                }
            }, new Predicate<ENTITY>(){

                public boolean accept(ENTITY item) {
                    return item != null;
                }
            });
            this.indexHits = indexHits;
        }

        public void close() {
            this.indexHits.close();
        }
    }
}

