/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.query.QueryOperations;

public class CypherQueryExecutor
implements QueryOperations<Map<String, Object>> {
    private final CypherQueryEngine queryEngine;

    public CypherQueryExecutor(GraphDatabaseContext ctx) {
        EntityResultConverter converter = new EntityResultConverter(ctx);
        this.queryEngine = new CypherQueryEngine(ctx.getGraphDatabaseService(), converter);
    }

    @Override
    public Iterable<Map<String, Object>> queryForList(String statement, Map<String, Object> params) {
        return this.queryEngine.query(statement, this.mergeParams(params));
    }

    @Override
    public <T> Iterable<T> query(String statement, Class<T> type, Map<String, Object> params) {
        return this.queryEngine.query(statement, this.mergeParams(params)).to(type);
    }

    @Override
    public <T> T queryForObject(String statement, Class<T> type, Map<String, Object> params) {
        return this.queryEngine.query(statement, this.mergeParams(params)).to(type).single();
    }

    private Map<String, Object> mergeParams(Map<String, Object> params) {
        if (params == null) {
            return Collections.emptyMap();
        }
        return params;
    }
}

