/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.path;

import java.util.ArrayList;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.support.path.IterationController;
import org.springframework.data.neo4j.support.path.PathMapper;

public class PathMappingIterator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Iterable<T> mapPaths(Iterable<Path> paths, final PathMapper<T> pathMapper) {
        assert (paths != null);
        assert (pathMapper != null);
        IterationController.IterationMode mode = this.getIterationControl(pathMapper);
        switch (mode) {
            case EAGER: 
            case EAGER_STOP_ON_NULL: {
                ArrayList<T> result = new ArrayList<T>();
                try {
                    for (Path path : paths) {
                        T mapped = pathMapper.mapPath(path);
                        if (mapped == null && mode == IterationController.IterationMode.EAGER_STOP_ON_NULL) {
                            return result;
                        }
                        result.add(mapped);
                    }
                    return result;
                }
                finally {
                    this.close(paths);
                }
            }
            case EAGER_IGNORE_RESULTS: {
                try {
                    for (Path path : paths) {
                        pathMapper.mapPath(path);
                    }
                    return null;
                }
                finally {
                    this.close(paths);
                }
            }
            case LAZY: {
                return new IterableWrapper<T, Path>(paths){

                    protected T underlyingObjectToObject(Path path) {
                        return pathMapper.mapPath(path);
                    }
                };
            }
        }
        throw new IllegalStateException("Unknown IterationControl " + (Object)((Object)mode));
    }

    private void close(Iterable<Path> paths) {
        if (paths instanceof ClosableIterable) {
            ((ClosableIterable)paths).close();
        }
    }

    private <T> IterationController.IterationMode getIterationControl(PathMapper<T> pathMapper) {
        IterationController.IterationMode result;
        if (pathMapper instanceof IterationController && (result = ((IterationController)((Object)pathMapper)).getIterationMode()) != null) {
            return result;
        }
        return IterationController.IterationMode.LAZY;
    }
}

