/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.kernel.Traversal;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.query.GremlinQueryEngine;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class DelegatingGraphDatabase
implements GraphDatabase {
    protected GraphDatabaseService delegate;
    private ConversionService conversionService;

    public DelegatingGraphDatabase(GraphDatabaseService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Node getNodeById(long id) {
        return this.delegate.getNodeById(id);
    }

    @Override
    public Node createNode(Map<String, Object> props) {
        return this.setProperties(this.delegate.createNode(), props);
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Map<String, Object> properties) {
        assert (primitive != null);
        if (properties == null || properties.isEmpty()) {
            return primitive;
        }
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                primitive.removeProperty(prop.getKey());
                continue;
            }
            primitive.setProperty(prop.getKey(), prop.getValue());
        }
        return primitive;
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.delegate.getRelationshipById(id);
    }

    @Override
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        return this.setProperties(startNode.createRelationshipTo(endNode, type), props);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        IndexManager indexManager = this.delegate.index();
        if (indexManager.existsForNodes(indexName)) {
            return indexManager.forNodes(indexName);
        }
        if (indexManager.existsForRelationships(indexName)) {
            return indexManager.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not exist.");
    }

    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, boolean fullText) {
        IndexManager indexManager = this.delegate.index();
        if (this.isNode(type)) {
            if (indexManager.existsForNodes(indexName)) {
                return this.checkAndGetExistingIndex(indexName, fullText, indexManager.forNodes(indexName));
            }
            return indexManager.forNodes(indexName, this.indexConfigFor(fullText));
        }
        if (indexManager.existsForRelationships(indexName)) {
            return this.checkAndGetExistingIndex(indexName, fullText, (Index<T>)indexManager.forRelationships(indexName));
        }
        return indexManager.forRelationships(indexName, this.indexConfigFor(fullText));
    }

    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    private <T extends PropertyContainer> Index<T> checkAndGetExistingIndex(String indexName, boolean fullText, Index<T> index) {
        Map existingConfig = this.delegate.index().getConfiguration(index);
        Map<String, String> config = this.indexConfigFor(fullText);
        if (config.equals(existingConfig)) {
            return index;
        }
        throw new IllegalArgumentException("Setup for index " + indexName + " does not match " + (fullText ? "fulltext" : "exact"));
    }

    private Map<String, String> indexConfigFor(boolean fullText) {
        return fullText ? LuceneIndexImplementation.FULLTEXT_CONFIG : LuceneIndexImplementation.EXACT_CONFIG;
    }

    @Override
    public TraversalDescription createTraversalDescription() {
        return Traversal.description();
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type) {
        switch (type) {
            case Cypher: {
                return new CypherQueryEngine(this.delegate, this.createResultConverter());
            }
            case Gremlin: {
                return new GremlinQueryEngine(this.delegate);
            }
        }
        throw new IllegalArgumentException("Unknown Query Engine Type " + (Object)((Object)type));
    }

    private ConversionServiceQueryResultConverter createResultConverter() {
        if (this.conversionService == null) {
            return null;
        }
        return new ConversionServiceQueryResultConverter(this.conversionService);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Node getReferenceNode() {
        return this.delegate.getReferenceNode();
    }
}

