/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.GraphId;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.mapping.AnnotationBasedRelationshipInfo;
import org.springframework.data.neo4j.mapping.Neo4JPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;

class Neo4JPersistentPropertyImpl
extends AbstractPersistentProperty<Neo4JPersistentProperty>
implements Neo4JPersistentProperty {
    private final RelationshipInfo relationshipInfo;
    private final boolean isIdProperty;

    public Neo4JPersistentPropertyImpl(Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, Neo4JPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.relationshipInfo = field.isAnnotationPresent(RelatedTo.class) ? new AnnotationBasedRelationshipInfo(field.getAnnotation(RelatedTo.class)) : null;
        this.isIdProperty = field.isAnnotationPresent(GraphId.class);
    }

    public boolean isIdProperty() {
        return this.isIdProperty;
    }

    protected Association<Neo4JPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isRelationship() {
        return this.relationshipInfo != null;
    }

    @Override
    public RelationshipInfo getRelationshipInfo() {
        return this.relationshipInfo;
    }
}

