/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

class ValidatingNodePropertyFieldAccessorListenerFactory<T extends GraphBacked<?>>
implements FieldAccessorListenerFactory<T> {
    private final GraphDatabaseContext graphDatabaseContext;

    ValidatingNodePropertyFieldAccessorListenerFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public boolean accept(Field f) {
        return this.hasValidationAnnotation(f);
    }

    private boolean hasValidationAnnotation(Field f) {
        Annotation[] annotationArray = f.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public FieldAccessListener<T, ?> forField(Field field) {
        return new ValidatingNodePropertyFieldAccessorListener(field, this.graphDatabaseContext.getValidator());
    }

    public static class ValidatingNodePropertyFieldAccessorListener<T extends PropertyContainer>
    implements FieldAccessListener<GraphBacked<T>, Object> {
        private static final Log log = LogFactory.getLog(ValidatingNodePropertyFieldAccessorListener.class);
        private String propertyName;
        private Validator validator;
        private Class<?> entityType;

        public ValidatingNodePropertyFieldAccessorListener(Field field, Validator validator) {
            this.propertyName = field.getName();
            this.entityType = field.getDeclaringClass();
            this.validator = validator;
        }

        @Override
        public void valueChanged(GraphBacked<T> graphBacked, Object oldVal, Object newVal) {
            if (this.validator == null) {
                return;
            }
            Set constraintViolations = this.validator.validateValue(this.entityType, this.propertyName, newVal, new Class[0]);
            if (!constraintViolations.isEmpty()) {
                throw new ValidationException("Error validating field " + this.propertyName + " of " + this.entityType + ": " + constraintViolations);
            }
        }
    }
}

