/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;

public class TransientFieldAccessorFactory
implements FieldAccessorFactory<GraphBacked<PropertyContainer>> {
    @Override
    public boolean accept(Field f) {
        return Modifier.isTransient(f.getModifiers());
    }

    @Override
    public FieldAccessor<GraphBacked<PropertyContainer>> forField(Field field) {
        return new TransientFieldAccessor(field);
    }

    public static class TransientFieldAccessor
    implements FieldAccessor<GraphBacked<PropertyContainer>> {
        protected final Field field;

        public TransientFieldAccessor(Field field) {
            this.field = field;
        }

        @Override
        public Object setValue(GraphBacked<PropertyContainer> graphBacked, Object newVal) {
            return newVal;
        }

        @Override
        public boolean isWriteable(GraphBacked<PropertyContainer> graphBacked) {
            return true;
        }

        @Override
        public Object getValue(GraphBacked<PropertyContainer> graphBacked) {
            return null;
        }
    }
}

