/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import javax.persistence.Id;
import org.neo4j.graphdb.Node;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;

public class JpaIdFieldAccessListenerFactory
implements FieldAccessorListenerFactory<NodeBacked> {
    @Override
    public boolean accept(Field f) {
        return f.isAnnotationPresent(Id.class);
    }

    @Override
    public FieldAccessListener<NodeBacked, ?> forField(Field field) {
        return new JpaIdFieldListener(field);
    }

    public static class JpaIdFieldListener
    implements FieldAccessListener<NodeBacked, Object> {
        protected final Field field;

        public JpaIdFieldListener(Field field) {
            this.field = field;
        }

        @Override
        public void valueChanged(NodeBacked nodeBacked, Object oldVal, Object newVal) {
            if (newVal != null) {
                EntityState<NodeBacked, Node> entityState = Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getEntityState(nodeBacked);
                entityState.persist();
            }
        }
    }
}

