/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.IdFieldAccessorFactory;

public class FieldAccessorFactoryProviders<T> {
    private final Class<T> type;
    private final List<FieldAccessorFactoryProvider<T>> fieldAccessorFactoryProviders = new ArrayList<FieldAccessorFactoryProvider<T>>();
    private final IdFieldAccessorFactory idFieldAccessorFactory;
    private Field idField;

    FieldAccessorFactoryProviders(Class<T> type) {
        this.type = type;
        this.idFieldAccessorFactory = new IdFieldAccessorFactory();
    }

    public Map<Field, FieldAccessor<T>> getFieldAccessors() {
        HashMap<Field, FieldAccessor<T>> result = new HashMap<Field, FieldAccessor<T>>(this.fieldAccessorFactoryProviders.size(), 1.0f);
        for (FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider : this.fieldAccessorFactoryProviders) {
            FieldAccessor<T> accessor = fieldAccessorFactoryProvider.accessor();
            result.put(fieldAccessorFactoryProvider.getField(), accessor);
        }
        return result;
    }

    public Map<Field, List<FieldAccessListener<T, ?>>> getFieldAccessListeners() {
        HashMap result = new HashMap(this.fieldAccessorFactoryProviders.size(), 1.0f);
        for (FieldAccessorFactoryProvider<T> fieldAccessorFactoryProvider : this.fieldAccessorFactoryProviders) {
            List<FieldAccessListener<T, ?>> listeners = fieldAccessorFactoryProvider.listeners();
            result.put(fieldAccessorFactoryProvider.getField(), listeners);
        }
        return result;
    }

    public void add(Field field, FieldAccessorFactory<?> fieldAccessorFactory, List<FieldAccessorListenerFactory> listenerFactories) {
        this.fieldAccessorFactoryProviders.add(new FieldAccessorFactoryProvider(field, fieldAccessorFactory, listenerFactories));
        if (this.idFieldAccessorFactory.accept(field)) {
            this.idField = field;
        }
    }

    public Field getIdField() {
        return this.idField;
    }

    static class FieldAccessorFactoryProvider<E> {
        private final Field field;
        private final FieldAccessorFactory<E> fieldAccessorFactory;
        private final List<FieldAccessorListenerFactory<E>> fieldAccessorListenerFactories;

        FieldAccessorFactoryProvider(Field field, FieldAccessorFactory<E> fieldAccessorFactory, List<FieldAccessorListenerFactory<E>> fieldAccessorListenerFactories) {
            this.field = field;
            this.fieldAccessorFactory = fieldAccessorFactory;
            this.fieldAccessorListenerFactories = fieldAccessorListenerFactories;
        }

        public FieldAccessor<E> accessor() {
            if (this.fieldAccessorFactory == null) {
                return null;
            }
            return this.fieldAccessorFactory.forField(this.field);
        }

        public List<FieldAccessListener<E, ?>> listeners() {
            if (this.fieldAccessorListenerFactories == null) {
                return null;
            }
            ArrayList listeners = new ArrayList(this.fieldAccessorListenerFactories.size());
            for (FieldAccessorListenerFactory<E> fieldAccessorListenerFactory : this.fieldAccessorListenerFactories) {
                listeners.add(fieldAccessorListenerFactory.forField(this.field));
            }
            return listeners;
        }

        public Field getField() {
            return this.field;
        }
    }
}

