/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;

@Configurable
public class ConvertingNodePropertyFieldAccessorFactory
implements FieldAccessorFactory<GraphBacked<PropertyContainer>>,
ConfigurableObject {
    ConversionService conversionService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ConvertingNodePropertyFieldAccessorFactory(ConversionService conversionService) {
        ConversionService conversionService2 = conversionService;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)conversionService2);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.conversionService = conversionService;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    @Override
    public boolean accept(Field field) {
        return this.isSerializableField(field) && this.isDeserializableField(field);
    }

    @Override
    public FieldAccessor<GraphBacked<PropertyContainer>> forField(Field field) {
        return new ConvertingNodePropertyFieldAccessor(this.conversionService, DelegatingFieldAccessorFactory.getNeo4jPropertyName(field), field.getType());
    }

    private boolean isSerializableField(Field field) {
        return this.isSimpleValueField(field) && this.conversionService.canConvert(field.getType(), String.class);
    }

    private boolean isDeserializableField(Field field) {
        return this.isSimpleValueField(field) && this.conversionService.canConvert(String.class, field.getType());
    }

    private boolean isSimpleValueField(Field field) {
        Class<?> type = field.getType();
        return !Iterable.class.isAssignableFrom(type) && !NodeBacked.class.isAssignableFrom(type) && !RelationshipBacked.class.isAssignableFrom(type);
    }

    static {
        ConvertingNodePropertyFieldAccessorFactory.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConvertingNodePropertyFieldAccessorFactory.java", ConvertingNodePropertyFieldAccessorFactory.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 37);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory", "org.springframework.core.convert.ConversionService", "conversionService", ""), 37);
    }

    public static class ConvertingNodePropertyFieldAccessor
    extends PropertyFieldAccessorFactory.PropertyFieldAccessor {
        private final ConversionService conversionService;

        public ConvertingNodePropertyFieldAccessor(ConversionService conversionService, String propertyName, Class fieldType) {
            super(conversionService, propertyName, fieldType);
            this.conversionService = conversionService;
        }

        @Override
        public Object setValue(GraphBacked<PropertyContainer> graphBacked, Object newVal) {
            super.setValue(graphBacked, this.serializePropertyValue(newVal));
            return newVal;
        }

        @Override
        public Object doGetValue(GraphBacked<PropertyContainer> graphBacked) {
            return this.deserializePropertyValue(super.doGetValue(graphBacked));
        }

        private Object serializePropertyValue(Object newVal) {
            return this.conversionService.convert(newVal, String.class);
        }

        private Object deserializePropertyValue(Object value) {
            return this.conversionService.convert(value, this.fieldType);
        }
    }
}

