/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.TYPE})
public @interface Indexed {
    public String indexName() default "";

    public boolean fulltext() default false;

    public String fieldName() default "";

    public static class Name {
        public static String getDefault(Field field) {
            return Name.get(field.getDeclaringClass());
        }

        public static String get(Class<?> type) {
            return Name.getIndexName(type, type.getSimpleName());
        }

        private static String getIndexName(AnnotatedElement element, String defaultIndexName) {
            Indexed indexed = element.getAnnotation(Indexed.class);
            if (indexed == null || indexed.indexName() == null || indexed.indexName().isEmpty()) {
                return defaultIndexName;
            }
            return indexed.indexName();
        }

        public static String get(Field field) {
            return Name.getIndexName(field, Name.getDefault(field));
        }
    }
}

