/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support.typerepresentation;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.NodeTypeRepresentationStrategy;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.core.RelationshipTypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.support.typerepresentation.IndexingNodeTypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.support.typerepresentation.IndexingRelationshipTypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.support.typerepresentation.NoopNodeTypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.support.typerepresentation.NoopRelationshipTypeRepresentationStrategy;
import org.springframework.data.graph.neo4j.support.typerepresentation.SubReferenceNodeTypeRepresentationStrategy;
import org.springframework.data.persistence.EntityInstantiator;

public class TypeRepresentationStrategyFactory {
    private GraphDatabaseService graphDatabaseService;
    private EntityInstantiator<NodeBacked, Node> graphEntityInstantiator;
    private EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator;
    private Strategy strategy;

    public TypeRepresentationStrategyFactory(GraphDatabaseService graphDatabaseService, EntityInstantiator<NodeBacked, Node> graphEntityInstantiator, EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator) {
        this.graphDatabaseService = graphDatabaseService;
        this.graphEntityInstantiator = graphEntityInstantiator;
        this.relationshipEntityInstantiator = relationshipEntityInstantiator;
        this.strategy = this.chooseStrategy();
    }

    private Strategy chooseStrategy() {
        if (this.isAlreadyIndexed()) {
            return Strategy.Indexed;
        }
        if (this.isAlreadySubRef()) {
            return Strategy.SubRef;
        }
        return Strategy.Indexed;
    }

    private boolean isAlreadyIndexed() {
        return this.graphDatabaseService.index().existsForNodes("__types__");
    }

    private boolean isAlreadySubRef() {
        for (Relationship rel : this.graphDatabaseService.getReferenceNode().getRelationships()) {
            if (!rel.getType().name().startsWith("SUBREF_")) continue;
            return true;
        }
        return false;
    }

    public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy() {
        return this.strategy.getNodeTypeRepresentationStrategy(this.graphDatabaseService, this.graphEntityInstantiator);
    }

    public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy() {
        return this.strategy.getRelationshipTypeRepresentationStrategy(this.graphDatabaseService, this.relationshipEntityInstantiator);
    }

    private static enum Strategy {
        SubRef{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<NodeBacked, Node> graphEntityInstantiator) {
                return new SubReferenceNodeTypeRepresentationStrategy(graphDatabaseService, graphEntityInstantiator);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        }
        ,
        Indexed{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<NodeBacked, Node> graphEntityInstantiator) {
                return new IndexingNodeTypeRepresentationStrategy(graphDatabaseService, graphEntityInstantiator);
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator) {
                return new IndexingRelationshipTypeRepresentationStrategy(graphDatabaseService, relationshipEntityInstantiator);
            }
        }
        ,
        Noop{

            @Override
            public NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<NodeBacked, Node> graphEntityInstantiator) {
                return new NoopNodeTypeRepresentationStrategy();
            }

            @Override
            public RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabaseService graphDatabaseService, EntityInstantiator<RelationshipBacked, Relationship> relationshipEntityInstantiator) {
                return new NoopRelationshipTypeRepresentationStrategy();
            }
        };


        public abstract NodeTypeRepresentationStrategy getNodeTypeRepresentationStrategy(GraphDatabaseService var1, EntityInstantiator<NodeBacked, Node> var2);

        public abstract RelationshipTypeRepresentationStrategy getRelationshipTypeRepresentationStrategy(GraphDatabaseService var1, EntityInstantiator<RelationshipBacked, Relationship> var2);
    }
}

