/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support.typerepresentation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.graph.annotation.NodeEntity;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.NodeTypeRepresentationStrategy;
import org.springframework.data.persistence.EntityInstantiator;

public class IndexingNodeTypeRepresentationStrategy
implements NodeTypeRepresentationStrategy {
    public static final String INDEX_NAME = "__types__";
    public static final String TYPE_PROPERTY_NAME = "__type__";
    public static final String INDEX_KEY = "className";
    private EntityInstantiator<NodeBacked, Node> graphEntityInstantiator;
    private GraphDatabaseService graphDb;
    private final Map<String, Class<?>> cache = new HashMap();

    public IndexingNodeTypeRepresentationStrategy(GraphDatabaseService graphDb, EntityInstantiator<NodeBacked, Node> graphEntityInstantiator) {
        this.graphDb = graphDb;
        this.graphEntityInstantiator = graphEntityInstantiator;
    }

    private Index<Node> getNodeTypesIndex() {
        return this.graphDb.index().forNodes(INDEX_NAME);
    }

    private Index<Relationship> getRelTypesIndex() {
        return this.graphDb.index().forRelationships(INDEX_NAME);
    }

    @Override
    public void postEntityCreation(Node state, Class<? extends NodeBacked> type) {
        this.addToNodeTypesIndex(state, type);
        state.setProperty(TYPE_PROPERTY_NAME, (Object)type.getName());
    }

    private void addToNodeTypesIndex(Node node, Class<? extends NodeBacked> entityClass) {
        Class<? extends NodeBacked> klass = entityClass;
        while (klass.getAnnotation(NodeEntity.class) != null) {
            this.getNodeTypesIndex().add((PropertyContainer)node, INDEX_KEY, (Object)klass.getName());
            klass = klass.getSuperclass();
        }
    }

    @Override
    public <U extends NodeBacked> ClosableIterable<U> findAll(Class<U> clazz) {
        return this.findAllNodeBacked(clazz);
    }

    private <ENTITY extends NodeBacked> ClosableIterable<ENTITY> findAllNodeBacked(Class<ENTITY> clazz) {
        IndexHits allEntitiesOfType = this.getNodeTypesIndex().get(INDEX_KEY, (Object)clazz.getName());
        return new FilteringClosableIterable((IndexHits<Node>)allEntitiesOfType);
    }

    @Override
    public long count(Class<? extends NodeBacked> entityClass) {
        long count = 0L;
        Iterator iterator = this.getNodeTypesIndex().get(INDEX_KEY, (Object)entityClass.getName()).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Override
    public Class<? extends NodeBacked> getJavaType(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        String className = (String)node.getProperty(TYPE_PROPERTY_NAME);
        return this.getClassForName(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ENTITY extends GraphBacked<?>> Class<ENTITY> getClassForName(String className) {
        try {
            Class<?> result = this.cache.get(className);
            if (result != null) {
                return result;
            }
            Map<String, Class<?>> map = this.cache;
            synchronized (map) {
                result = this.cache.get(className);
                if (result != null) {
                    return result;
                }
                result = Class.forName(className);
                this.cache.put(className, result);
                return result;
            }
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public void preEntityRemoval(Node state) {
        this.getNodeTypesIndex().remove((PropertyContainer)state);
    }

    @Override
    public <U extends NodeBacked> U createEntity(Node state) {
        Class<? extends NodeBacked> javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on node.");
        }
        return (U)((NodeBacked)this.graphEntityInstantiator.createEntityFromState((Object)state, javaType));
    }

    @Override
    public <U extends NodeBacked> U createEntity(Node state, Class<U> type) {
        Class<? extends NodeBacked> javaType = this.getJavaType(state);
        if (javaType == null) {
            throw new IllegalStateException("No type stored on node.");
        }
        if (type.isAssignableFrom(javaType)) {
            return (U)((NodeBacked)this.graphEntityInstantiator.createEntityFromState((Object)state, javaType));
        }
        throw new IllegalArgumentException(String.format("Entity is not of type: %s (was %s)", type, javaType));
    }

    @Override
    public <U extends NodeBacked> U projectEntity(Node state, Class<U> type) {
        return (U)((NodeBacked)this.graphEntityInstantiator.createEntityFromState((Object)state, type));
    }

    private class FilteringClosableIterable<ENTITY extends NodeBacked>
    extends FilteringIterable<ENTITY>
    implements ClosableIterable<ENTITY> {
        private final IndexHits<Node> indexHits;

        public FilteringClosableIterable(IndexHits<Node> indexHits) {
            super((Iterable)new IterableWrapper<ENTITY, Node>((Iterable)indexHits){

                protected ENTITY underlyingObjectToObject(Node node) {
                    Class<? extends NodeBacked> javaType = IndexingNodeTypeRepresentationStrategy.this.getJavaType(node);
                    if (javaType == null) {
                        return null;
                    }
                    return (NodeBacked)IndexingNodeTypeRepresentationStrategy.this.graphEntityInstantiator.createEntityFromState((Object)node, javaType);
                }
            }, new Predicate<ENTITY>(){

                public boolean accept(ENTITY item) {
                    return item != null;
                }
            });
            this.indexHits = indexHits;
        }

        public void close() {
            this.indexHits.close();
        }
    }
}

