/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support.node;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.neo4j.graphdb.Node;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.graph.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.persistence.EntityInstantiator;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.aspectj.JpaExceptionTranslatorAspect;

public class PartialNodeEntityInstantiator
implements EntityInstantiator<NodeBacked, Node> {
    private final NodeEntityInstantiator delegate;
    private EntityManagerFactory entityManagerFactory;

    public PartialNodeEntityInstantiator(NodeEntityInstantiator delegate, EntityManagerFactory entityManagerFactory) {
        this.delegate = delegate;
        this.entityManagerFactory = entityManagerFactory;
    }

    public <T extends NodeBacked> T createEntityFromState(Node n, Class<T> entityClass) {
        if (n.hasProperty("foreignId")) {
            Object object;
            Object foreignId = n.getProperty("foreignId");
            try {
                object = this.entityManager().find(entityClass, foreignId);
            }
            catch (RuntimeException runtimeException) {
                JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
                throw runtimeException;
            }
            NodeBacked result = (NodeBacked)object;
            Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$setPersistentState(result, n);
            return (T)result;
        }
        return (T)((NodeBacked)this.delegate.createEntityFromState(n, entityClass));
    }

    private EntityManager entityManager() {
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
    }
}

