/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support.node;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.graph.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;

public class NodeEntityState<ENTITY extends NodeBacked>
extends DefaultEntityState<ENTITY, Node> {
    private final GraphDatabaseContext graphDatabaseContext;

    public NodeEntityState(Node underlyingState, ENTITY entity, Class<? extends ENTITY> type, GraphDatabaseContext graphDatabaseContext, NodeDelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory) {
        super(underlyingState, entity, type, nodeDelegatingFieldAccessorFactory);
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public void createAndAssignState() {
        if (this.hasPersistentState()) {
            if (DefaultEntityState.log.isInfoEnabled()) {
                DefaultEntityState.log.info((Object)("Entity " + ((NodeBacked)this.entity).getClass() + " already has persistent state " + this.getPersistentState()));
            }
            return;
        }
        try {
            Object id = this.getIdFromEntity();
            if (id instanceof Number) {
                Node node = this.graphDatabaseContext.getNodeById(((Number)id).longValue());
                this.setPersistentState(node);
                if (DefaultEntityState.log.isInfoEnabled()) {
                    DefaultEntityState.log.info((Object)("Entity reattached " + ((NodeBacked)this.entity).getClass() + "; used Node [" + this.getPersistentState() + "];"));
                }
                return;
            }
            Node node = this.graphDatabaseContext.createNode();
            this.setPersistentState(node);
            if (DefaultEntityState.log.isInfoEnabled()) {
                DefaultEntityState.log.info((Object)("User-defined constructor called on class " + ((NodeBacked)this.entity).getClass() + "; created Node [" + this.getPersistentState() + "]; Updating metamodel"));
            }
            this.graphDatabaseContext.postEntityCreation(node, this.type);
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    @Override
    public ENTITY persist() {
        if (this.getPersistentState() == null) {
            this.createAndAssignState();
        }
        return (ENTITY)((NodeBacked)this.entity);
    }
}

