/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.graph.core.EntityState;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessorFactoryProviders;

public abstract class DefaultEntityState<ENTITY extends GraphBacked<STATE>, STATE>
implements EntityState<ENTITY, STATE> {
    protected final ENTITY entity;
    protected final Class<? extends ENTITY> type;
    private final Map<Field, FieldAccessor<ENTITY>> fieldAccessors = new HashMap<Field, FieldAccessor<ENTITY>>();
    private final Map<Field, List<FieldAccessListener<ENTITY, ?>>> fieldAccessorListeners = new HashMap();
    private STATE state;
    protected static final Log log = LogFactory.getLog(DefaultEntityState.class);
    private final FieldAccessorFactoryProviders<ENTITY> fieldAccessorFactoryProviders;

    public DefaultEntityState(STATE underlyingState, ENTITY entity, Class<? extends ENTITY> type, DelegatingFieldAccessorFactory delegatingFieldAccessorFactory) {
        this.state = underlyingState;
        this.entity = entity;
        this.type = type;
        if (delegatingFieldAccessorFactory != null) {
            this.fieldAccessorFactoryProviders = delegatingFieldAccessorFactory.accessorFactoriesFor(type);
            this.fieldAccessors.putAll(this.fieldAccessorFactoryProviders.getFieldAccessors());
            this.fieldAccessorListeners.putAll(this.fieldAccessorFactoryProviders.getFieldAccessListeners());
        } else {
            this.fieldAccessorFactoryProviders = null;
        }
    }

    @Override
    public abstract void createAndAssignState();

    @Override
    public ENTITY getEntity() {
        return this.entity;
    }

    @Override
    public void setPersistentState(STATE state) {
        this.state = state;
    }

    @Override
    public boolean hasPersistentState() {
        return this.state != null;
    }

    @Override
    public STATE getPersistentState() {
        return this.state;
    }

    @Override
    public boolean isWritable(Field field) {
        FieldAccessor<ENTITY> accessor = this.accessorFor(field);
        if (accessor == null) {
            return true;
        }
        return accessor.isWriteable(this.entity);
    }

    @Override
    public Object getValue(Field field) {
        FieldAccessor<ENTITY> accessor = this.accessorFor(field);
        if (accessor == null) {
            return null;
        }
        return accessor.getValue(this.entity);
    }

    @Override
    public Object setValue(Field field, Object newVal) {
        FieldAccessor<ENTITY> accessor = this.accessorFor(field);
        Object result = accessor != null ? accessor.setValue(this.entity, newVal) : newVal;
        this.notifyListeners(field, result);
        return result;
    }

    protected FieldAccessor<ENTITY> accessorFor(Field field) {
        return this.fieldAccessors.get(field);
    }

    private void notifyListeners(Field field, Object result) {
        if (!this.fieldAccessorListeners.containsKey(field) || this.fieldAccessorListeners.get(field) == null) {
            return;
        }
        for (FieldAccessListener<ENTITY, ?> listener : this.fieldAccessorListeners.get(field)) {
            listener.valueChanged(this.entity, null, result);
        }
    }

    protected Object getIdFromEntity() {
        Field idField = this.fieldAccessorFactoryProviders.getIdField();
        if (idField == null) {
            return null;
        }
        try {
            idField.setAccessible(true);
            return idField.get(this.entity);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)("Error accessing id field " + idField));
            return null;
        }
    }
}

