/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.graph.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;

public abstract class AbstractNodeRelationshipFieldAccessor<ENTITY extends GraphBacked, STATE extends PropertyContainer, TARGET extends GraphBacked, TSTATE extends PropertyContainer>
implements FieldAccessor<ENTITY> {
    protected final RelationshipType type;
    protected final Field field;
    protected final Direction direction;
    protected final Class<? extends TARGET> relatedType;
    protected final GraphDatabaseContext graphDatabaseContext;

    public AbstractNodeRelationshipFieldAccessor(Class<? extends TARGET> clazz, GraphDatabaseContext graphDatabaseContext, Direction direction, RelationshipType type, Field field) {
        this.relatedType = clazz;
        this.graphDatabaseContext = graphDatabaseContext;
        this.direction = direction;
        this.type = type;
        this.field = field;
    }

    @Override
    public boolean isWriteable(ENTITY entity) {
        return true;
    }

    protected STATE checkUnderlyingNode(ENTITY entity) {
        if (entity == null) {
            throw new IllegalStateException("Entity is null");
        }
        STATE node = this.getState(entity);
        if (node != null) {
            return node;
        }
        throw new IllegalStateException("Entity must have a backing Node");
    }

    protected void removeMissingRelationships(Node node, Set<Node> targetNodes) {
        for (Relationship relationship : node.getRelationships(this.type, this.direction)) {
            if (targetNodes.remove(relationship.getOtherNode(node))) continue;
            relationship.delete();
        }
    }

    protected void createAddedRelationships(STATE node, Set<TSTATE> targetNodes) {
        for (PropertyContainer targetNode : targetNodes) {
            this.createSingleRelationship(node, targetNode);
        }
    }

    protected void checkNoCircularReference(Node node, Set<STATE> targetNodes) {
        if (targetNodes.contains(node)) {
            throw new InvalidDataAccessApiUsageException("Cannot create a circular reference to " + targetNodes);
        }
    }

    protected Set<STATE> checkTargetIsSetOfNodebacked(Object newVal) {
        if (!(newVal instanceof Set)) {
            throw new IllegalArgumentException("New value must be a Set, was: " + newVal.getClass());
        }
        HashSet<STATE> nodes = new HashSet<STATE>();
        for (Object value : (Set)newVal) {
            if (!this.relatedType.isInstance(value)) {
                throw new IllegalArgumentException("New value elements must be " + this.relatedType);
            }
            nodes.add(this.getState((GraphBacked)value));
        }
        return nodes;
    }

    protected ManagedFieldAccessorSet<ENTITY, TARGET> createManagedSet(ENTITY entity, Set<TARGET> result) {
        return new ManagedFieldAccessorSet(entity, result, this.field);
    }

    protected Set<TARGET> createEntitySetFromRelationshipEndNodes(ENTITY entity) {
        Iterable<TSTATE> nodes = this.getStatesFromEntity(entity);
        HashSet<TARGET> result = new HashSet<TARGET>();
        for (PropertyContainer otherNode : nodes) {
            TARGET target = this.graphDatabaseContext.createEntityFromState(otherNode, this.relatedType);
            result.add(target);
        }
        return result;
    }

    protected void createSingleRelationship(STATE start, TSTATE end) {
        if (end == null) {
            return;
        }
        switch (this.direction) {
            case OUTGOING: 
            case BOTH: {
                this.obtainSingleRelationship(start, end);
                break;
            }
            case INCOMING: {
                this.obtainSingleRelationship(end, start);
                break;
            }
            default: {
                throw new InvalidDataAccessApiUsageException("invalid direction " + this.direction);
            }
        }
    }

    protected abstract Relationship obtainSingleRelationship(STATE var1, TSTATE var2);

    protected abstract Iterable<TSTATE> getStatesFromEntity(ENTITY var1);

    protected abstract STATE getState(ENTITY var1);
}

