/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.config;

import javax.persistence.EntityManagerFactory;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.kernel.impl.transaction.UserTransactionImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.neo4j.config.ConfigurationCheck;
import org.springframework.data.graph.neo4j.config.NullTransactionManager;
import org.springframework.data.graph.neo4j.fieldaccess.Neo4jConversionServiceFactoryBean;
import org.springframework.data.graph.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.repository.DirectGraphRepositoryFactory;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.graph.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.graph.neo4j.support.node.NodeEntityStateFactory;
import org.springframework.data.graph.neo4j.support.node.PartialNodeEntityInstantiator;
import org.springframework.data.graph.neo4j.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.graph.neo4j.support.relationship.RelationshipEntityInstantiator;
import org.springframework.data.graph.neo4j.support.relationship.RelationshipEntityStateFactory;
import org.springframework.data.graph.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;
import org.springframework.data.graph.neo4j.template.Neo4jExceptionTranslator;
import org.springframework.data.graph.neo4j.transaction.ChainedTransactionManager;
import org.springframework.data.persistence.EntityInstantiator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.UserTransactionAdapter;

@Configuration
public class Neo4jConfiguration {
    private GraphDatabaseService graphDatabaseService;
    @Autowired(required=false)
    private Validator validator;
    private EntityManagerFactory entityManagerFactory;

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    @Autowired
    public void setGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Qualifier(value="&entityManagerFactory")
    @Autowired(required=false)
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public boolean isUsingCrossStorePersistence() {
        return this.entityManagerFactory != null;
    }

    @Bean
    public GraphDatabaseContext graphDatabaseContext() throws Exception {
        RelationshipEntityInstantiator relationshipEntityInstantiator = this.graphRelationshipInstantiator();
        EntityInstantiator<NodeBacked, Node> graphEntityInstantiator = this.graphEntityInstantiator();
        TypeRepresentationStrategyFactory typeRepresentationStrategyFactory = new TypeRepresentationStrategyFactory(this.graphDatabaseService, graphEntityInstantiator, (EntityInstantiator<RelationshipBacked, Relationship>)relationshipEntityInstantiator);
        GraphDatabaseContext gdc = new GraphDatabaseContext();
        gdc.setGraphDatabaseService(this.getGraphDatabaseService());
        gdc.setConversionService(this.conversionService());
        gdc.setNodeTypeRepresentationStrategy(typeRepresentationStrategyFactory.getNodeTypeRepresentationStrategy());
        gdc.setRelationshipTypeRepresentationStrategy(typeRepresentationStrategyFactory.getRelationshipTypeRepresentationStrategy());
        if (this.validator != null) {
            gdc.setValidator(this.validator);
        }
        return gdc;
    }

    @Bean
    protected ConversionService conversionService() throws Exception {
        return new Neo4jConversionServiceFactoryBean().getObject();
    }

    @Bean
    protected RelationshipEntityInstantiator graphRelationshipInstantiator() {
        return new RelationshipEntityInstantiator();
    }

    @Bean
    protected EntityInstantiator<NodeBacked, Node> graphEntityInstantiator() {
        if (this.isUsingCrossStorePersistence()) {
            return new PartialNodeEntityInstantiator(new NodeEntityInstantiator(), this.entityManagerFactory);
        }
        return new NodeEntityInstantiator();
    }

    @Bean
    public DirectGraphRepositoryFactory directGraphRepositoryFactory() throws Exception {
        return new DirectGraphRepositoryFactory(this.graphDatabaseContext());
    }

    @Bean
    public Neo4jRelationshipBacking neo4jRelationshipBacking() throws Exception {
        Neo4jRelationshipBacking aspect = Neo4jRelationshipBacking.aspectOf();
        aspect.setGraphDatabaseContext(this.graphDatabaseContext());
        RelationshipEntityStateFactory entityStateFactory = this.relationshipEntityStateFactory();
        aspect.setRelationshipEntityStateFactory(entityStateFactory);
        return aspect;
    }

    @Bean
    public RelationshipEntityStateFactory relationshipEntityStateFactory() throws Exception {
        RelationshipEntityStateFactory entityStateFactory = new RelationshipEntityStateFactory();
        entityStateFactory.setGraphDatabaseContext(this.graphDatabaseContext());
        return entityStateFactory;
    }

    @Bean
    public Neo4jNodeBacking neo4jNodeBacking() throws Exception {
        Neo4jNodeBacking aspect = Neo4jNodeBacking.aspectOf();
        aspect.setGraphDatabaseContext(this.graphDatabaseContext());
        NodeEntityStateFactory entityStateFactory = this.nodeEntityStateFactory();
        aspect.setNodeEntityStateFactory(entityStateFactory);
        return aspect;
    }

    @Bean
    public NodeEntityStateFactory nodeEntityStateFactory() throws Exception {
        GraphDatabaseContext graphDatabaseContext = this.graphDatabaseContext();
        this.directGraphRepositoryFactory();
        NodeEntityStateFactory entityStateFactory = new NodeEntityStateFactory();
        entityStateFactory.setGraphDatabaseContext(graphDatabaseContext);
        entityStateFactory.setEntityManagerFactory(this.entityManagerFactory);
        NodeDelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory = new NodeDelegatingFieldAccessorFactory(graphDatabaseContext);
        entityStateFactory.setNodeDelegatingFieldAccessorFactory(nodeDelegatingFieldAccessorFactory);
        return entityStateFactory;
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        if (this.isUsingCrossStorePersistence()) {
            JpaTransactionManager jpaTm = new JpaTransactionManager(this.getEntityManagerFactory());
            JtaTransactionManager jtaTm = this.createJtaTransactionManager();
            return new ChainedTransactionManager(new PlatformTransactionManager[]{jpaTm, jtaTm});
        }
        return this.createJtaTransactionManager();
    }

    private JtaTransactionManager createJtaTransactionManager() {
        JtaTransactionManager jtaTm = new JtaTransactionManager();
        GraphDatabaseService gds = this.getGraphDatabaseService();
        if (gds instanceof AbstractGraphDatabase) {
            jtaTm.setTransactionManager((TransactionManager)new SpringTransactionManager(gds));
            jtaTm.setUserTransaction((UserTransaction)new UserTransactionImpl(gds));
        } else {
            NullTransactionManager tm = new NullTransactionManager();
            jtaTm.setTransactionManager((TransactionManager)tm);
            jtaTm.setUserTransaction((UserTransaction)new UserTransactionAdapter((TransactionManager)tm));
        }
        return jtaTm;
    }

    @Bean
    public ConfigurationCheck configurationCheck() throws Exception {
        return new ConfigurationCheck(this.graphDatabaseContext(), this.transactionManager());
    }

    @Bean
    public PersistenceExceptionTranslator persistenceExceptionTranslator() {
        return new Neo4jExceptionTranslator();
    }
}

