/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.data.graph.neo4j.config.DataGraphBeanDefinitionParser;
import org.springframework.data.graph.neo4j.repository.CRUDRepository;
import org.springframework.data.graph.neo4j.repository.GraphRepositoryFactoryBean;
import org.springframework.data.repository.config.AbstractRepositoryConfigDefinitionParser;
import org.springframework.data.repository.config.AutomaticRepositoryConfigInformation;
import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.ManualRepositoryConfigInformation;
import org.springframework.data.repository.config.RepositoryConfig;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DataGraphNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new DataGraphBeanDefinitionParser());
        this.registerBeanDefinitionParser("repositories", (BeanDefinitionParser)new DataGraphRepositoryConfigDefinitionParser());
    }

    private static class DataGraphRepositoryConfigDefinitionParser
    extends AbstractRepositoryConfigDefinitionParser<SimpleDataGraphRepositoryConfiguration, DataGraphRepositoryConfiguration> {
        private DataGraphRepositoryConfigDefinitionParser() {
        }

        protected SimpleDataGraphRepositoryConfiguration getGlobalRepositoryConfigInformation(Element element) {
            return new SimpleDataGraphRepositoryConfiguration(element);
        }

        protected void postProcessBeanDefinition(DataGraphRepositoryConfiguration context, BeanDefinitionBuilder builder, BeanDefinitionRegistry registry, Object beanSource) {
            builder.addPropertyReference("graphDatabaseContext", context.getGraphDatabaseContextRef());
        }

        public static interface DataGraphRepositoryConfiguration
        extends SingleRepositoryConfigInformation<SimpleDataGraphRepositoryConfiguration> {
            public static final String GRAPH_DATABASE_CONTEXT_REF = "graph-database-context-ref";
            public static final String DEFAULT_GRAPH_DATABASE_CONTEXT_REF = "graphDatabaseContext";

            public String getGraphDatabaseContextRef();
        }

        public static class SimpleDataGraphRepositoryConfiguration
        extends RepositoryConfig<DataGraphRepositoryConfiguration, SimpleDataGraphRepositoryConfiguration> {
            protected SimpleDataGraphRepositoryConfiguration(Element repositoriesElement) {
                super(repositoriesElement, GraphRepositoryFactoryBean.class.getName());
            }

            protected DataGraphRepositoryConfiguration createSingleRepositoryConfigInformationFor(Element element) {
                return new ManualDataGraphRepositoryConfiguration(element, this);
            }

            public DataGraphRepositoryConfiguration getAutoconfigRepositoryInformation(String interfaceName) {
                return new AutomaticDataGraphRepositoryConfiguration(interfaceName, this);
            }

            public Class<?> getRepositoryBaseInterface() {
                return CRUDRepository.class;
            }

            public String getGraphDatabaseContextRef() {
                String contextRef = this.getSource().getAttribute("graph-database-context-ref");
                return StringUtils.hasText((String)contextRef) ? contextRef : "graphDatabaseContext";
            }

            private static class AutomaticDataGraphRepositoryConfiguration
            extends AutomaticRepositoryConfigInformation<SimpleDataGraphRepositoryConfiguration>
            implements DataGraphRepositoryConfiguration {
                public AutomaticDataGraphRepositoryConfiguration(String interfaceName, SimpleDataGraphRepositoryConfiguration parent) {
                    super(interfaceName, (CommonRepositoryConfigInformation)parent);
                }

                @Override
                public String getGraphDatabaseContextRef() {
                    return ((SimpleDataGraphRepositoryConfiguration)this.getParent()).getGraphDatabaseContextRef();
                }
            }

            private static class ManualDataGraphRepositoryConfiguration
            extends ManualRepositoryConfigInformation<SimpleDataGraphRepositoryConfiguration>
            implements DataGraphRepositoryConfiguration {
                public ManualDataGraphRepositoryConfiguration(Element element, SimpleDataGraphRepositoryConfiguration parent) {
                    super(element, (CommonRepositoryConfigInformation)parent);
                }

                @Override
                public String getGraphDatabaseContextRef() {
                    return this.getAttribute("graph-database-context-ref");
                }
            }
        }
    }
}

