/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Optional;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;

class DeleteBlocks {
    DeleteBlocks() {
    }

    @NullUnmarked
    static class DeleteExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String queryVariableName;

        DeleteExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        DeleteExecutionCodeBlockBuilder referencing(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            MethodReturn methodReturn = this.context.getMethodReturn();
            Class domainType = this.context.getRepositoryInformation().getDomainType();
            boolean isProjecting = methodReturn.isProjecting();
            Class actualReturnType = isProjecting ? methodReturn.getActualTypeName() : domainType;
            builder.add("\n", new Object[0]);
            VariableSnippet remover = Snippet.declare(builder).variable(ResolvableType.forClassWithGenerics(ExecutableRemoveOperation.ExecutableRemove.class, (Class[])new Class[]{domainType}), this.context.localVariable("remover")).as("$L.remove($T.class)", mongoOpsRef, domainType);
            MongoQueryExecution.DeleteExecution.Type type = MongoQueryExecution.DeleteExecution.Type.FIND_AND_REMOVE_ALL;
            if (!this.queryMethod.isCollectionQuery()) {
                type = !ClassUtils.isPrimitiveOrWrapper(this.context.getMethod().getReturnType()) ? MongoQueryExecution.DeleteExecution.Type.FIND_AND_REMOVE_ONE : MongoQueryExecution.DeleteExecution.Type.ALL;
            }
            Object object = ClassUtils.isPrimitiveOrWrapper(this.context.getMethod().getReturnType()) ? TypeName.get(this.context.getMethod().getReturnType()) : (actualReturnType = this.queryMethod.isCollectionQuery() ? methodReturn.getTypeName() : actualReturnType);
            if (ClassUtils.isVoidType(this.context.getMethod().getReturnType())) {
                builder.addStatement("new $T($L, $T.$L).execute($L)", new Object[]{MongoQueryExecution.DeleteExecution.class, remover.getVariableName(), MongoQueryExecution.DeleteExecution.Type.class, type.name(), this.queryVariableName});
            } else if (this.context.getMethod().getReturnType() == Optional.class) {
                builder.addStatement("return $T.ofNullable(($T) new $T($L, $T.$L).execute($L))", new Object[]{Optional.class, actualReturnType, MongoQueryExecution.DeleteExecution.class, remover.getVariableName(), MongoQueryExecution.DeleteExecution.Type.class, type.name(), this.queryVariableName});
            } else {
                builder.addStatement("return ($T) new $T($L, $T.$L).execute($L)", new Object[]{actualReturnType, MongoQueryExecution.DeleteExecution.class, this.context.localVariable("remover"), MongoQueryExecution.DeleteExecution.Type.class, type.name(), this.queryVariableName});
            }
            return builder.build();
        }
    }
}

