/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public abstract class SerializationUtils {
    private SerializationUtils() {
    }

    public static Map<String, Object> flattenMap(@Nullable Document source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SerializationUtils.toFlatMap("", source, result);
        return result;
    }

    private static void toFlatMap(String currentPath, Object source, Map<String, Object> map) {
        if (source instanceof Document) {
            Object pathPrefix;
            Document document = (Document)source;
            Iterator it = document.entrySet().iterator();
            Object object = pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (((String)entry.getKey()).startsWith("$")) {
                    if (map.containsKey(currentPath)) {
                        ((Document)map.get(currentPath)).put((String)entry.getKey(), entry.getValue());
                        continue;
                    }
                    map.put(currentPath, new Document((String)entry.getKey(), entry.getValue()));
                    continue;
                }
                SerializationUtils.toFlatMap((String)pathPrefix + (String)entry.getKey(), entry.getValue(), map);
            }
        } else {
            map.put(currentPath, source);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String serializeToJsonSafely(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        try {
            String string;
            if (value instanceof Document) {
                Document document = (Document)value;
                string = document.toJson();
            } else {
                string = SerializationUtils.serializeValue(value);
            }
            String json = string;
            return json.replaceAll("\":", "\" :").replaceAll("\\{\"", "{ \"");
        }
        catch (Exception e) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return SerializationUtils.toString(collection);
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return SerializationUtils.toString(map);
            }
            if (ObjectUtils.isArray((Object)value)) {
                return SerializationUtils.toString(Arrays.asList(ObjectUtils.toObjectArray((Object)value)));
            }
            return String.format("{ \"$java\" : %s }", value);
        }
    }

    public static String serializeValue(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        String documentJson = new Document("toBeEncoded", value).toJson();
        return documentJson.substring(documentJson.indexOf(58) + 1, documentJson.length() - 1).trim();
    }

    private static String toString(Map<?, ?> source) {
        return SerializationUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", entry -> String.format("\"%s\" : %s", entry.getKey(), SerializationUtils.serializeToJsonSafely(entry.getValue())));
    }

    private static String toString(Collection<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "[ ", " ]", SerializationUtils::serializeToJsonSafely);
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String postfix, Converter<? super T, Object> transformer) {
        StringBuilder builder = new StringBuilder(prefix);
        Iterator<T> iterator = source.iterator();
        while (iterator.hasNext()) {
            builder.append(transformer.convert(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append(postfix).toString();
    }
}

