/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MongoConverter
extends EntityConverter<MongoPersistentEntity<?>, MongoPersistentProperty, Object, Bson>,
MongoWriter<Object>,
EntityReader<Object, Bson>,
CodecRegistryProvider {
    public MongoTypeMapper getTypeMapper();

    public ProjectionFactory getProjectionFactory();

    public CustomConversions getCustomConversions();

    public <R> R project(EntityProjection<R, ?> var1, Bson var2);

    default public <S, T> @Nullable T mapValueToTargetType(S source, Class<T> targetType, DbRefResolver dbRefResolver) {
        Assert.notNull(targetType, (String)"TargetType must not be null");
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null");
        if (targetType != Object.class && ClassUtils.isAssignable(targetType, source.getClass())) {
            return (T)source;
        }
        if (source instanceof BsonValue) {
            BsonValue bson = (BsonValue)source;
            Object value = BsonUtils.toJavaType(bson);
            if (value instanceof Document) {
                Document document = (Document)value;
                if (document.containsKey((Object)"$ref") && document.containsKey((Object)"$id")) {
                    DBRef ref;
                    Object id = document.get((Object)"$id");
                    String collection = document.getString((Object)"$ref");
                    MongoPersistentEntity entity = (MongoPersistentEntity)this.getMappingContext().getPersistentEntity(targetType);
                    if (entity != null && entity.hasIdProperty()) {
                        id = this.convertId(id, ((MongoPersistentProperty)entity.getIdProperty()).getFieldType());
                    }
                    if ((document = dbRefResolver.fetch(ref = document.containsKey((Object)"$db") ? new DBRef(document.getString((Object)"$db"), collection, id) : new DBRef(collection, id))) == null) {
                        return null;
                    }
                }
                return (T)this.read(targetType, document);
            }
            if (!ClassUtils.isAssignable(targetType, value.getClass()) && this.getConversionService().canConvert(value.getClass(), targetType)) {
                return (T)this.getConversionService().convert(value, targetType);
            }
            return (T)value;
        }
        return (T)this.getConversionService().convert(source, targetType);
    }

    default public @Nullable Object convertId(@Nullable Object id, Class<?> targetType) {
        if (id == null || ClassUtils.isAssignableValue(targetType, (Object)id)) {
            return id;
        }
        if (ClassUtils.isAssignable(ObjectId.class, targetType) && id instanceof String) {
            if (ObjectId.isValid((String)id.toString())) {
                return new ObjectId(id.toString());
            }
            return id;
        }
        try {
            return this.getConversionService().canConvert(id.getClass(), targetType) ? this.getConversionService().convert(id, targetType) : this.convertToMongoType(id, null);
        }
        catch (ConversionException o_O) {
            return this.convertToMongoType(id, null);
        }
    }

    @Override
    default public CodecRegistry getCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }
}

