/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.FieldLookupPolicy;

class InheritingExposedFieldsAggregationOperationContext
extends ExposedFieldsAggregationOperationContext {
    private final AggregationOperationContext previousContext;

    public InheritingExposedFieldsAggregationOperationContext(ExposedFields exposedFields, AggregationOperationContext previousContext, FieldLookupPolicy lookupPolicy) {
        super(exposedFields, previousContext, lookupPolicy);
        this.previousContext = previousContext;
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.previousContext.getMappedObject(document);
    }

    @Override
    protected ExposedFields.FieldReference resolveExposedField(@Nullable Field field, String name) {
        ExposedFields.FieldReference fieldReference = super.resolveExposedField(field, name);
        if (fieldReference != null) {
            return fieldReference;
        }
        if (field != null) {
            return this.previousContext.getReference(field);
        }
        return this.previousContext.getReference(name);
    }
}

