/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.ReplaceOptions;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

class ReactiveUpdateOperationSupport
implements ReactiveUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveMongoTemplate template;

    ReactiveUpdateOperationSupport(ReactiveMongoTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveUpdateOperation.ReactiveUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveUpdateSupport(this.template, domainType, ALL_QUERY, null, null, null, null, null, domainType, QueryResultConverter.entity());
    }

    static class ReactiveUpdateSupport<S, T>
    implements ReactiveUpdateOperation.ReactiveUpdate<T>,
    ReactiveUpdateOperation.UpdateWithCollection<T>,
    ReactiveUpdateOperation.UpdateWithQuery<T>,
    ReactiveUpdateOperation.TerminatingUpdate<T>,
    ReactiveUpdateOperation.FindAndReplaceWithOptions<T>,
    ReactiveUpdateOperation.FindAndReplaceWithProjection<T>,
    ReactiveUpdateOperation.TerminatingFindAndReplace<T> {
        private final ReactiveMongoTemplate template;
        private final Class<?> domainType;
        private final Query query;
        private final @Nullable UpdateDefinition update;
        private final @Nullable String collection;
        private final @Nullable FindAndModifyOptions findAndModifyOptions;
        private final @Nullable FindAndReplaceOptions findAndReplaceOptions;
        private final @Nullable Object replacement;
        private final Class<S> targetType;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;

        ReactiveUpdateSupport(ReactiveMongoTemplate template, Class<?> domainType, Query query, @Nullable UpdateDefinition update, @Nullable String collection, @Nullable FindAndModifyOptions findAndModifyOptions, @Nullable FindAndReplaceOptions findAndReplaceOptions, @Nullable Object replacement, Class<S> targetType, QueryResultConverter<? super S, ? extends T> resultConverter) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.findAndModifyOptions = findAndModifyOptions;
            this.findAndReplaceOptions = findAndReplaceOptions;
            this.replacement = replacement;
            this.targetType = targetType;
            this.resultConverter = resultConverter;
        }

        @Override
        public ReactiveUpdateOperation.TerminatingUpdate<T> apply(UpdateDefinition update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public Mono<UpdateResult> first() {
            return this.doUpdate(false, false);
        }

        @Override
        public Mono<UpdateResult> upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        public Mono<T> findAndModify() {
            String collectionName = this.getCollectionName();
            return this.template.findAndModify(this.query, this.update, this.findAndModifyOptions != null ? this.findAndModifyOptions : FindAndModifyOptions.none(), this.targetType, collectionName, this.resultConverter);
        }

        @Override
        public Mono<T> findAndReplace() {
            Assert.notNull((Object)this.replacement, (String)"Replacement must be set first");
            return this.template.findAndReplace(this.query, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : FindAndReplaceOptions.none(), this.domainType, this.getCollectionName(), this.targetType, this.resultConverter);
        }

        @Override
        public ReactiveUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public Mono<UpdateResult> all() {
            return this.doUpdate(true, false);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, options, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public ReactiveUpdateOperation.FindAndReplaceWithProjection<T> replaceWith(T replacement) {
            Assert.notNull(replacement, (String)"Replacement must not be null");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, replacement, this.targetType, this.resultConverter);
        }

        @Override
        public ReactiveUpdateOperation.FindAndReplaceWithProjection<T> withOptions(FindAndReplaceOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, options, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public ReactiveUpdateOperation.TerminatingReplace withOptions(ReplaceOptions options) {
            FindAndReplaceOptions target = new FindAndReplaceOptions();
            if (options.isUpsert()) {
                target.upsert();
            }
            return new ReactiveUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, target, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        public <R> ReactiveUpdateOperation.FindAndReplaceWithOptions<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null");
            return new ReactiveUpdateSupport(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, resultType, QueryResultConverter.entity());
        }

        public <R> ReactiveUpdateSupport<S, R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new ReactiveUpdateSupport<S, R>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter.andThen(converter));
        }

        @Override
        public Mono<UpdateResult> replaceFirst() {
            if (this.replacement != null) {
                return this.template.replace(this.query, this.domainType, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : ReplaceOptions.none(), this.getCollectionName());
            }
            return this.template.replace(this.query, this.domainType, this.update, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : ReplaceOptions.none(), this.getCollectionName());
        }

        private Mono<UpdateResult> doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

