/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public interface ReactiveMongoDatabaseFactory
extends CodecRegistryProvider {
    public static SimpleReactiveMongoDatabaseFactory create(String connectionString) {
        Assert.notNull((Object)connectionString, (String)"ConnectionString must not be null");
        return ReactiveMongoDatabaseFactory.create(new ConnectionString(connectionString));
    }

    public static SimpleReactiveMongoDatabaseFactory create(ConnectionString connectionString) {
        Assert.notNull((Object)connectionString, (String)"ConnectionString must not be null");
        return new SimpleReactiveMongoDatabaseFactory(connectionString);
    }

    public static ReactiveMongoDatabaseFactory create(MongoClient mongoClient, String databaseName) {
        return new SimpleReactiveMongoDatabaseFactory(mongoClient, databaseName);
    }

    public Mono<MongoDatabase> getMongoDatabase() throws DataAccessException;

    public Mono<MongoDatabase> getMongoDatabase(String var1) throws DataAccessException;

    public PersistenceExceptionTranslator getExceptionTranslator();

    @Override
    public CodecRegistry getCodecRegistry();

    public Mono<ClientSession> getSession(ClientSessionOptions var1);

    public ReactiveMongoDatabaseFactory withSession(ClientSession var1);

    default public boolean isTransactionActive() {
        return false;
    }
}

