/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.TransactionMetadata;
import org.springframework.data.mongodb.core.ReadConcernAware;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.data.mongodb.core.WriteConcernAware;
import org.springframework.lang.Contract;

public interface MongoTransactionOptions
extends TransactionMetadata,
ReadConcernAware,
ReadPreferenceAware,
WriteConcernAware {
    public static final MongoTransactionOptions NONE = new MongoTransactionOptions(){

        @Override
        public @Nullable Duration getMaxCommitTime() {
            return null;
        }

        @Override
        public @Nullable ReadConcern getReadConcern() {
            return null;
        }

        @Override
        public @Nullable ReadPreference getReadPreference() {
            return null;
        }

        @Override
        public @Nullable WriteConcern getWriteConcern() {
            return null;
        }
    };

    @Contract(value="null -> this")
    default public MongoTransactionOptions mergeWith(final @Nullable MongoTransactionOptions fallbackOptions) {
        if (fallbackOptions == null || NONE.equals(fallbackOptions)) {
            return this;
        }
        return new MongoTransactionOptions(){
            final /* synthetic */ MongoTransactionOptions this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public @Nullable Duration getMaxCommitTime() {
                return this.this$0.hasMaxCommitTime() ? this.this$0.getMaxCommitTime() : fallbackOptions.getMaxCommitTime();
            }

            @Override
            public @Nullable ReadConcern getReadConcern() {
                return this.this$0.hasReadConcern() ? this.this$0.getReadConcern() : fallbackOptions.getReadConcern();
            }

            @Override
            public @Nullable ReadPreference getReadPreference() {
                return this.this$0.hasReadPreference() ? this.this$0.getReadPreference() : fallbackOptions.getReadPreference();
            }

            @Override
            public @Nullable WriteConcern getWriteConcern() {
                return this.this$0.hasWriteConcern() ? this.this$0.getWriteConcern() : fallbackOptions.getWriteConcern();
            }
        };
    }

    default public <T> T map(Function<MongoTransactionOptions, T> mappingFunction) {
        return mappingFunction.apply(this);
    }

    default public @Nullable TransactionOptions toDriverOptions() {
        return this.map(it -> {
            if (NONE.equals(it)) {
                return null;
            }
            TransactionOptions.Builder builder = TransactionOptions.builder();
            if (it.hasMaxCommitTime()) {
                builder.maxCommitTime(Long.valueOf(it.getMaxCommitTime().toMillis()), TimeUnit.MILLISECONDS);
            }
            if (it.hasReadConcern()) {
                builder.readConcern(it.getReadConcern());
            }
            if (it.hasReadPreference()) {
                builder.readPreference(it.getReadPreference());
            }
            if (it.hasWriteConcern()) {
                builder.writeConcern(it.getWriteConcern());
            }
            return builder.build();
        });
    }

    public static MongoTransactionOptions of(final @Nullable TransactionOptions options) {
        if (options == null) {
            return NONE;
        }
        return new MongoTransactionOptions(){

            @Override
            public @Nullable Duration getMaxCommitTime() {
                Long millis = options.getMaxCommitTime(TimeUnit.MILLISECONDS);
                return millis != null ? Duration.ofMillis(millis) : null;
            }

            @Override
            public @Nullable ReadConcern getReadConcern() {
                return options.getReadConcern();
            }

            @Override
            public @Nullable ReadPreference getReadPreference() {
                return options.getReadPreference();
            }

            @Override
            public @Nullable WriteConcern getWriteConcern() {
                return options.getWriteConcern();
            }

            @Override
            public @Nullable TransactionOptions toDriverOptions() {
                return options;
            }
        };
    }
}

