/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.core.ResolvableType;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.ManagedTypesBeanRegistrationAotProcessor;
import org.springframework.data.mongodb.MongoManagedTypes;
import org.springframework.data.mongodb.aot.LazyLoadingProxyAotProcessor;
import org.springframework.util.ClassUtils;

class MongoManagedTypesBeanRegistrationAotProcessor
extends ManagedTypesBeanRegistrationAotProcessor {
    private final LazyLoadingProxyAotProcessor lazyLoadingProxyAotProcessor = new LazyLoadingProxyAotProcessor();

    public MongoManagedTypesBeanRegistrationAotProcessor() {
        this.setModuleIdentifier("mongo");
    }

    protected boolean isMatch(@Nullable Class<?> beanType, @Nullable String beanName) {
        return this.isMongoManagedTypes(beanType) || super.isMatch(beanType, beanName);
    }

    protected boolean isMongoManagedTypes(@Nullable Class<?> beanType) {
        return beanType != null && ClassUtils.isAssignable(MongoManagedTypes.class, beanType);
    }

    protected void registerTypeHints(ResolvableType type, AotContext aotContext, GenerationContext generationContext) {
        super.registerTypeHints(type, aotContext, generationContext);
        this.lazyLoadingProxyAotProcessor.registerLazyLoadingProxyIfNeeded(type.toClass(), generationContext);
    }
}

