/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.repository.aot.ExpressionSnippet;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;

class VariableSnippet
extends ExpressionSnippet {
    private final String variableName;
    private final @Nullable TypeName typeName;

    public VariableSnippet(String variableName, Snippet delegate) {
        this((TypeName)null, variableName, delegate);
    }

    public VariableSnippet(Class<?> typeName, String variableName, Snippet delegate) {
        this(TypeName.get(typeName), variableName, delegate);
    }

    public VariableSnippet(@Nullable TypeName typeName, String variableName, Snippet delegate) {
        super(delegate);
        this.typeName = typeName;
        this.variableName = variableName;
    }

    static VariableBuilderImp variable(String name) {
        return new VariableBuilderImp(null, name);
    }

    static VariableBuilderImp variable(Class<?> typeName, String name) {
        return VariableSnippet.variable(TypeName.get(typeName), name);
    }

    static VariableBuilderImp variable(ResolvableType resolvableType, String name) {
        return VariableSnippet.variable(TypeName.get((Type)resolvableType.getType()), name);
    }

    static VariableBuilderImp variable(TypeName typeName, String name) {
        return new VariableBuilderImp(typeName, name);
    }

    @Override
    public CodeBlock code() {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{this.variableName});
    }

    public String getVariableName() {
        return this.variableName;
    }

    void renderDeclaration(CodeBlock.Builder builder) {
        if (this.typeName != null) {
            builder.addStatement("$T $L = $L", new Object[]{this.typeName, this.variableName, super.code()});
        } else {
            builder.addStatement("var $L = $L", new Object[]{this.variableName, super.code()});
        }
    }

    static VariableBlockBuilder create(Snippet snippet) {
        return variableName -> VariableSnippet.create(variableName, snippet);
    }

    static VariableSnippet create(String variableName, Snippet snippet) {
        return new VariableSnippet(variableName, snippet);
    }

    static class VariableBuilderImp
    implements Snippet.VariableBuilder {
        private final @Nullable TypeName typeName;
        private final String variableName;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable CodeBlock.Builder target;

        VariableBuilderImp(@Nullable TypeName typeName, String variableName) {
            this.typeName = typeName;
            this.variableName = variableName;
        }

        @Override
        public VariableSnippet of(CodeBlock codeBlock) {
            VariableSnippet variableSnippet = new VariableSnippet(this.typeName, this.variableName, Snippet.just(codeBlock));
            if (this.target != null) {
                variableSnippet.renderDeclaration(this.target);
            }
            return variableSnippet;
        }

        VariableBuilderImp appendTo(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable CodeBlock.Builder target) {
            this.target = target;
            return this;
        }
    }

    static interface VariableBlockBuilder {
        public VariableSnippet variableName(String var1);
    }
}

