/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

record DefaultDbRefProxyHandler(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, ValueResolver resolver, Function<Object, ValueExpressionEvaluator> evaluatorFactory) implements DbRefProxyHandler
{
    @Override
    public Object populateId(MongoPersistentProperty property, @Nullable DBRef source, Object proxy) {
        if (source == null) {
            return proxy;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
        if (idProperty.usePropertyAccess()) {
            return proxy;
        }
        ValueExpressionEvaluator evaluator = this.evaluatorFactory.apply(proxy);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(() -> proxy);
        Document object = new Document(idProperty.getFieldName(), source.getId());
        ObjectPath objectPath = ObjectPath.ROOT.push(proxy, entity, null);
        accessor.setProperty((PersistentProperty)idProperty, this.resolver.getValueInternal(idProperty, (Bson)object, evaluator, objectPath));
        return proxy;
    }
}

