/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.repository.aot.BuilderStyleSnippet;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.javapoet.CodeBlock;

interface Snippet {
    public CodeBlock code();

    default public boolean isEmpty() {
        return this.code().isEmpty();
    }

    default public void appendTo(CodeBlock.Builder builder) {
        if (!this.isEmpty()) {
            builder.add(this.code());
        }
    }

    default public <T> T as(Function<? super Snippet, T> transformer) {
        return transformer.apply(this);
    }

    default public Snippet wrap(String prefix, String suffix) {
        return this.wrap("%s$L%s".formatted(prefix, suffix));
    }

    default public Snippet wrap(final CodeBlock prefix, final CodeBlock suffix) {
        return new Snippet(){
            final /* synthetic */ Snippet this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CodeBlock code() {
                return CodeBlock.builder().add(prefix).add(this.this$0.code()).add(suffix).build();
            }
        };
    }

    default public Snippet wrap(final String statement) {
        return new Snippet(){
            final /* synthetic */ Snippet this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CodeBlock code() {
                return CodeBlock.of((String)statement, (Object[])new Object[]{this.this$0.code()});
            }
        };
    }

    public static Snippet just(final CodeBlock codeBlock) {
        return new Snippet(){

            @Override
            public CodeBlock code() {
                return codeBlock;
            }
        };
    }

    public static ContextualSnippetBuilder declare(final CodeBlock.Builder builder) {
        return new ContextualSnippetBuilder(){

            @Override
            public VariableBuilder variable(String variableName) {
                return VariableSnippet.variable(variableName).appendTo(builder);
            }

            @Override
            public VariableBuilder variable(Class<?> type, String variableName) {
                return VariableSnippet.variable(type, variableName).appendTo(builder);
            }

            @Override
            public VariableBuilder variable(ResolvableType resolvableType, String variableName) {
                return VariableSnippet.variable(resolvableType, variableName).appendTo(builder);
            }

            @Override
            public BuilderStyleVariableBuilder variableBuilder(String variableName) {
                return new BuilderStyleVariableBuilder.BuilderStyleVariableBuilderImpl(builder, null, variableName);
            }

            @Override
            public BuilderStyleVariableBuilder variableBuilder(Class<?> type, String variableName) {
                return this.variableBuilder(ResolvableType.forClass(type), variableName);
            }

            @Override
            public BuilderStyleVariableBuilder variableBuilder(ResolvableType resolvableType, String variableName) {
                return new BuilderStyleVariableBuilder.BuilderStyleVariableBuilderImpl(builder, resolvableType, variableName);
            }
        };
    }

    public static interface BuilderStyleBuilder {
        public BuilderStyleMethodArgumentBuilder call(String var1);

        public VariableSnippet variable();

        public static interface BuilderStyleMethodArgumentBuilder {
            default public BuilderStyleBuilder with(String statement, Object ... args) {
                return this.with(CodeBlock.of((String)statement, (Object[])args));
            }

            default public BuilderStyleBuilder with(CodeBlock codeBlock) {
                return this.with(Snippet.just(codeBlock));
            }

            public BuilderStyleBuilder with(Snippet var1);
        }
    }

    public static interface BuilderStyleVariableBuilder {
        default public BuilderStyleBuilder as(String declaration, Object ... args) {
            return this.of(CodeBlock.of((String)declaration, (Object[])args));
        }

        public BuilderStyleBuilder of(CodeBlock var1);

        public static class BuilderStyleVariableBuilderImpl
        implements BuilderStyleVariableBuilder,
        BuilderStyleBuilder,
        BuilderStyleBuilder.BuilderStyleMethodArgumentBuilder {
            CodeBlock.Builder targetBuilder;
            @Nullable ResolvableType type;
            String targetVariableName;
            @Nullable String targetMethodName;
            @Nullable VariableSnippet variableSnippet;

            public BuilderStyleVariableBuilderImpl(CodeBlock.Builder targetBuilder, @Nullable ResolvableType type, String targetVariableName) {
                this.targetBuilder = targetBuilder;
                this.type = type;
                this.targetVariableName = targetVariableName;
            }

            @Override
            public BuilderStyleBuilder as(String declaration, Object ... args) {
                this.variableSnippet = this.type != null ? Snippet.declare(this.targetBuilder).variable(this.type, this.targetVariableName).as(declaration, args) : Snippet.declare(this.targetBuilder).variable(this.targetVariableName).as(declaration, args);
                return this;
            }

            @Override
            public BuilderStyleBuilder of(CodeBlock codeBlock) {
                this.variableSnippet = this.type != null ? Snippet.declare(this.targetBuilder).variable(this.type, this.targetVariableName).of(codeBlock) : Snippet.declare(this.targetBuilder).variable(this.targetVariableName).of(codeBlock);
                return this;
            }

            @Override
            public BuilderStyleBuilder.BuilderStyleMethodArgumentBuilder call(String methodName) {
                this.targetMethodName = methodName;
                return this;
            }

            @Override
            public BuilderStyleBuilder with(Snippet snippet) {
                new BuilderStyleSnippet(this.targetVariableName, this.targetMethodName, snippet).appendTo(this.targetBuilder);
                return this;
            }

            @Override
            public VariableSnippet variable() {
                return this.variableSnippet;
            }
        }
    }

    public static interface VariableBuilder {
        default public VariableSnippet as(String declaration, Object ... args) {
            return this.of(CodeBlock.of((String)declaration, (Object[])args));
        }

        public VariableSnippet of(CodeBlock var1);
    }

    public static interface ContextualSnippetBuilder {
        public VariableBuilder variable(String var1);

        public VariableBuilder variable(Class<?> var1, String var2);

        public VariableBuilder variable(ResolvableType var1, String var2);

        public BuilderStyleVariableBuilder variableBuilder(String var1);

        public BuilderStyleVariableBuilder variableBuilder(Class<?> var1, String var2);

        public BuilderStyleVariableBuilder variableBuilder(ResolvableType var1, String var2);
    }
}

