/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ExecutableFindOperationSupport
implements ExecutableFindOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate template;

    ExecutableFindOperationSupport(MongoTemplate template) {
        this.template = template;
    }

    @Override
    @Contract(value="_ -> new")
    public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableFindSupport(this.template, domainType, domainType, QueryResultConverter.entity(), null, ALL_QUERY);
    }

    static class ExecutableFindSupport<S, T>
    implements ExecutableFindOperation.ExecutableFind<T>,
    ExecutableFindOperation.FindWithCollection<T>,
    ExecutableFindOperation.FindWithProjection<T>,
    ExecutableFindOperation.FindWithQuery<T> {
        private final MongoTemplate template;
        private final Class<?> domainType;
        private final Class<S> returnType;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;
        private final @Nullable String collection;
        private final Query query;

        ExecutableFindSupport(MongoTemplate template, Class<?> domainType, Class<S> returnType, QueryResultConverter<? super S, ? extends T> resultConverter, @Nullable String collection, Query query) {
            this.template = template;
            this.domainType = domainType;
            this.resultConverter = resultConverter;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableFindOperation.FindWithProjection<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection name must not be null nor empty");
            return new ExecutableFindSupport<S, T>(this.template, this.domainType, this.returnType, this.resultConverter, collection, this.query);
        }

        @Override
        @Contract(value="_ -> new")
        public <T1> ExecutableFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableFindSupport(this.template, this.domainType, returnType, QueryResultConverter.entity(), this.collection, this.query);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableFindOperation.TerminatingFind<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ExecutableFindSupport<S, T>(this.template, this.domainType, this.returnType, this.resultConverter, this.collection, query);
        }

        @Override
        public <R> ExecutableFindOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"QueryResultConverter must not be null");
            return new ExecutableFindSupport<S, R>(this.template, this.domainType, this.returnType, this.resultConverter.andThen(converter), this.collection, this.query);
        }

        @Override
        public @Nullable T oneValue() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(2));
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException("Query " + this.asString() + " returned non unique result", 1);
            }
            return result.iterator().next();
        }

        @Override
        public @Nullable T firstValue() {
            List<T> result = this.doFind(new DelegatingQueryCursorPreparer(this.getCursorPreparer(this.query, null)).limit(1));
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.doFind(null);
        }

        @Override
        public Stream<T> stream() {
            return this.doStream();
        }

        @Override
        public Window<T> scroll(ScrollPosition scrollPosition) {
            return this.template.doScroll(this.query.with(scrollPosition), this.domainType, this.returnType, this.resultConverter, this.getCollectionName());
        }

        @Override
        public ExecutableFindOperation.TerminatingFindNear<T> near(NearQuery nearQuery) {
            return new TerminatingFindNearSupport<T>(nearQuery, this.resultConverter);
        }

        @Override
        public long count() {
            return this.template.count(this.query, this.domainType, this.getCollectionName());
        }

        @Override
        public boolean exists() {
            return this.template.exists(this.query, this.domainType, this.getCollectionName());
        }

        @Override
        public ExecutableFindOperation.TerminatingDistinct<Object> distinct(String field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new DistinctOperationSupport(this, field);
        }

        private List<T> doFind(@Nullable CursorPreparer preparer) {
            Document queryObject = this.query.getQueryObject();
            Document fieldsObject = this.query.getFieldsObject();
            return this.template.doFind(this.template.createDelegate(this.query), this.getCollectionName(), queryObject, fieldsObject, this.domainType, this.returnType, this.resultConverter, this.getCursorPreparer(this.query, preparer));
        }

        private List<T> doFindDistinct(String field) {
            return this.template.findDistinct(this.query, field, this.getCollectionName(), this.domainType, this.returnType == this.domainType ? Object.class : this.returnType);
        }

        private Stream<T> doStream() {
            return this.template.doStream(this.query, this.domainType, this.getCollectionName(), this.returnType, this.resultConverter);
        }

        private CursorPreparer getCursorPreparer(Query query, @Nullable CursorPreparer preparer) {
            CursorPreparer cursorPreparer;
            if (preparer != null) {
                cursorPreparer = preparer;
            } else {
                MongoTemplate mongoTemplate = this.template;
                Objects.requireNonNull(mongoTemplate);
                cursorPreparer = mongoTemplate.new MongoTemplate.QueryCursorPreparer(query, this.domainType);
            }
            return cursorPreparer;
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }

        private String asString() {
            return SerializationUtils.serializeToJsonSafely(this.query);
        }

        class TerminatingFindNearSupport<G>
        implements ExecutableFindOperation.TerminatingFindNear<G> {
            private final NearQuery nearQuery;
            private final QueryResultConverter<? super S, ? extends G> resultConverter;

            public TerminatingFindNearSupport(NearQuery nearQuery, QueryResultConverter<? super S, ? extends G> resultConverter) {
                this.nearQuery = nearQuery;
                this.resultConverter = resultConverter;
            }

            @Override
            public <R> ExecutableFindOperation.TerminatingFindNear<R> map(QueryResultConverter<? super G, ? extends R> converter) {
                Assert.notNull(converter, (String)"QueryResultConverter must not be null");
                return new TerminatingFindNearSupport<R>(this.nearQuery, this.resultConverter.andThen(converter));
            }

            @Override
            public GeoResults<G> all() {
                return ExecutableFindSupport.this.template.doGeoNear(this.nearQuery, ExecutableFindSupport.this.domainType, ExecutableFindSupport.this.getCollectionName(), ExecutableFindSupport.this.returnType, this.resultConverter);
            }
        }
    }

    static class DistinctOperationSupport<S, T>
    implements ExecutableFindOperation.TerminatingDistinct<T> {
        private final String field;
        private final ExecutableFindSupport<S, T> delegate;

        public DistinctOperationSupport(ExecutableFindSupport<S, T> delegate, String field) {
            this.delegate = delegate;
            this.field = field;
        }

        @Override
        @Contract(value="_ -> new")
        public <R> ExecutableFindOperation.TerminatingDistinct<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null");
            return new DistinctOperationSupport<S, T>((ExecutableFindSupport)this.delegate.as(resultType), this.field);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableFindOperation.TerminatingDistinct<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new DistinctOperationSupport<S, T>((ExecutableFindSupport)this.delegate.matching(query), this.field);
        }

        @Override
        public List<T> all() {
            return this.delegate.doFindDistinct(this.field);
        }
    }

    static class DelegatingQueryCursorPreparer
    implements CursorPreparer {
        private final @Nullable CursorPreparer delegate;
        private int limit = -1;

        DelegatingQueryCursorPreparer(@Nullable CursorPreparer delegate) {
            this.delegate = delegate;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> iterable) {
            FindIterable<Document> target;
            FindIterable<Document> findIterable = target = this.delegate != null ? this.delegate.prepare(iterable) : iterable;
            if (this.limit >= 0) {
                target.limit(this.limit);
            }
            return target;
        }

        @Contract(value="_ -> this")
        CursorPreparer limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public @Nullable ReadPreference getReadPreference() {
            return this.delegate != null ? this.delegate.getReadPreference() : null;
        }
    }
}

