/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bson.Document;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.BasicUpdate;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.Hint;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.aot.AggregationInteraction;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.aot.UpdateInteraction;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MongoCodeBlocks {
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");

    MongoCodeBlocks() {
    }

    static QueryCodeBlockBuilder queryBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryCodeBlockBuilder(context, queryMethod);
    }

    static QueryExecutionCodeBlockBuilder queryExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryExecutionCodeBlockBuilder(context, queryMethod);
    }

    static DeleteExecutionCodeBlockBuilder deleteExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new DeleteExecutionCodeBlockBuilder(context, queryMethod);
    }

    static UpdateCodeBlockBuilder updateBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new UpdateCodeBlockBuilder(context, queryMethod);
    }

    static UpdateExecutionCodeBlockBuilder updateExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new UpdateExecutionCodeBlockBuilder(context, queryMethod);
    }

    static AggregationCodeBlockBuilder aggregationBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new AggregationCodeBlockBuilder(context, queryMethod);
    }

    static AggregationExecutionCodeBlockBuilder aggregationExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new AggregationExecutionCodeBlockBuilder(context, queryMethod);
    }

    private static CodeBlock renderExpressionToDocument(@Nullable String source, String variableName, List<String> arguments) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (!StringUtils.hasText((String)source)) {
            builder.addStatement("$T $L = new $T()", new Object[]{Document.class, variableName, Document.class});
        } else if (!MongoCodeBlocks.containsPlaceholder(source)) {
            String tmpVarName = "%sString".formatted(variableName);
            builder.addStatement("String $L = $S", new Object[]{tmpVarName, source});
            builder.addStatement("$T $L = $T.parse($L)", new Object[]{Document.class, variableName, Document.class, tmpVarName});
        } else {
            String tmpVarName = "%sString".formatted(variableName);
            builder.addStatement("String $L = $S", new Object[]{tmpVarName, source});
            builder.addStatement("$T $L = bindParameters($L, new $T[]{ $L })", new Object[]{Document.class, variableName, tmpVarName, Object.class, StringUtils.collectionToDelimitedString(arguments, (String)", ")});
        }
        return builder.build();
    }

    private static boolean containsPlaceholder(String source) {
        return PARAMETER_BINDING_PATTERN.matcher(source).find();
    }

    @NullUnmarked
    static class QueryCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private QueryInteraction source;
        private List<String> arguments;
        private String queryVariableName;

        QueryCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.arguments = context.getBindableParameterNames();
            this.queryMethod = queryMethod;
        }

        QueryCodeBlockBuilder filter(QueryInteraction query) {
            this.source = query;
            return this;
        }

        QueryCodeBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            MergedAnnotation readPreferenceAnnotation;
            String readPreference;
            MergedAnnotation hintAnnotation;
            String hint;
            String sortParameter;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            builder.add(this.renderExpressionToQuery(this.source.getQuery().getQueryString(), this.queryVariableName));
            if (StringUtils.hasText((String)this.source.getQuery().getFieldsString())) {
                builder.add(MongoCodeBlocks.renderExpressionToDocument(this.source.getQuery().getFieldsString(), "fields", this.arguments));
                builder.addStatement("$L.setFieldsObject(fields)", new Object[]{this.queryVariableName});
            }
            if (StringUtils.hasText((String)(sortParameter = this.context.getSortParameterName()))) {
                builder.addStatement("$L.with($L)", new Object[]{this.queryVariableName, sortParameter});
            } else if (StringUtils.hasText((String)this.source.getQuery().getSortString())) {
                builder.add(MongoCodeBlocks.renderExpressionToDocument(this.source.getQuery().getSortString(), "sort", this.arguments));
                builder.addStatement("$L.setSortObject(sort)", new Object[]{this.queryVariableName});
            }
            String limitParameter = this.context.getLimitParameterName();
            if (StringUtils.hasText((String)limitParameter)) {
                builder.addStatement("$L.limit($L)", new Object[]{this.queryVariableName, limitParameter});
            } else if (this.context.getPageableParameterName() == null && this.source.getQuery().isLimited()) {
                builder.addStatement("$L.limit($L)", new Object[]{this.queryVariableName, this.source.getQuery().getLimit()});
            }
            String pageableParameter = this.context.getPageableParameterName();
            if (StringUtils.hasText((String)pageableParameter) && !this.queryMethod.isPageQuery() && !this.queryMethod.isSliceQuery()) {
                builder.addStatement("$L.with($L)", new Object[]{this.queryVariableName, pageableParameter});
            }
            String string = hint = (hintAnnotation = this.context.getAnnotation(Hint.class)).isPresent() ? hintAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)hint)) {
                builder.addStatement("$L.withHint($S)", new Object[]{this.queryVariableName, hint});
            }
            String string2 = readPreference = (readPreferenceAnnotation = this.context.getAnnotation(ReadPreference.class)).isPresent() ? readPreferenceAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)readPreference)) {
                builder.addStatement("$L.withReadPreference($T.valueOf($S))", new Object[]{this.queryVariableName, com.mongodb.ReadPreference.class, readPreference});
            }
            return builder.build();
        }

        private CodeBlock renderExpressionToQuery(@Nullable String source, String variableName) {
            CodeBlock.Builder builder = CodeBlock.builder();
            if (!StringUtils.hasText((String)source)) {
                builder.addStatement("$T $L = new $T(new $T())", new Object[]{BasicQuery.class, variableName, BasicQuery.class, Document.class});
            } else if (!MongoCodeBlocks.containsPlaceholder(source)) {
                String tmpVarName = "%sString".formatted(variableName);
                builder.addStatement("String $L = $S", new Object[]{tmpVarName, source});
                builder.addStatement("$T $L = new $T($T.parse($L))", new Object[]{BasicQuery.class, variableName, BasicQuery.class, Document.class, tmpVarName});
            } else {
                String tmpVarName = "%sString".formatted(variableName);
                builder.addStatement("String $L = $S", new Object[]{tmpVarName, source});
                builder.addStatement("$T $L = createQuery($L, new $T[]{ $L })", new Object[]{BasicQuery.class, variableName, tmpVarName, Object.class, StringUtils.collectionToDelimitedString(this.arguments, (String)", ")});
            }
            return builder.build();
        }
    }

    @NullUnmarked
    static class QueryExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private QueryInteraction query;

        QueryExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        QueryExecutionCodeBlockBuilder forQuery(QueryInteraction query) {
            this.query = query;
            return this;
        }

        CodeBlock build() {
            String terminatingMethod;
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean isProjecting = this.context.getReturnedType().isProjecting();
            Type actualReturnType = isProjecting ? this.context.getActualReturnType().getType() : this.context.getRepositoryInformation().getDomainType();
            builder.add("\n", new Object[0]);
            if (isProjecting) {
                builder.addStatement("$T<$T> finder = $L.query($T.class).as($T.class)", new Object[]{ExecutableFindOperation.FindWithQuery.class, actualReturnType, mongoOpsRef, this.context.getRepositoryInformation().getDomainType(), actualReturnType});
            } else {
                builder.addStatement("$T<$T> finder = $L.query($T.class)", new Object[]{ExecutableFindOperation.FindWithQuery.class, actualReturnType, mongoOpsRef, this.context.getRepositoryInformation().getDomainType()});
            }
            if (this.queryMethod.isCollectionQuery() || this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
                terminatingMethod = "all()";
            } else if (this.query.isCount()) {
                terminatingMethod = "count()";
            } else if (this.query.isExists()) {
                terminatingMethod = "exists()";
            } else {
                String string = terminatingMethod = Optional.class.isAssignableFrom(this.context.getReturnType().toClass()) ? "one()" : "oneValue()";
            }
            if (this.queryMethod.isPageQuery()) {
                builder.addStatement("return new $T(finder, $L).execute($L)", new Object[]{MongoQueryExecution.PagedExecution.class, this.context.getPageableParameterName(), this.query.name()});
            } else if (this.queryMethod.isSliceQuery()) {
                builder.addStatement("return new $T(finder, $L).execute($L)", new Object[]{MongoQueryExecution.SlicedExecution.class, this.context.getPageableParameterName(), this.query.name()});
            } else {
                builder.addStatement("return finder.matching($L).$L", new Object[]{this.query.name(), terminatingMethod});
            }
            return builder.build();
        }
    }

    @NullUnmarked
    static class DeleteExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String queryVariableName;

        DeleteExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        DeleteExecutionCodeBlockBuilder referencing(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean isProjecting = this.context.getActualReturnType() != null && !ObjectUtils.nullSafeEquals((Object)TypeName.get((Type)this.context.getRepositoryInformation().getDomainType()), (Object)this.context.getActualReturnType());
            Type actualReturnType = isProjecting ? this.context.getActualReturnType().getType() : this.context.getRepositoryInformation().getDomainType();
            builder.add("\n", new Object[0]);
            builder.addStatement("$T<$T> remover = $L.remove($T.class)", new Object[]{ExecutableRemoveOperation.ExecutableRemove.class, this.context.getRepositoryInformation().getDomainType(), mongoOpsRef, this.context.getRepositoryInformation().getDomainType()});
            MongoQueryExecution.DeleteExecution.Type type = MongoQueryExecution.DeleteExecution.Type.FIND_AND_REMOVE_ALL;
            if (!this.queryMethod.isCollectionQuery()) {
                type = !ClassUtils.isPrimitiveOrWrapper(this.context.getMethod().getReturnType()) ? MongoQueryExecution.DeleteExecution.Type.FIND_AND_REMOVE_ONE : MongoQueryExecution.DeleteExecution.Type.ALL;
            }
            actualReturnType = ClassUtils.isPrimitiveOrWrapper(this.context.getMethod().getReturnType()) ? ClassName.get(this.context.getMethod().getReturnType()) : (this.queryMethod.isCollectionQuery() ? this.context.getReturnTypeName() : actualReturnType);
            builder.addStatement("return ($T) new $T(remover, $T.$L).execute($L)", new Object[]{actualReturnType, MongoQueryExecution.DeleteExecution.class, MongoQueryExecution.DeleteExecution.Type.class, type.name(), this.queryVariableName});
            return builder.build();
        }
    }

    @NullUnmarked
    static class UpdateCodeBlockBuilder {
        private UpdateInteraction source;
        private List<String> arguments;
        private String updateVariableName;

        public UpdateCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.arguments = context.getBindableParameterNames();
        }

        public UpdateCodeBlockBuilder update(UpdateInteraction update) {
            this.source = update;
            return this;
        }

        public UpdateCodeBlockBuilder usingUpdateVariableName(String updateVariableName) {
            this.updateVariableName = updateVariableName;
            return this;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String tmpVariableName = this.updateVariableName + "Document";
            builder.add(MongoCodeBlocks.renderExpressionToDocument(this.source.getUpdate().getUpdateString(), tmpVariableName, this.arguments));
            builder.addStatement("$T $L = new $T($L)", new Object[]{BasicUpdate.class, this.updateVariableName, BasicUpdate.class, tmpVariableName});
            return builder.build();
        }
    }

    @NullUnmarked
    static class UpdateExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String queryVariableName;
        private String updateVariableName;

        UpdateExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        UpdateExecutionCodeBlockBuilder withFilter(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        UpdateExecutionCodeBlockBuilder referencingUpdate(String updateVariableName) {
            this.updateVariableName = updateVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String updateReference = this.updateVariableName;
            builder.addStatement("$T<$T> updater = $L.update($T.class)", new Object[]{ExecutableUpdateOperation.ExecutableUpdate.class, this.context.getRepositoryInformation().getDomainType(), mongoOpsRef, this.context.getRepositoryInformation().getDomainType()});
            Class returnType = ClassUtils.resolvePrimitiveIfNecessary((Class)this.queryMethod.getReturnedObjectType());
            if (ReflectionUtils.isVoid((Class)returnType)) {
                builder.addStatement("updater.matching($L).apply($L).all()", new Object[]{this.queryVariableName, updateReference});
            } else if (ClassUtils.isAssignable(Long.class, (Class)returnType)) {
                builder.addStatement("return updater.matching($L).apply($L).all().getModifiedCount()", new Object[]{this.queryVariableName, updateReference});
            } else {
                builder.addStatement("$T modifiedCount = updater.matching($L).apply($L).all().getModifiedCount()", new Object[]{Long.class, this.queryVariableName, updateReference});
                builder.addStatement("return $T.convertNumberToTargetClass(modifiedCount, $T.class)", new Object[]{NumberUtils.class, returnType});
            }
            return builder.build();
        }
    }

    @NullUnmarked
    static class AggregationCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private AggregationInteraction source;
        private List<String> arguments;
        private String aggregationVariableName;
        private boolean pipelineOnly;

        AggregationCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.arguments = context.getBindableParameterNames();
            this.queryMethod = queryMethod;
        }

        AggregationCodeBlockBuilder stages(AggregationInteraction aggregation) {
            this.source = aggregation;
            return this;
        }

        AggregationCodeBlockBuilder usingAggregationVariableName(String aggregationVariableName) {
            this.aggregationVariableName = aggregationVariableName;
            return this;
        }

        AggregationCodeBlockBuilder pipelineOnly(boolean pipelineOnly) {
            this.pipelineOnly = pipelineOnly;
            return this;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String pipelineName = this.aggregationVariableName + (this.pipelineOnly ? "" : "Pipeline");
            builder.add(this.pipeline(pipelineName));
            if (!this.pipelineOnly) {
                builder.addStatement("$T<$T> $L = $T.newAggregation($T.class, $L.getOperations())", new Object[]{TypedAggregation.class, this.context.getRepositoryInformation().getDomainType(), this.aggregationVariableName, Aggregation.class, this.context.getRepositoryInformation().getDomainType(), pipelineName});
                builder.add(this.aggregationOptions(this.aggregationVariableName));
            }
            return builder.build();
        }

        private CodeBlock pipeline(String pipelineVariableName) {
            String sortParameter = this.context.getSortParameterName();
            String limitParameter = this.context.getLimitParameterName();
            String pageableParameter = this.context.getPageableParameterName();
            boolean mightBeSorted = StringUtils.hasText((String)sortParameter);
            boolean mightBeLimited = StringUtils.hasText((String)limitParameter);
            boolean mightBePaged = StringUtils.hasText((String)pageableParameter);
            int stageCount = this.source.stages().size();
            if (mightBeSorted) {
                ++stageCount;
            }
            if (mightBeLimited) {
                ++stageCount;
            }
            if (mightBePaged) {
                stageCount += 3;
            }
            CodeBlock.Builder builder = CodeBlock.builder();
            String stagesVariableName = "stages";
            builder.add(AggregationCodeBlockBuilder.aggregationStages(stagesVariableName, this.source.stages(), stageCount, this.arguments));
            if (mightBeSorted) {
                builder.add(AggregationCodeBlockBuilder.sortingStage(sortParameter));
            }
            if (mightBeLimited) {
                builder.add(AggregationCodeBlockBuilder.limitingStage(limitParameter));
            }
            if (mightBePaged) {
                builder.add(AggregationCodeBlockBuilder.pagingStage(pageableParameter, this.queryMethod.isSliceQuery()));
            }
            builder.addStatement("$T $L = createPipeline($L)", new Object[]{AggregationPipeline.class, pipelineVariableName, stagesVariableName});
            return builder.build();
        }

        private CodeBlock aggregationOptions(String aggregationVariableName) {
            MergedAnnotation readPreferenceAnnotation;
            String readPreference;
            MergedAnnotation hintAnnotation;
            String hint;
            CodeBlock.Builder builder = CodeBlock.builder();
            ArrayList<CodeBlock> options = new ArrayList<CodeBlock>(5);
            if (ReflectionUtils.isVoid((Class)this.queryMethod.getReturnedObjectType())) {
                options.add(CodeBlock.of((String)".skipOutput()", (Object[])new Object[0]));
            }
            String string = hint = (hintAnnotation = this.context.getAnnotation(Hint.class)).isPresent() ? hintAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)hint)) {
                options.add(CodeBlock.of((String)".hint($S)", (Object[])new Object[]{hint}));
            }
            String string2 = readPreference = (readPreferenceAnnotation = this.context.getAnnotation(ReadPreference.class)).isPresent() ? readPreferenceAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)readPreference)) {
                options.add(CodeBlock.of((String)".readPreference($T.valueOf($S))", (Object[])new Object[]{com.mongodb.ReadPreference.class, readPreference}));
            }
            if (this.queryMethod.hasAnnotatedCollation()) {
                options.add(CodeBlock.of((String)".collation($T.parse($S))", (Object[])new Object[]{Collation.class, this.queryMethod.getAnnotatedCollation()}));
            }
            if (!options.isEmpty()) {
                CodeBlock.Builder optionsBuilder = CodeBlock.builder();
                optionsBuilder.add("$T aggregationOptions = $T.builder()\n", new Object[]{AggregationOptions.class, AggregationOptions.class});
                optionsBuilder.indent();
                for (CodeBlock optionBlock : options) {
                    optionsBuilder.add(optionBlock);
                    optionsBuilder.add("\n", new Object[0]);
                }
                optionsBuilder.add(".build();\n", new Object[0]);
                optionsBuilder.unindent();
                builder.add(optionsBuilder.build());
                builder.addStatement("$L = $L.withOptions(aggregationOptions)", new Object[]{aggregationVariableName, aggregationVariableName});
            }
            return builder.build();
        }

        private static CodeBlock aggregationStages(String stageListVariableName, Iterable<String> stages, int stageCount, List<String> arguments) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$T<$T> $L = new $T($L)", new Object[]{List.class, Object.class, stageListVariableName, ArrayList.class, stageCount});
            int stageCounter = 0;
            for (String stage : stages) {
                String stageName = "stage_%s".formatted(stageCounter++);
                builder.add(MongoCodeBlocks.renderExpressionToDocument(stage, stageName, arguments));
                builder.addStatement("stages.add($L)", new Object[]{stageName});
            }
            return builder.build();
        }

        private static CodeBlock sortingStage(String sortProvider) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.beginControlFlow("if($L.isSorted())", new Object[]{sortProvider});
            builder.addStatement("$T sortDocument = new $T()", new Object[]{Document.class, Document.class});
            builder.beginControlFlow("for ($T order : $L)", new Object[]{Sort.Order.class, sortProvider});
            builder.addStatement("sortDocument.append(order.getProperty(), order.isAscending() ? 1 : -1);", new Object[0]);
            builder.endControlFlow();
            builder.addStatement("stages.add(new $T($S, sortDocument))", new Object[]{Document.class, "$sort"});
            builder.endControlFlow();
            return builder.build();
        }

        private static CodeBlock pagingStage(String pageableProvider, boolean slice) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(AggregationCodeBlockBuilder.sortingStage(pageableProvider + ".getSort()"));
            builder.beginControlFlow("if($L.isPaged())", new Object[]{pageableProvider});
            builder.beginControlFlow("if($L.getOffset() > 0)", new Object[]{pageableProvider});
            builder.addStatement("stages.add($T.skip($L.getOffset()))", new Object[]{Aggregation.class, pageableProvider});
            builder.endControlFlow();
            if (slice) {
                builder.addStatement("stages.add($T.limit($L.getPageSize() + 1))", new Object[]{Aggregation.class, pageableProvider});
            } else {
                builder.addStatement("stages.add($T.limit($L.getPageSize()))", new Object[]{Aggregation.class, pageableProvider});
            }
            builder.endControlFlow();
            return builder.build();
        }

        private static CodeBlock limitingStage(String limitProvider) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.beginControlFlow("if($L.isLimited())", new Object[]{limitProvider});
            builder.addStatement("stages.add($T.limit($L.max()))", new Object[]{Aggregation.class, limitProvider});
            builder.endControlFlow();
            return builder.build();
        }
    }

    @NullUnmarked
    static class AggregationExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final MongoQueryMethod queryMethod;
        private String aggregationVariableName;

        AggregationExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        AggregationExecutionCodeBlockBuilder referencing(String aggregationVariableName) {
            this.aggregationVariableName = aggregationVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            Class outputType = this.queryMethod.getReturnedObjectType();
            if (MongoSimpleTypes.HOLDER.isSimpleType(outputType)) {
                outputType = Document.class;
            } else if (ClassUtils.isAssignable(AggregationResults.class, outputType)) {
                outputType = this.queryMethod.getReturnType().getComponentType().getType();
            }
            if (ReflectionUtils.isVoid((Class)this.queryMethod.getReturnedObjectType())) {
                builder.addStatement("$L.aggregate($L, $T.class)", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
                return builder.build();
            }
            if (ClassUtils.isAssignable(AggregationResults.class, this.context.getMethod().getReturnType())) {
                builder.addStatement("return $L.aggregate($L, $T.class)", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
                return builder.build();
            }
            if (outputType == Document.class) {
                Class returnType = ClassUtils.resolvePrimitiveIfNecessary((Class)this.queryMethod.getReturnedObjectType());
                builder.addStatement("$T results = $L.aggregate($L, $T.class)", new Object[]{AggregationResults.class, mongoOpsRef, this.aggregationVariableName, outputType});
                if (!this.queryMethod.isCollectionQuery()) {
                    builder.addStatement("return $T.<$T>firstElement(convertSimpleRawResults($T.class, results.getMappedResults()))", new Object[]{CollectionUtils.class, returnType, returnType});
                } else {
                    builder.addStatement("return convertSimpleRawResults($T.class, results.getMappedResults())", new Object[]{returnType});
                }
            } else if (this.queryMethod.isSliceQuery()) {
                builder.addStatement("$T results = $L.aggregate($L, $T.class)", new Object[]{AggregationResults.class, mongoOpsRef, this.aggregationVariableName, outputType});
                builder.addStatement("boolean hasNext = results.getMappedResults().size() > $L.getPageSize()", new Object[]{this.context.getPageableParameterName()});
                builder.addStatement("return new $T<>(hasNext ? results.getMappedResults().subList(0, $L.getPageSize()) : results.getMappedResults(), $L, hasNext)", new Object[]{SliceImpl.class, this.context.getPageableParameterName(), this.context.getPageableParameterName()});
            } else {
                builder.addStatement("return $L.aggregate($L, $T.class).getMappedResults()", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
            }
            return builder.build();
        }
    }
}

