/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.time.Duration;
import org.bson.Document;
import org.jspecify.annotations.Nullable;

public class IndexOptions {
    private @Nullable Duration expire;
    private @Nullable Boolean hidden;
    private @Nullable Unique unique;

    public static IndexOptions none() {
        return new IndexOptions();
    }

    public static IndexOptions unique() {
        IndexOptions options = new IndexOptions();
        options.unique = Unique.YES;
        return options;
    }

    public static IndexOptions hidden() {
        IndexOptions options = new IndexOptions();
        options.hidden = true;
        return options;
    }

    public static IndexOptions expireAfter(Duration duration) {
        IndexOptions options = new IndexOptions();
        options.expire = duration;
        return options;
    }

    public @Nullable Duration getExpire() {
        return this.expire;
    }

    public void setExpire(Duration expire) {
        this.expire = expire;
    }

    public @Nullable Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public @Nullable Unique getUnique() {
        return this.unique;
    }

    public void setUnique(Unique unique) {
        this.unique = unique;
    }

    public Document toDocument() {
        Document document = new Document();
        if (this.unique != null) {
            switch (this.unique) {
                case NO: {
                    document.put("unique", (Object)false);
                    break;
                }
                case YES: {
                    document.put("unique", (Object)true);
                    break;
                }
                case PREPARE: {
                    document.put("prepareUnique", (Object)true);
                }
            }
        }
        if (this.hidden != null) {
            document.put("hidden", (Object)this.hidden);
        }
        if (this.expire != null && !this.expire.isNegative()) {
            document.put("expireAfterSeconds", (Object)this.expire.getSeconds());
        }
        return document;
    }

    public static enum Unique {
        NO,
        YES,
        PREPARE;

    }
}

