/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.Function;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonGeometryCollection;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

abstract class GeoConverters {
    private static final Map<String, Function<Document, GeoJson<?>>> converters;

    private GeoConverters() {
    }

    public static Collection<? extends Object> getConvertersToRegister() {
        return Arrays.asList(new Enum[]{BoxToDocumentConverter.INSTANCE, PolygonToDocumentConverter.INSTANCE, CircleToDocumentConverter.INSTANCE, SphereToDocumentConverter.INSTANCE, DocumentToBoxConverter.INSTANCE, DocumentToPolygonConverter.INSTANCE, DocumentToCircleConverter.INSTANCE, DocumentToSphereConverter.INSTANCE, DocumentToPointConverter.INSTANCE, PointToDocumentConverter.INSTANCE, GeoCommandToDocumentConverter.INSTANCE, GeoJsonToDocumentConverter.INSTANCE, GeoJsonPointToDocumentConverter.INSTANCE, GeoJsonPolygonToDocumentConverter.INSTANCE, DocumentToGeoJsonPointConverter.INSTANCE, DocumentToGeoJsonPolygonConverter.INSTANCE, DocumentToGeoJsonLineStringConverter.INSTANCE, DocumentToGeoJsonMultiLineStringConverter.INSTANCE, DocumentToGeoJsonMultiPointConverter.INSTANCE, DocumentToGeoJsonMultiPolygonConverter.INSTANCE, DocumentToGeoJsonGeometryCollectionConverter.INSTANCE, DocumentToGeoJsonConverter.INSTANCE});
    }

    static List<Double> toList(Point point) {
        return Arrays.asList(point.getX(), point.getY());
    }

    @Contract(value="null -> fail")
    static List<Point> toListOfPoint(@Nullable List<?> listOfCoordinatePairs) {
        Assert.notNull(listOfCoordinatePairs, (String)"ListOfCoordinatePairs must not be null");
        ArrayList<Point> points = new ArrayList<Point>(listOfCoordinatePairs.size());
        for (Object point : listOfCoordinatePairs) {
            Assert.isInstanceOf(List.class, point);
            List coordinatesList = (List)point;
            points.add(new GeoJsonPoint(GeoConverters.toPrimitiveDoubleValue(coordinatesList.get(0)), GeoConverters.toPrimitiveDoubleValue(coordinatesList.get(1))));
        }
        return points;
    }

    @Contract(value="null -> fail")
    static GeoJsonPolygon toGeoJsonPolygon(@Nullable List<?> dbList) {
        Assert.notNull(dbList, (String)"DbList must not be null");
        GeoJsonPolygon polygon = new GeoJsonPolygon(GeoConverters.toListOfPoint((List)dbList.get(0)));
        return dbList.size() > 1 ? polygon.withInnerRing(GeoConverters.toListOfPoint((List)dbList.get(1))) : polygon;
    }

    private static GeoJson<?> toGenericGeoJson(Document source) {
        Function<Document, GeoJson<?>> converter;
        String type = (String)source.get((Object)"type", String.class);
        if (type != null && (converter = converters.get(type)) != null) {
            return (GeoJson)converter.apply((Object)source);
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting GeoJson type %s", type));
    }

    @Contract(value="null -> fail")
    private static double toPrimitiveDoubleValue(@Nullable Object value) {
        Assert.isInstanceOf(Number.class, (Object)value, (String)"Argument must be a Number");
        return (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)value), Double.class);
    }

    static {
        Collator caseInsensitive = Collator.getInstance();
        caseInsensitive.setStrength(0);
        TreeMap geoConverters = new TreeMap(caseInsensitive);
        geoConverters.put("point", DocumentToGeoJsonPointConverter.INSTANCE::convert);
        geoConverters.put("multipoint", DocumentToGeoJsonMultiPointConverter.INSTANCE::convert);
        geoConverters.put("linestring", DocumentToGeoJsonLineStringConverter.INSTANCE::convert);
        geoConverters.put("multilinestring", DocumentToGeoJsonMultiLineStringConverter.INSTANCE::convert);
        geoConverters.put("polygon", DocumentToGeoJsonPolygonConverter.INSTANCE::convert);
        geoConverters.put("multipolygon", DocumentToGeoJsonMultiPolygonConverter.INSTANCE::convert);
        geoConverters.put("geometrycollection", DocumentToGeoJsonGeometryCollectionConverter.INSTANCE::convert);
        converters = geoConverters;
    }

    @WritingConverter
    static enum BoxToDocumentConverter implements Converter<Box, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable Box source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("first", (Object)PointToDocumentConverter.INSTANCE.convert(source.getFirst()));
            result.put("second", (Object)PointToDocumentConverter.INSTANCE.convert(source.getSecond()));
            return result;
        }
    }

    static enum PolygonToDocumentConverter implements Converter<Polygon, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable Polygon source) {
            if (source == null) {
                return null;
            }
            List points = source.getPoints();
            ArrayList<Document> pointTuples = new ArrayList<Document>(points.size());
            for (Point point : points) {
                pointTuples.add(PointToDocumentConverter.INSTANCE.convert(point));
            }
            Document result = new Document();
            result.put("points", pointTuples);
            return result;
        }
    }

    static enum CircleToDocumentConverter implements Converter<Circle, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable Circle source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("center", (Object)PointToDocumentConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    static enum SphereToDocumentConverter implements Converter<Sphere, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable Sphere source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("center", (Object)PointToDocumentConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    static enum DocumentToBoxConverter implements Converter<Document, Box>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Box convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Point first = DocumentToPointConverter.INSTANCE.convert((Document)source.get((Object)"first"));
            Point second = DocumentToPointConverter.INSTANCE.convert((Document)source.get((Object)"second"));
            return new Box(first, second);
        }
    }

    @ReadingConverter
    static enum DocumentToPolygonConverter implements Converter<Document, Polygon>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Polygon convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            List points = (List)source.get((Object)"points");
            Assert.notNull((Object)points, (String)"Points elements of polygon must not be null");
            ArrayList<Point> newPoints = new ArrayList<Point>(points.size());
            for (Document element : points) {
                Assert.notNull((Object)element, (String)"Point elements of polygon must not contain null");
                newPoints.add(DocumentToPointConverter.INSTANCE.convert(element));
            }
            return new Polygon(newPoints);
        }
    }

    @ReadingConverter
    static enum DocumentToCircleConverter implements Converter<Document, Circle>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Circle convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Document center = (Document)source.get((Object)"center");
            Number radius = (Number)source.get((Object)"radius");
            Assert.notNull((Object)center, (String)"Center must not be null");
            Assert.notNull((Object)radius, (String)"Radius must not be null");
            Distance distance = new Distance(GeoConverters.toPrimitiveDoubleValue(radius));
            if (source.containsKey((Object)"metric")) {
                String metricString = (String)source.get((Object)"metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            return new Circle(DocumentToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    @ReadingConverter
    static enum DocumentToSphereConverter implements Converter<Document, Sphere>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Sphere convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Document center = (Document)source.get((Object)"center");
            Number radius = (Number)source.get((Object)"radius");
            Assert.notNull((Object)center, (String)"Center must not be null");
            Assert.notNull((Object)radius, (String)"Radius must not be null");
            Distance distance = new Distance(GeoConverters.toPrimitiveDoubleValue(radius));
            if (source.containsKey((Object)"metric")) {
                String metricString = (String)source.get((Object)"metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            return new Sphere(DocumentToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    @ReadingConverter
    static enum DocumentToPointConverter implements Converter<Document, Point>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Point convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((source.keySet().size() == 2 ? 1 : 0) != 0, (String)"Source must contain 2 elements");
            if (source.containsKey((Object)"type")) {
                return DocumentToGeoJsonPointConverter.INSTANCE.convert(source);
            }
            return new Point(GeoConverters.toPrimitiveDoubleValue(source.get((Object)"x")), GeoConverters.toPrimitiveDoubleValue(source.get((Object)"y")));
        }
    }

    static enum PointToDocumentConverter implements Converter<Point, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable Point source) {
            return source == null ? null : new Document("x", (Object)source.getX()).append("y", (Object)source.getY());
        }
    }

    static enum GeoCommandToDocumentConverter implements Converter<GeoCommand, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable GeoCommand source) {
            if (source == null) {
                return null;
            }
            ArrayList<Object> argument = new ArrayList<Object>(2);
            Shape shape = source.getShape();
            if (shape instanceof GeoJson) {
                GeoJson geoJson = (GeoJson)shape;
                return GeoJsonToDocumentConverter.INSTANCE.convert(geoJson);
            }
            if (shape instanceof Box) {
                Box box = (Box)shape;
                argument.add(GeoConverters.toList(box.getFirst()));
                argument.add(GeoConverters.toList(box.getSecond()));
            } else if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                argument.add(GeoConverters.toList(circle.getCenter()));
                argument.add(circle.getRadius().getNormalizedValue());
            } else if (shape instanceof Polygon) {
                Polygon polygon = (Polygon)shape;
                List points = polygon.getPoints();
                argument = new ArrayList(points.size());
                for (Point point : points) {
                    argument.add(GeoConverters.toList(point));
                }
            } else if (shape instanceof Sphere) {
                Sphere sphere = (Sphere)shape;
                argument.add(GeoConverters.toList(sphere.getCenter()));
                argument.add(sphere.getRadius().getNormalizedValue());
            }
            return new Document(source.getCommand(), argument);
        }
    }

    static enum GeoJsonToDocumentConverter implements Converter<GeoJson<?>, Document>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable Document convert(@Nullable GeoJson<?> source) {
            if (source == null) {
                return null;
            }
            Document dbo = new Document("type", (Object)source.getType());
            if (source instanceof GeoJsonGeometryCollection) {
                GeoJsonGeometryCollection collection = (GeoJsonGeometryCollection)source;
                ArrayList<Document> dbl = new ArrayList<Document>();
                for (GeoJson<?> geometry : collection.getCoordinates()) {
                    dbl.add(this.convert(geometry));
                }
                dbo.put("geometries", dbl);
            } else {
                dbo.put("coordinates", this.convertIfNecessary(source.getCoordinates()));
            }
            return dbo;
        }

        private Object convertIfNecessary(Object candidate) {
            if (candidate instanceof GeoJson) {
                GeoJson geoJson = (GeoJson)candidate;
                return this.convertIfNecessary(geoJson.getCoordinates());
            }
            if (candidate instanceof Iterable) {
                Iterable iterable = (Iterable)candidate;
                ArrayList<Object> dbl = new ArrayList<Object>();
                for (Object element : iterable) {
                    dbl.add(this.convertIfNecessary(element));
                }
                return dbl;
            }
            if (candidate instanceof Point) {
                Point point = (Point)candidate;
                return GeoConverters.toList(point);
            }
            return candidate;
        }
    }

    static enum GeoJsonPointToDocumentConverter implements Converter<GeoJsonPoint, Document>
    {
        INSTANCE;


        public Document convert(GeoJsonPoint source) {
            return GeoJsonToDocumentConverter.INSTANCE.convert(source);
        }
    }

    static enum GeoJsonPolygonToDocumentConverter implements Converter<GeoJsonPolygon, Document>
    {
        INSTANCE;


        public Document convert(GeoJsonPolygon source) {
            return GeoJsonToDocumentConverter.INSTANCE.convert(source);
        }
    }

    static enum DocumentToGeoJsonPointConverter implements Converter<Document, GeoJsonPoint>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonPoint convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"Point"), (String)String.format("Cannot convert type '%s' to Point", source.get((Object)"type")));
            Object object = source.get((Object)"coordinates");
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("Coordinates need to be present");
            }
            List sourceCoordinates = (List)object;
            List dbl = sourceCoordinates;
            return new GeoJsonPoint(GeoConverters.toPrimitiveDoubleValue(dbl.get(0)), GeoConverters.toPrimitiveDoubleValue(dbl.get(1)));
        }
    }

    static enum DocumentToGeoJsonPolygonConverter implements Converter<Document, GeoJsonPolygon>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonPolygon convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"Polygon"), (String)String.format("Cannot convert type '%s' to Polygon", source.get((Object)"type")));
            return GeoConverters.toGeoJsonPolygon((List)source.get((Object)"coordinates"));
        }
    }

    static enum DocumentToGeoJsonLineStringConverter implements Converter<Document, GeoJsonLineString>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonLineString convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"LineString"), (String)String.format("Cannot convert type '%s' to LineString", source.get((Object)"type")));
            List cords = (List)source.get((Object)"coordinates");
            return new GeoJsonLineString(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DocumentToGeoJsonMultiLineStringConverter implements Converter<Document, GeoJsonMultiLineString>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonMultiLineString convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"MultiLineString"), (String)String.format("Cannot convert type '%s' to MultiLineString", source.get((Object)"type")));
            Object object = source.get((Object)"coordinates");
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("coordinates need to be present");
            }
            List coordinates = (List)object;
            ArrayList<GeoJsonLineString> lines = new ArrayList<GeoJsonLineString>(coordinates.size());
            for (Object line : coordinates) {
                lines.add(new GeoJsonLineString(GeoConverters.toListOfPoint((List)line)));
            }
            return new GeoJsonMultiLineString((List<GeoJsonLineString>)lines);
        }
    }

    static enum DocumentToGeoJsonMultiPointConverter implements Converter<Document, GeoJsonMultiPoint>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonMultiPoint convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"MultiPoint"), (String)String.format("Cannot convert type '%s' to MultiPoint", source.get((Object)"type")));
            List cords = (List)source.get((Object)"coordinates");
            return new GeoJsonMultiPoint(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DocumentToGeoJsonMultiPolygonConverter implements Converter<Document, GeoJsonMultiPolygon>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonMultiPolygon convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"MultiPolygon"), (String)String.format("Cannot convert type '%s' to MultiPolygon", source.get((Object)"type")));
            List dbl = (List)source.get((Object)"coordinates");
            Assert.notNull((Object)dbl, (String)"Source needs to contain coordinates");
            ArrayList<GeoJsonPolygon> polygones = new ArrayList<GeoJsonPolygon>(dbl.size());
            for (Object polygon : dbl) {
                polygones.add(GeoConverters.toGeoJsonPolygon((List)polygon));
            }
            return new GeoJsonMultiPolygon(polygones);
        }
    }

    static enum DocumentToGeoJsonGeometryCollectionConverter implements Converter<Document, GeoJsonGeometryCollection>
    {
        INSTANCE;


        @Contract(value="null -> null; !null -> !null")
        public @Nullable GeoJsonGeometryCollection convert(@Nullable Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get((Object)"type"), (Object)"GeometryCollection"), (String)String.format("Cannot convert type '%s' to GeometryCollection", source.get((Object)"type")));
            Object object = source.get((Object)"geometries");
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("Geometries need to be present");
            }
            List sourceGeometries = (List)object;
            ArrayList geometries = new ArrayList(sourceGeometries.size());
            for (Object o : sourceGeometries) {
                geometries.add(GeoConverters.toGenericGeoJson((Document)o));
            }
            return new GeoJsonGeometryCollection(geometries);
        }
    }

    @ReadingConverter
    static enum DocumentToGeoJsonConverter implements Converter<Document, GeoJson<?>>
    {
        INSTANCE;


        public GeoJson<?> convert(Document source) {
            return GeoConverters.toGenericGeoJson(source);
        }
    }
}

