/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class EvaluationOperators {
    public static EvaluationOperatorFactory valueOf(String fieldReference) {
        return new EvaluationOperatorFactory(fieldReference);
    }

    public static EvaluationOperatorFactory valueOf(AggregationExpression expression) {
        return new EvaluationOperatorFactory(expression);
    }

    public static class EvaluationOperatorFactory {
        private final @Nullable String fieldReference;
        private final @Nullable AggregationExpression expression;

        public EvaluationOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public EvaluationOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Expr expr() {
            return this.usesFieldRef() ? Expr.valueOf(this.fieldReference) : Expr.valueOf(this.expression);
        }

        public LastObservationCarriedForward locf() {
            return this.usesFieldRef() ? LastObservationCarriedForward.locfValueOf(this.fieldReference) : LastObservationCarriedForward.locfValueOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class LastObservationCarriedForward
    extends AbstractAggregationExpression {
        private LastObservationCarriedForward(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$locf";
        }

        public static LastObservationCarriedForward locfValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new LastObservationCarriedForward(Fields.field(fieldReference));
        }

        public static LastObservationCarriedForward locfValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new LastObservationCarriedForward(expression);
        }
    }

    public static class Expr
    extends AbstractAggregationExpression {
        private Expr(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$expr";
        }

        public static Expr valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Expr(Fields.field(fieldReference));
        }

        public static Expr valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Expr(expression);
        }

        public CriteriaDefinition toCriteriaDefinition(AggregationOperationContext context) {
            final Document criteriaObject = this.toDocument(context);
            return new CriteriaDefinition(){

                @Override
                public Document getCriteriaObject() {
                    return criteriaObject;
                }

                @Override
                public String getKey() {
                    return this.getMongoMethod();
                }
            };
        }
    }
}

