/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonNull;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.schema.IdentifiableJsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.schema.QueryCharacteristic;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.timeseries.GranularityDefinition;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CollectionOptions {
    private @Nullable Long maxDocuments;
    private @Nullable Long size;
    private @Nullable Boolean capped;
    private @Nullable Collation collation;
    private ValidationOptions validationOptions;
    private @Nullable TimeSeriesOptions timeSeriesOptions;
    private @Nullable CollectionChangeStreamOptions changeStreamOptions;
    private @Nullable EncryptedFieldsOptions encryptedFieldsOptions;

    private CollectionOptions(@Nullable Long size, @Nullable Long maxDocuments, @Nullable Boolean capped, @Nullable Collation collation, ValidationOptions validationOptions, @Nullable TimeSeriesOptions timeSeriesOptions, @Nullable CollectionChangeStreamOptions changeStreamOptions, @Nullable EncryptedFieldsOptions encryptedFieldsOptions) {
        this.maxDocuments = maxDocuments;
        this.size = size;
        this.capped = capped;
        this.collation = collation;
        this.validationOptions = validationOptions;
        this.timeSeriesOptions = timeSeriesOptions;
        this.changeStreamOptions = changeStreamOptions;
        this.encryptedFieldsOptions = encryptedFieldsOptions;
    }

    public static CollectionOptions just(Collation collation) {
        Assert.notNull((Object)collation, (String)"Collation must not be null");
        return new CollectionOptions(null, null, null, collation, ValidationOptions.none(), null, null, null);
    }

    public static CollectionOptions empty() {
        return new CollectionOptions(null, null, null, null, ValidationOptions.none(), null, null, null);
    }

    public static CollectionOptions timeSeries(String timeField) {
        return CollectionOptions.timeSeries(timeField, it -> it);
    }

    public static CollectionOptions timeSeries(String timeField, Function<TimeSeriesOptions, TimeSeriesOptions> options) {
        return CollectionOptions.empty().timeSeries(options.apply(TimeSeriesOptions.timeSeries(timeField)));
    }

    public static CollectionOptions emitChangedRevisions() {
        return CollectionOptions.empty().changeStream(CollectionChangeStreamOptions.preAndPostImages(true));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public static CollectionOptions encryptedCollection(@Nullable EncryptedFieldsOptions encryptedFieldsOptions) {
        return new CollectionOptions(null, null, null, null, ValidationOptions.NONE, null, null, encryptedFieldsOptions);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public static CollectionOptions encryptedCollection(MongoJsonSchema schema) {
        return CollectionOptions.encryptedCollection(EncryptedFieldsOptions.fromSchema(schema));
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public static CollectionOptions encryptedCollection(Function<EncryptedFieldsOptions, EncryptedFieldsOptions> optionsFunction) {
        return CollectionOptions.encryptedCollection(optionsFunction.apply(new EncryptedFieldsOptions()));
    }

    public CollectionOptions capped() {
        return new CollectionOptions(this.size, this.maxDocuments, true, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions maxDocuments(long maxDocuments) {
        return new CollectionOptions(this.size, maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions size(long size) {
        return new CollectionOptions(size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions collation(@Nullable Collation collation) {
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions schema(MongoJsonSchema schema) {
        return this.validator(schema != null ? Validator.schema(schema) : null);
    }

    public CollectionOptions validator(@Nullable Validator validator) {
        return this.validation(this.validationOptions.validator(validator));
    }

    public CollectionOptions disableValidation() {
        return this.schemaValidationLevel(ValidationLevel.OFF);
    }

    public CollectionOptions strictValidation() {
        return this.schemaValidationLevel(ValidationLevel.STRICT);
    }

    public CollectionOptions moderateValidation() {
        return this.schemaValidationLevel(ValidationLevel.MODERATE);
    }

    public CollectionOptions warnOnValidationError() {
        return this.schemaValidationAction(ValidationAction.WARN);
    }

    public CollectionOptions failOnValidationError() {
        return this.schemaValidationAction(ValidationAction.ERROR);
    }

    public CollectionOptions schemaValidationLevel(ValidationLevel validationLevel) {
        Assert.notNull((Object)validationLevel, (String)"ValidationLevel must not be null");
        return this.validation(this.validationOptions.validationLevel(validationLevel));
    }

    public CollectionOptions schemaValidationAction(ValidationAction validationAction) {
        Assert.notNull((Object)validationAction, (String)"ValidationAction must not be null");
        return this.validation(this.validationOptions.validationAction(validationAction));
    }

    public CollectionOptions validation(ValidationOptions validationOptions) {
        Assert.notNull((Object)validationOptions, (String)"ValidationOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, validationOptions, this.timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions timeSeries(TimeSeriesOptions timeSeriesOptions) {
        Assert.notNull((Object)timeSeriesOptions, (String)"TimeSeriesOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, timeSeriesOptions, this.changeStreamOptions, this.encryptedFieldsOptions);
    }

    public CollectionOptions changeStream(CollectionChangeStreamOptions changeStreamOptions) {
        Assert.notNull((Object)changeStreamOptions, (String)"ChangeStreamOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, changeStreamOptions, this.encryptedFieldsOptions);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    public CollectionOptions encrypted(EncryptedFieldsOptions encryptedFieldsOptions) {
        Assert.notNull((Object)encryptedFieldsOptions, (String)"EncryptedCollectionOptions must not be null");
        return new CollectionOptions(this.size, this.maxDocuments, this.capped, this.collation, this.validationOptions, this.timeSeriesOptions, this.changeStreamOptions, encryptedFieldsOptions);
    }

    public Optional<Long> getMaxDocuments() {
        return Optional.ofNullable(this.maxDocuments);
    }

    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public Optional<Boolean> getCapped() {
        return Optional.ofNullable(this.capped);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<ValidationOptions> getValidationOptions() {
        return this.validationOptions.isEmpty() ? Optional.empty() : Optional.of(this.validationOptions);
    }

    public Optional<TimeSeriesOptions> getTimeSeriesOptions() {
        return Optional.ofNullable(this.timeSeriesOptions);
    }

    public Optional<CollectionChangeStreamOptions> getChangeStreamOptions() {
        return Optional.ofNullable(this.changeStreamOptions);
    }

    public Optional<EncryptedFieldsOptions> getEncryptedFieldsOptions() {
        return Optional.ofNullable(this.encryptedFieldsOptions);
    }

    public String toString() {
        return "CollectionOptions{maxDocuments=" + this.maxDocuments + ", size=" + this.size + ", capped=" + this.capped + ", collation=" + this.collation + ", validationOptions=" + this.validationOptions + ", timeSeriesOptions=" + this.timeSeriesOptions + ", changeStreamOptions=" + this.changeStreamOptions + ", encryptedCollectionOptions=" + this.encryptedFieldsOptions + ", disableValidation=" + this.disableValidation() + ", strictValidation=" + this.strictValidation() + ", moderateValidation=" + this.moderateValidation() + ", warnOnValidationError=" + this.warnOnValidationError() + ", failOnValidationError=" + this.failOnValidationError() + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionOptions that = (CollectionOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.maxDocuments, (Object)that.maxDocuments)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.size, (Object)that.size)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.capped, (Object)that.capped)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.collation, (Object)that.collation)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.validationOptions, (Object)that.validationOptions)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.timeSeriesOptions, (Object)that.timeSeriesOptions)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.changeStreamOptions, (Object)that.changeStreamOptions)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.encryptedFieldsOptions, (Object)that.encryptedFieldsOptions);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.maxDocuments);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.size);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.capped);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.collation);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationOptions);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.timeSeriesOptions);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.changeStreamOptions);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.encryptedFieldsOptions);
        return result;
    }

    private static void collectPaths(Document document, @Nullable String currentPath, Map<String, Document> paths) {
        if (document.containsKey((Object)"type") && document.get((Object)"type").equals("object")) {
            Object o = document.get((Object)"properties");
            if (o == null) {
                return;
            }
            if (o instanceof Document) {
                Document properties = (Document)o;
                for (Map.Entry entry : properties.entrySet()) {
                    String path;
                    Object v = entry.getValue();
                    if (!(v instanceof Document)) continue;
                    Document nested = (Document)v;
                    String string = path = currentPath == null ? (String)entry.getKey() : currentPath + "." + (String)entry.getKey();
                    if (nested.containsKey((Object)"encrypt")) {
                        Object e;
                        List queries;
                        Document target = new Document((Map)nested.get((Object)"encrypt", Document.class));
                        if (nested.containsKey((Object)"queries") && !(queries = (List)nested.get((Object)"queries", List.class)).isEmpty() && (e = queries.iterator().next()) instanceof Document) {
                            Document qd = (Document)e;
                            target.putAll((Map)qd);
                        }
                        paths.put(path, target);
                        continue;
                    }
                    CollectionOptions.collectPaths(nested, path, paths);
                }
            }
        }
    }

    public static class ValidationOptions {
        private static final ValidationOptions NONE = new ValidationOptions(null, null, null);
        private final @Nullable Validator validator;
        private final @Nullable ValidationLevel validationLevel;
        private final @Nullable ValidationAction validationAction;

        public ValidationOptions(@Nullable Validator validator, @Nullable ValidationLevel validationLevel, @Nullable ValidationAction validationAction) {
            this.validator = validator;
            this.validationLevel = validationLevel;
            this.validationAction = validationAction;
        }

        public static ValidationOptions none() {
            return NONE;
        }

        @Contract(value="_ -> new")
        public ValidationOptions validator(@Nullable Validator validator) {
            return new ValidationOptions(validator, this.validationLevel, this.validationAction);
        }

        @Contract(value="_ -> new")
        public ValidationOptions validationLevel(ValidationLevel validationLevel) {
            return new ValidationOptions(this.validator, validationLevel, this.validationAction);
        }

        @Contract(value="_ -> new")
        public ValidationOptions validationAction(ValidationAction validationAction) {
            return new ValidationOptions(this.validator, this.validationLevel, validationAction);
        }

        public Optional<Validator> getValidator() {
            return Optional.ofNullable(this.validator);
        }

        public Optional<ValidationLevel> getValidationLevel() {
            return Optional.ofNullable(this.validationLevel);
        }

        public Optional<ValidationAction> getValidationAction() {
            return Optional.ofNullable(this.validationAction);
        }

        boolean isEmpty() {
            return !Optionals.isAnyPresent((Optional[])new Optional[]{this.getValidator(), this.getValidationAction(), this.getValidationLevel()});
        }

        public String toString() {
            return "ValidationOptions{validator=" + this.validator + ", validationLevel=" + this.validationLevel + ", validationAction=" + this.validationAction + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationOptions that = (ValidationOptions)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.validator, (Object)that.validator)) {
                return false;
            }
            if (this.validationLevel != that.validationLevel) {
                return false;
            }
            return this.validationAction == that.validationAction;
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.validator);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationLevel);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.validationAction);
            return result;
        }
    }

    public static class TimeSeriesOptions {
        private final String timeField;
        private final @Nullable String metaField;
        private final GranularityDefinition granularity;
        private final Duration expireAfter;

        private TimeSeriesOptions(String timeField, @Nullable String metaField, GranularityDefinition granularity, Duration expireAfter) {
            Assert.hasText((String)timeField, (String)"Time field must not be empty or null");
            this.timeField = timeField;
            this.metaField = metaField;
            this.granularity = granularity;
            this.expireAfter = expireAfter;
        }

        public static TimeSeriesOptions timeSeries(String timeField) {
            return new TimeSeriesOptions(timeField, null, Granularity.DEFAULT, Duration.ofSeconds(-1L));
        }

        @Contract(value="_ -> new")
        public TimeSeriesOptions metaField(String metaField) {
            return new TimeSeriesOptions(this.timeField, metaField, this.granularity, this.expireAfter);
        }

        @Contract(value="_ -> new")
        public TimeSeriesOptions granularity(GranularityDefinition granularity) {
            return new TimeSeriesOptions(this.timeField, this.metaField, granularity, this.expireAfter);
        }

        @Contract(value="_ -> new")
        public TimeSeriesOptions expireAfter(Duration ttl) {
            return new TimeSeriesOptions(this.timeField, this.metaField, this.granularity, ttl);
        }

        public String getTimeField() {
            return this.timeField;
        }

        public @Nullable String getMetaField() {
            return this.metaField;
        }

        public GranularityDefinition getGranularity() {
            return this.granularity;
        }

        public Duration getExpireAfter() {
            return this.expireAfter;
        }

        public String toString() {
            return "TimeSeriesOptions{timeField='" + this.timeField + "', metaField='" + this.metaField + "', granularity=" + this.granularity + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesOptions that = (TimeSeriesOptions)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.timeField, (Object)that.timeField)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.metaField, (Object)that.metaField)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.granularity, (Object)that.granularity);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.timeField);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.metaField);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.granularity);
            return result;
        }
    }

    public static class CollectionChangeStreamOptions {
        private final boolean preAndPostImages;

        private CollectionChangeStreamOptions(boolean emitChangedRevisions) {
            this.preAndPostImages = emitChangedRevisions;
        }

        public static CollectionChangeStreamOptions preAndPostImages(boolean emitChangedRevisions) {
            return new CollectionChangeStreamOptions(true);
        }

        public boolean getPreAndPostImages() {
            return this.preAndPostImages;
        }

        public String toString() {
            return "CollectionChangeStreamOptions{preAndPostImages=" + this.preAndPostImages + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionChangeStreamOptions that = (CollectionChangeStreamOptions)o;
            return this.preAndPostImages == that.preAndPostImages;
        }

        public int hashCode() {
            return this.preAndPostImages ? 1 : 0;
        }
    }

    public static class EncryptedFieldsOptions {
        private static final EncryptedFieldsOptions NONE = new EncryptedFieldsOptions();
        private final @Nullable MongoJsonSchema schema;
        private final List<IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty> queryableProperties;

        EncryptedFieldsOptions() {
            this(null, List.of());
        }

        private EncryptedFieldsOptions(@Nullable MongoJsonSchema schema, List<IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty> queryableProperties) {
            this.schema = schema;
            this.queryableProperties = queryableProperties;
        }

        public static EncryptedFieldsOptions none() {
            return NONE;
        }

        public static EncryptedFieldsOptions fromSchema(MongoJsonSchema schema) {
            return new EncryptedFieldsOptions(schema, List.of());
        }

        public static EncryptedFieldsOptions fromProperties(List<IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty> properties) {
            return new EncryptedFieldsOptions(null, List.copyOf(properties));
        }

        @Contract(value="_, _ -> new")
        @CheckReturnValue
        public EncryptedFieldsOptions queryable(JsonSchemaProperty property, QueryCharacteristic ... characteristics) {
            ArrayList<IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty> targetPropertyList = new ArrayList<IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty>(this.queryableProperties.size() + 1);
            targetPropertyList.addAll(this.queryableProperties);
            targetPropertyList.add(JsonSchemaProperty.queryable(property, List.of(characteristics)));
            return new EncryptedFieldsOptions(this.schema, targetPropertyList);
        }

        public Document toDocument() {
            return new Document("fields", this.selectPaths());
        }

        private List<Document> selectPaths() {
            LinkedHashMap<String, Document> fields = new LinkedHashMap<String, Document>();
            for (Document field : this.fromSchema()) {
                fields.put((String)field.get((Object)"path", String.class), field);
            }
            for (Document field : this.fromProperties()) {
                fields.put((String)field.get((Object)"path", String.class), field);
            }
            return List.copyOf(fields.values());
        }

        private List<Document> fromProperties() {
            if (this.queryableProperties.isEmpty()) {
                return List.of();
            }
            ArrayList<Document> converted = new ArrayList<Document>(this.queryableProperties.size());
            for (IdentifiableJsonSchemaProperty.QueryableJsonSchemaProperty property : this.queryableProperties) {
                IdentifiableJsonSchemaProperty.EncryptedJsonSchemaProperty encrypted;
                JsonSchemaProperty jsonSchemaProperty;
                Document field = new Document("path", (Object)property.getIdentifier());
                if (!property.getTypes().isEmpty()) {
                    field.append("bsonType", property.getTypes().iterator().next().toBsonType().value());
                }
                if ((jsonSchemaProperty = property.getTargetProperty()) instanceof IdentifiableJsonSchemaProperty.EncryptedJsonSchemaProperty && (encrypted = (IdentifiableJsonSchemaProperty.EncryptedJsonSchemaProperty)jsonSchemaProperty).getKeyId() != null) {
                    Object object = encrypted.getKeyId();
                    if (object instanceof String) {
                        String stringKey = (String)object;
                        field.append("keyId", (Object)new BsonBinary(BsonBinarySubType.UUID_STANDARD, stringKey.getBytes(StandardCharsets.UTF_8)));
                    } else {
                        field.append("keyId", encrypted.getKeyId());
                    }
                }
                field.append("queries", StreamSupport.stream(property.getCharacteristics().spliterator(), false).map(QueryCharacteristic::toDocument).toList());
                if (!field.containsKey((Object)"keyId")) {
                    field.append("keyId", (Object)BsonNull.VALUE);
                }
                converted.add(field);
            }
            return converted;
        }

        private List<Document> fromSchema() {
            if (this.schema == null) {
                return List.of();
            }
            Document root = this.schema.schemaDocument();
            LinkedHashMap<String, Document> paths = new LinkedHashMap<String, Document>();
            CollectionOptions.collectPaths(root, null, paths);
            ArrayList<Document> fields = new ArrayList<Document>();
            if (!paths.isEmpty()) {
                for (Map.Entry entry : paths.entrySet()) {
                    Document field = new Document("path", entry.getKey());
                    field.append("keyId", ((Document)entry.getValue()).getOrDefault((Object)"keyId", (Object)BsonNull.VALUE));
                    if (((Document)entry.getValue()).containsKey((Object)"bsonType")) {
                        field.append("bsonType", ((Document)entry.getValue()).get((Object)"bsonType"));
                    }
                    field.put("queries", ((Document)entry.getValue()).get((Object)"queries"));
                    fields.add(field);
                }
            }
            return fields;
        }
    }
}

