/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ConnectionString;
import com.mongodb.RequestContext;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.ObservationView;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.observability.DefaultMongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoHandlerContext;
import org.springframework.data.mongodb.observability.MongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoObservation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoObservationCommandListener
implements CommandListener {
    private static final Log log = LogFactory.getLog(MongoObservationCommandListener.class);
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ConnectionString connectionString;
    private final MongoHandlerObservationConvention observationConvention;

    public MongoObservationCommandListener(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public MongoObservationCommandListener(ObservationRegistry observationRegistry, @Nullable ConnectionString connectionString) {
        this(observationRegistry, connectionString, new DefaultMongoHandlerObservationConvention());
    }

    public MongoObservationCommandListener(ObservationRegistry observationRegistry, @Nullable ConnectionString connectionString, MongoHandlerObservationConvention observationConvention) {
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        Assert.notNull((Object)observationConvention, (String)"ObservationConvention must not be null");
        this.observationRegistry = observationRegistry;
        this.connectionString = connectionString;
        this.observationConvention = observationConvention;
    }

    public void commandStarted(CommandStartedEvent event) {
        String databaseName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Instrumenting the command started event");
        }
        if ("admin".equals(databaseName = event.getDatabaseName())) {
            return;
        }
        RequestContext requestContext = event.getRequestContext();
        if (requestContext == null) {
            return;
        }
        Observation parent = MongoObservationCommandListener.observationFromContext(requestContext);
        MongoHandlerContext observationContext = new MongoHandlerContext(this.connectionString, event, requestContext);
        observationContext.setRemoteServiceName("mongo");
        Observation observation = MongoObservation.MONGODB_COMMAND_OBSERVATION.observation(this.observationRegistry, () -> observationContext).observationConvention((ObservationConvention)this.observationConvention);
        if (parent != null) {
            observation.parentObservation(parent);
        }
        observation.start();
        requestContext.put((Object)"micrometer.observation", (Object)observation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a child observation  [" + String.valueOf(observation) + "] for Mongo instrumentation and put it in Mongo context"));
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        this.stopObservation(event.getRequestContext(), (observation, context) -> {
            context.setCommandSucceededEvent(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Command succeeded - will stop observation [" + String.valueOf(observation) + "]"));
            }
        });
    }

    public void commandFailed(CommandFailedEvent event) {
        this.stopObservation(event.getRequestContext(), (observation, context) -> {
            context.setCommandFailedEvent(event);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Command failed - will stop observation [" + String.valueOf(observation) + "]"));
            }
            observation.error(event.getThrowable());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopObservation(@Nullable RequestContext requestContext, BiConsumer<Observation, MongoHandlerContext> action) {
        Observation.Context context;
        if (requestContext == null) {
            return;
        }
        Observation observation = (Observation)requestContext.getOrDefault((Object)"micrometer.observation", null);
        if (observation == null || !((context = observation.getContext()) instanceof MongoHandlerContext)) {
            return;
        }
        MongoHandlerContext context2 = (MongoHandlerContext)context;
        try {
            action.accept(observation, context2);
        }
        finally {
            ObservationView parentObservation;
            observation.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restoring parent observation [" + String.valueOf(observation) + "] for Mongo instrumentation and put it in Mongo context"));
            }
            if ((parentObservation = observation.getContext().getParentObservation()) == null) {
                requestContext.delete((Object)"micrometer.observation");
            } else {
                requestContext.put((Object)"micrometer.observation", (Object)parentObservation);
            }
        }
    }

    @Nullable
    private static Observation observationFromContext(RequestContext context) {
        Observation observation = (Observation)context.getOrDefault((Object)"micrometer.observation", null);
        if (observation != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a observation in Mongo context [" + String.valueOf(observation) + "]"));
            }
            return observation;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No observation was found: Creating a new root observation");
        }
        return null;
    }
}

