/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public class LoggingEventListener
extends AbstractMongoEventListener<Object> {
    private static final Log LOGGER = LogFactory.getLog(LoggingEventListener.class);

    @Override
    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onBeforeConvert: %s", event.getSource()));
        }
    }

    @Override
    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onBeforeSave: %s, %s", event.getSource(), SerializationUtils.serializeToJsonSafely(event.getDocument())));
        }
    }

    @Override
    public void onAfterSave(AfterSaveEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onAfterSave: %s, %s", event.getSource(), SerializationUtils.serializeToJsonSafely(event.getDocument())));
        }
    }

    @Override
    public void onAfterLoad(AfterLoadEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onAfterLoad: %s", SerializationUtils.serializeToJsonSafely(event.getDocument())));
        }
    }

    @Override
    public void onAfterConvert(AfterConvertEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onAfterConvert: %s, %s", SerializationUtils.serializeToJsonSafely(event.getDocument()), event.getSource()));
        }
    }

    @Override
    public void onAfterDelete(AfterDeleteEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onAfterDelete: %s", SerializationUtils.serializeToJsonSafely(event.getDocument())));
        }
    }

    @Override
    public void onBeforeDelete(BeforeDeleteEvent<Object> event) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("onBeforeDelete: %s", SerializationUtils.serializeToJsonSafely(event.getDocument())));
        }
    }
}

