/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ConnectionString;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoParsingUtils;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbFactoryParser
extends AbstractBeanDefinitionParser {
    private static final Set<String> MONGO_URI_ALLOWED_ADDITIONAL_ATTRIBUTES = Set.of("id", "write-concern");

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "mongoDbFactory";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder dbFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMongoClientDatabaseFactory.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)dbFactoryBuilder, (Element)element, (String)"write-concern", (String)"writeConcern");
        BeanDefinition mongoUri = this.getConnectionString(element, parserContext);
        if (mongoUri != null) {
            dbFactoryBuilder.addConstructorArgValue((Object)mongoUri);
            return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)dbFactoryBuilder, (ParserContext)parserContext, (Element)element);
        }
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        String mongoRef = element.getAttribute("mongo-client-ref");
        String dbname = element.getAttribute("dbname");
        if (StringUtils.hasText((String)mongoRef)) {
            dbFactoryBuilder.addConstructorArgReference(mongoRef);
        } else {
            dbFactoryBuilder.addConstructorArgValue((Object)this.registerMongoBeanDefinition(element, parserContext));
        }
        dbFactoryBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)dbname) ? dbname : "db"));
        BeanDefinitionBuilder writeConcernPropertyEditorBuilder = MongoParsingUtils.getWriteConcernPropertyEditorBuilder();
        BeanComponentDefinition component = helper.getComponent(writeConcernPropertyEditorBuilder);
        parserContext.registerBeanComponent(component);
        return (AbstractBeanDefinition)helper.getComponentIdButFallback(dbFactoryBuilder, "mongoDbFactory").getBeanDefinition();
    }

    private BeanDefinition registerMongoBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder mongoBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"host");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)mongoBuilder, (Element)element, (String)"port");
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)mongoBuilder, (ParserContext)parserContext, (Element)element);
    }

    @Nullable
    private BeanDefinition getConnectionString(Element element, ParserContext parserContext) {
        String type = null;
        if (element.hasAttribute("client-uri")) {
            type = "client-uri";
        } else if (element.hasAttribute("connection-string")) {
            type = "connection-string";
        } else if (element.hasAttribute("uri")) {
            type = "uri";
        }
        if (!StringUtils.hasText((String)type)) {
            return null;
        }
        int allowedAttributesCount = 1;
        for (String attribute : MONGO_URI_ALLOWED_ADDITIONAL_ATTRIBUTES) {
            if (!element.hasAttribute(attribute)) continue;
            ++allowedAttributesCount;
        }
        if (element.getAttributes().getLength() > allowedAttributesCount) {
            parserContext.getReaderContext().error("Configure either MongoDB " + type + " or details individually", parserContext.extractSource((Object)element));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionString.class);
        builder.addConstructorArgValue((Object)element.getAttribute(type));
        return builder.getBeanDefinition();
    }
}

