/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.util.ObjectUtils;

final class KeyId
extends Record
implements EncryptionKey {
    private final BsonBinary value;

    KeyId(BsonBinary value) {
        this.value = value;
    }

    @Override
    public EncryptionKey.Type type() {
        return EncryptionKey.Type.ID;
    }

    @Override
    public String toString() {
        String representation;
        if (BsonBinarySubType.isUuid((byte)this.value.getType()) && (representation = this.value.asUuid().toString()).length() > 6) {
            return String.format("KeyId('%s***')", representation.substring(0, 6));
        }
        return "KeyId('***')";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyId that = (KeyId)o;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value);
    }

    public BsonBinary value() {
        return this.value;
    }
}

