/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class BasicUpdate
extends Update {
    private final Document updateObject;

    public BasicUpdate(String updateString) {
        this(Document.parse((String)updateString));
    }

    public BasicUpdate(Document updateObject) {
        this.updateObject = updateObject;
    }

    @Override
    public Update set(String key, @Nullable Object value) {
        this.setOperationValue("$set", key, value);
        return this;
    }

    @Override
    public Update unset(String key) {
        this.setOperationValue("$unset", key, 1);
        return this;
    }

    @Override
    public Update inc(String key, Number inc) {
        this.setOperationValue("$inc", key, inc);
        return this;
    }

    @Override
    public Update push(String key, @Nullable Object value) {
        this.setOperationValue("$push", key, value);
        return this;
    }

    @Override
    public Update addToSet(String key, @Nullable Object value) {
        this.setOperationValue("$addToSet", key, value);
        return this;
    }

    @Override
    public Update pop(String key, Update.Position pos) {
        this.setOperationValue("$pop", key, pos == Update.Position.FIRST ? -1 : 1);
        return this;
    }

    @Override
    public Update pull(String key, @Nullable Object value) {
        this.setOperationValue("$pull", key, value);
        return this;
    }

    @Override
    public Update pullAll(String key, Object[] values) {
        this.setOperationValue("$pullAll", key, List.of(values), (o, o2) -> {
            if (o instanceof List) {
                List prev = (List)o;
                if (o2 instanceof List) {
                    List currentValue = (List)o2;
                    ArrayList merged = new ArrayList(prev.size() + currentValue.size());
                    merged.addAll(prev);
                    merged.addAll(currentValue);
                    return merged;
                }
            }
            return o2;
        });
        return this;
    }

    @Override
    public Update rename(String oldName, String newName) {
        this.setOperationValue("$rename", oldName, newName);
        return this;
    }

    @Override
    public boolean modifies(String key) {
        return super.modifies(key) || Update.fromDocument(this.getUpdateObject(), new String[0]).modifies(key);
    }

    @Override
    public Document getUpdateObject() {
        return this.updateObject;
    }

    void setOperationValue(String operator, String key, @Nullable Object value) {
        this.setOperationValue(operator, key, value, (o, o2) -> o2);
    }

    void setOperationValue(String operator, String key, @Nullable Object value, BiFunction<Object, Object, Object> mergeFunction) {
        if (!this.updateObject.containsKey((Object)operator)) {
            this.updateObject.put(operator, Collections.singletonMap(key, value));
        } else {
            Object o = this.updateObject.get((Object)operator);
            if (o instanceof Map) {
                Map existing = (Map)o;
                LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>(existing);
                if (target.containsKey(key)) {
                    target.put(key, mergeFunction.apply(target.get(key), value));
                } else {
                    target.put(key, value);
                }
                this.updateObject.put(operator, target);
            } else {
                throw new IllegalStateException("Cannot add ['%s' : { '%s' : ... }]. Operator already exists with value of type [%s] which is not suitable for appending".formatted(operator, key, o != null ? ClassUtils.getShortName(o.getClass()) : "null"));
            }
        }
    }
}

