/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.data.mongodb.core.AggregationUtil;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.CollectionPreparer;
import org.springframework.data.mongodb.core.CollectionPreparerSupport;
import org.springframework.data.mongodb.core.CountQuery;
import org.springframework.data.mongodb.core.CursorPreparer;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DefaultBulkOperations;
import org.springframework.data.mongodb.core.DefaultIndexOperations;
import org.springframework.data.mongodb.core.DefaultScriptOperations;
import org.springframework.data.mongodb.core.DefaultWriteConcernResolver;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.EntityLifecycleEventDelegate;
import org.springframework.data.mongodb.core.EntityOperations;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.ExecutableAggregationOperationSupport;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableFindOperationSupport;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.ExecutableInsertOperationSupport;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperation;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperationSupport;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperationSupport;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperationSupport;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.HintFunction;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.MongoAction;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.PropertyOperations;
import org.springframework.data.mongodb.core.QueryOperations;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.data.mongodb.core.ReplaceOptions;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.ScrollUtils;
import org.springframework.data.mongodb.core.SessionScoped;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.ViewOptions;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.JsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.IndexOperationsProvider;
import org.springframework.data.mongodb.core.index.MongoMappingEventPublisher;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class MongoTemplate
implements MongoOperations,
ApplicationContextAware,
IndexOperationsProvider,
ReadPreferenceAware {
    private static final Log LOGGER = LogFactory.getLog(MongoTemplate.class);
    private static final WriteResultChecking DEFAULT_WRITE_RESULT_CHECKING = WriteResultChecking.NONE;
    private final MongoConverter mongoConverter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoDatabaseFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final JsonSchemaMapper schemaMapper;
    private final EntityOperations operations;
    private final PropertyOperations propertyOperations;
    private final QueryOperations queryOperations;
    private final EntityLifecycleEventDelegate eventDelegate;
    @Nullable
    private WriteConcern writeConcern;
    private WriteConcernResolver writeConcernResolver = DefaultWriteConcernResolver.INSTANCE;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    @Nullable
    private ReadPreference readPreference;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    @Nullable
    private EntityCallbacks entityCallbacks;
    @Nullable
    private ResourceLoader resourceLoader;
    @Nullable
    private MongoPersistentEntityIndexCreator indexCreator;
    private SessionSynchronization sessionSynchronization = SessionSynchronization.ON_ACTUAL_TRANSACTION;
    private CountExecution countExecution = this::doExactCount;

    public MongoTemplate(MongoClient mongoClient, String databaseName) {
        this((MongoDatabaseFactory)new SimpleMongoClientDatabaseFactory(mongoClient, databaseName), (MongoConverter)null);
    }

    public MongoTemplate(MongoDatabaseFactory mongoDbFactory) {
        this(mongoDbFactory, (MongoConverter)null);
    }

    public MongoTemplate(MongoDatabaseFactory mongoDbFactory, @Nullable MongoConverter mongoConverter) {
        MongoMappingContext mappingContext;
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory must not be null");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.mongoConverter = mongoConverter == null ? MongoTemplate.getDefaultMongoConverter(mongoDbFactory) : mongoConverter;
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
        this.schemaMapper = new MongoJsonSchemaMapper(this.mongoConverter);
        this.operations = new EntityOperations(this.mongoConverter, this.queryMapper);
        this.propertyOperations = new PropertyOperations(this.mongoConverter.getMappingContext());
        this.queryOperations = new QueryOperations(this.queryMapper, this.updateMapper, this.operations, this.propertyOperations, mongoDbFactory);
        this.eventDelegate = new EntityLifecycleEventDelegate();
        this.mappingContext = this.mongoConverter.getMappingContext();
        MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext2 = this.mappingContext;
        if (mappingContext2 instanceof MongoMappingContext && (mappingContext = (MongoMappingContext)mappingContext2).isAutoIndexCreation()) {
            this.indexCreator = new MongoPersistentEntityIndexCreator(mappingContext, this);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            mappingContext.setApplicationEventPublisher(this.eventPublisher);
        }
    }

    private MongoTemplate(MongoDatabaseFactory dbFactory, MongoTemplate that) {
        this.mongoDbFactory = dbFactory;
        this.exceptionTranslator = that.exceptionTranslator;
        this.sessionSynchronization = that.sessionSynchronization;
        MongoConverter mongoConverter = that.mongoConverter;
        if (mongoConverter instanceof MappingMongoConverter) {
            MappingMongoConverter mappingMongoConverter = (MappingMongoConverter)mongoConverter;
            this.mongoConverter = mappingMongoConverter.with(dbFactory);
        } else {
            this.mongoConverter = that.mongoConverter;
        }
        this.queryMapper = that.queryMapper;
        this.updateMapper = that.updateMapper;
        this.schemaMapper = that.schemaMapper;
        this.mappingContext = that.mappingContext;
        this.operations = that.operations;
        this.propertyOperations = that.propertyOperations;
        this.queryOperations = that.queryOperations;
        this.eventDelegate = that.eventDelegate;
    }

    public void setWriteResultChecking(@Nullable WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking == null ? DEFAULT_WRITE_RESULT_CHECKING : resultChecking;
    }

    public void setWriteConcern(@Nullable WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setWriteConcernResolver(@Nullable WriteConcernResolver writeConcernResolver) {
        this.writeConcernResolver = writeConcernResolver == null ? DefaultWriteConcernResolver.INSTANCE : writeConcernResolver;
    }

    public void setReadPreference(@Nullable ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    @Override
    public boolean hasReadPreference() {
        return this.readPreference != null;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setEntityLifecycleEventsEnabled(boolean enabled) {
        this.eventDelegate.setEventsEnabled(enabled);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        this.prepareIndexCreator(applicationContext);
        this.eventPublisher = applicationContext;
        this.eventDelegate.setPublisher(this.eventPublisher);
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
        if ((mappingContext = this.mappingContext) instanceof ApplicationEventPublisherAware) {
            ApplicationEventPublisherAware applicationEventPublisherAware = (ApplicationEventPublisherAware)mappingContext;
            applicationEventPublisherAware.setApplicationEventPublisher(this.eventPublisher);
        }
        this.resourceLoader = applicationContext;
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    public void useEstimatedCount(boolean enabled) {
        this.useEstimatedCount(enabled, this::countCanBeEstimated);
    }

    private void useEstimatedCount(boolean enabled, BiPredicate<Document, CountOptions> estimationFilter) {
        this.countExecution = enabled ? (collectionPreparer, collectionName, filter, options) -> {
            if (!estimationFilter.test(filter, options)) {
                return this.doExactCount(collectionPreparer, collectionName, filter, options);
            }
            EstimatedDocumentCountOptions estimatedDocumentCountOptions = new EstimatedDocumentCountOptions();
            if (options.getMaxTime(TimeUnit.MILLISECONDS) > 0L) {
                estimatedDocumentCountOptions.maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            }
            return this.doEstimatedCount(collectionPreparer, collectionName, estimatedDocumentCountOptions);
        } : this::doExactCount;
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(MongoPersistentEntityIndexCreator.class)) {
            MongoPersistentEntityIndexCreator creatorBean = (MongoPersistentEntityIndexCreator)context.getBean(creator, MongoPersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
            if (this.indexCreator != null) {
                configurableApplicationContext.addApplicationListener((ApplicationListener)this.indexCreator);
            }
        }
    }

    @Override
    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public <T> Stream<T> stream(Query query, Class<T> entityType) {
        return this.stream(query, entityType, this.getCollectionName(entityType));
    }

    @Override
    public <T> Stream<T> stream(Query query, Class<T> entityType, String collectionName) {
        return this.doStream(query, entityType, collectionName, entityType);
    }

    protected <T> Stream<T> doStream(Query query, Class<?> entityType, String collectionName, Class<T> returnType) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityType, (String)"Entity type must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        Assert.notNull(returnType, (String)"ReturnType must not be null");
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
            QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
            EntityProjection projection = this.operations.introspectProjection(returnType, entityType);
            Document mappedQuery = queryContext.getMappedQuery(persistentEntity);
            Document mappedFields = queryContext.getMappedFields(persistentEntity, projection);
            CollectionPreparerSupport.CollectionPreparerDelegate readPreference = this.createDelegate(query);
            FindIterable<Document> cursor = new QueryCursorPreparer(query, entityType).initiateFind((MongoCollection<Document>)collection, col -> readPreference.prepare((MongoCollection<Document>)col).find((Bson)mappedQuery, Document.class).projection((Bson)mappedFields));
            return new CloseableIterableCursorAdapter((MongoIterable<Document>)cursor, this.exceptionTranslator, new ProjectingReadCallback(this.mongoConverter, projection, collectionName)).stream();
        });
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.operations.determineCollectionName(entityClass);
    }

    @Override
    public Document executeCommand(String jsonCommand) {
        Assert.hasText((String)jsonCommand, (String)"JsonCommand must not be null nor empty");
        return this.execute(db -> (Document)db.runCommand((Bson)Document.parse((String)jsonCommand), Document.class));
    }

    @Override
    public Document executeCommand(Document command) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        return this.execute(db -> (Document)db.runCommand((Bson)command, Document.class));
    }

    @Override
    public Document executeCommand(Document command, @Nullable ReadPreference readPreference) {
        Assert.notNull((Object)command, (String)"Command must not be null");
        return this.execute(db -> readPreference != null ? (Document)db.runCommand((Bson)command, readPreference, Document.class) : (Document)db.runCommand((Bson)command, Document.class));
    }

    @Override
    public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.executeQuery(query, collectionName, dch, new QueryCursorPreparer(query, null));
    }

    protected void executeQuery(Query query, String collectionName, DocumentCallbackHandler documentCallbackHandler, @Nullable CursorPreparer preparer) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull((Object)documentCallbackHandler, (String)"DocumentCallbackHandler must not be null");
        Document queryObject = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), Optional.empty());
        Document sortObject = query.getSortObject();
        Document fieldsObject = query.getFieldsObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Executing query: %s sort: %s fields: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObject), sortObject, fieldsObject, collectionName));
        }
        this.executeQueryInternal(new FindCallback(this.createDelegate(query), queryObject, fieldsObject, null), preparer != null ? preparer : CursorPreparer.NO_OP_PREPARER, documentCallbackHandler, collectionName);
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action, (String)"DbCallback must not be null");
        try {
            MongoDatabase db = this.prepareDatabase(this.doGetDatabase());
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.execute(this.getCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(callback, (String)"CollectionCallback must not be null");
        try {
            MongoCollection<Document> collection = this.getAndPrepareCollection(this.doGetDatabase(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public SessionScoped withSession(ClientSessionOptions options) {
        Assert.notNull((Object)options, (String)"ClientSessionOptions must not be null");
        return this.withSession(() -> this.mongoDbFactory.getSession(options));
    }

    @Override
    public MongoTemplate withSession(ClientSession session) {
        Assert.notNull((Object)session, (String)"ClientSession must not be null");
        return new SessionBoundMongoTemplate(session, this);
    }

    public void setSessionSynchronization(SessionSynchronization sessionSynchronization) {
        this.sessionSynchronization = sessionSynchronization;
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass) {
        return this.createCollection(entityClass, this.operations.forType(entityClass).getCollectionOptions());
    }

    @Override
    public <T> MongoCollection<Document> createCollection(Class<T> entityClass, @Nullable CollectionOptions collectionOptions) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doCreateCollection(this.getCollectionName(entityClass), this.operations.convertToCreateCollectionOptions(collectionOptions, entityClass));
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.doCreateCollection(collectionName, new Document());
    }

    @Override
    public MongoCollection<Document> createCollection(String collectionName, @Nullable CollectionOptions collectionOptions) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.doCreateCollection(collectionName, this.operations.convertToCreateCollectionOptions(collectionOptions, Object.class));
    }

    @Override
    public MongoCollection<Document> createView(String name, Class<?> source, AggregationPipeline pipeline, @Nullable ViewOptions options) {
        return this.createView(name, this.getCollectionName(source), this.queryOperations.createAggregation(Aggregation.newAggregation(source, pipeline.getOperations()), source), options);
    }

    @Override
    public MongoCollection<Document> createView(String name, String source, AggregationPipeline pipeline, @Nullable ViewOptions options) {
        return this.createView(name, source, this.queryOperations.createAggregation(Aggregation.newAggregation(pipeline.getOperations()), (Class)null), options);
    }

    private MongoCollection<Document> createView(String name, String source, QueryOperations.AggregationDefinition aggregation, @Nullable ViewOptions options) {
        return this.doCreateView(name, source, aggregation.getAggregationPipeline(), options);
    }

    protected MongoCollection<Document> doCreateView(String name, String source, List<Document> pipeline, @Nullable ViewOptions options) {
        CreateViewOptions viewOptions = new CreateViewOptions();
        if (options != null) {
            options.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((CreateViewOptions)viewOptions).collation(arg_0));
        }
        return this.execute(db -> {
            db.createView(name, source, pipeline, viewOptions);
            return db.getCollection(name);
        });
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.execute(db -> db.getCollection(collectionName, Document.class));
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.getCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.execute(db -> {
            for (String name : db.listCollectionNames()) {
                if (!name.equals(collectionName)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.getCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        this.execute(collectionName, (MongoCollection<Document> collection) -> {
            collection.drop();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Dropped collection [%s]", collection.getNamespace() != null ? collection.getNamespace().getCollectionName() : collectionName));
            }
            return null;
        });
    }

    @Override
    public IndexOperations indexOps(String collectionName) {
        return this.indexOps(collectionName, null);
    }

    @Override
    public IndexOperations indexOps(String collectionName, @Nullable Class<?> type) {
        return new DefaultIndexOperations(this, collectionName, type);
    }

    @Override
    public IndexOperations indexOps(Class<?> entityClass) {
        return this.indexOps(this.getCollectionName(entityClass), entityClass);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode mode, String collectionName) {
        return this.bulkOps(mode, null, collectionName);
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode bulkMode, Class<?> entityClass) {
        return this.bulkOps(bulkMode, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public BulkOperations bulkOps(BulkOperations.BulkMode mode, @Nullable Class<?> entityType, String collectionName) {
        Assert.notNull((Object)((Object)mode), (String)"BulkMode must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        DefaultBulkOperations operations = new DefaultBulkOperations(this, collectionName, new DefaultBulkOperations.BulkOperationContext(mode, Optional.ofNullable(this.getPersistentEntity(entityType)), this.queryMapper, this.updateMapper, this.eventPublisher, this.entityCallbacks));
        operations.setDefaultWriteConcern(this.writeConcern);
        return operations;
    }

    @Override
    public ScriptOperations scriptOps() {
        return new DefaultScriptOperations(this);
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        if (ObjectUtils.isEmpty((Object)query.getSortObject())) {
            return this.doFindOne(collectionName, this.createDelegate(query), query.getQueryObject(), query.getFieldsObject(), new QueryCursorPreparer(query, entityClass), entityClass);
        }
        query.limit(1);
        List<T> results = this.find(query, entityClass, collectionName);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    @Override
    public boolean exists(Query query, Class<?> entityClass) {
        return this.exists(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public boolean exists(Query query, String collectionName) {
        return this.exists(query, null, collectionName);
    }

    @Override
    public boolean exists(Query query, @Nullable Class<?> entityClass, String collectionName) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to exist can't be null");
        }
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
        Document mappedQuery = queryContext.getMappedQuery(entityClass, this::getPersistentEntity);
        return this.execute(collectionName, new ExistsCallback(this.createDelegate(query), mappedQuery, queryContext.getCollation(entityClass).orElse(null)));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doFind(collectionName, this.createDelegate(query), query.getQueryObject(), query.getFieldsObject(), entityClass, new QueryCursorPreparer(query, entityClass));
    }

    @Override
    public <T> Window<T> scroll(Query query, Class<T> entityType) {
        Assert.notNull(entityType, (String)"Entity type must not be null");
        return this.scroll(query, entityType, this.getCollectionName(entityType));
    }

    @Override
    public <T> Window<T> scroll(Query query, Class<T> entityType, String collectionName) {
        return this.doScroll(query, entityType, entityType, collectionName);
    }

    <T> Window<T> doScroll(Query query, Class<?> sourceClass, Class<T> targetClass, String collectionName) {
        int limit;
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(sourceClass, (String)"Entity type must not be null");
        Assert.notNull(targetClass, (String)"Target type must not be null");
        EntityProjection<T, ?> projection = this.operations.introspectProjection(targetClass, sourceClass);
        ProjectingReadCallback callback = new ProjectingReadCallback(this.mongoConverter, projection, collectionName);
        int n = limit = query.isLimited() ? query.getLimit() + 1 : Integer.MAX_VALUE;
        if (query.hasKeyset()) {
            ScrollUtils.KeysetScrollQuery keysetPaginationQuery = ScrollUtils.createKeysetPaginationQuery(query, this.operations.getIdPropertyName(sourceClass));
            List<T> result = this.doFind(collectionName, this.createDelegate(query), keysetPaginationQuery.query(), keysetPaginationQuery.fields(), sourceClass, new QueryCursorPreparer(query, keysetPaginationQuery.sort(), limit, 0L, sourceClass), callback);
            return ScrollUtils.createWindow(query, result, sourceClass, this.operations);
        }
        List<T> result = this.doFind(collectionName, this.createDelegate(query), query.getQueryObject(), query.getFieldsObject(), sourceClass, new QueryCursorPreparer(query, query.getSortObject(), limit, query.getSkip(), sourceClass), callback);
        return ScrollUtils.createWindow(result, query.getLimit(), OffsetScrollPosition.positionFunction((long)query.getSkip()));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass) {
        return this.findById(id, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        String idKey = this.operations.getIdPropertyName(entityClass);
        return this.doFindOne(collectionName, CollectionPreparer.identity(), new Document(idKey, id), new Document(), entityClass);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(query, field, this.getCollectionName(entityClass), entityClass, resultClass);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, String collectionName, Class<?> entityClass, Class<T> resultClass) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull(resultClass, (String)"ResultClass must not be null");
        MongoPersistentEntity<?> entity = entityClass != Object.class ? this.getPersistentEntity(entityClass) : null;
        QueryOperations.DistinctQueryContext distinctQueryContext = this.queryOperations.distinctQueryContext(query, field);
        Document mappedQuery = distinctQueryContext.getMappedQuery(entity);
        String mappedFieldName = distinctQueryContext.getMappedFieldName(entity);
        Class mongoDriverCompatibleType = distinctQueryContext.getDriverCompatibleClass(resultClass);
        MongoIterable result = (MongoIterable)this.execute(collectionName, (MongoCollection<Document> collection) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Executing findDistinct using query %s for field: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), field, collectionName));
            }
            collection = this.createDelegate(query).prepare(collection);
            DistinctIterable iterable = collection.distinct(mappedFieldName, (Bson)mappedQuery, mongoDriverCompatibleType);
            distinctQueryContext.applyCollation(entityClass, arg_0 -> ((DistinctIterable)iterable).collation(arg_0));
            return iterable;
        });
        if (resultClass == Object.class || mongoDriverCompatibleType != resultClass) {
            MongoConverter converter = this.getConverter();
            DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory);
            result = result.map(source -> converter.mapValueToTargetType(source, distinctQueryContext.getMostSpecificConversionTargetType(resultClass, entityClass), dbRefResolver));
        }
        try {
            return (List)result.into(new ArrayList());
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return this.geoNear(near, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> GeoResults<T> geoNear(NearQuery near, Class<T> domainType, String collectionName) {
        return this.geoNear(near, domainType, collectionName, domainType);
    }

    public <T> GeoResults<T> geoNear(NearQuery near, Class<?> domainType, String collectionName, Class<T> returnType) {
        if (near == null) {
            throw new InvalidDataAccessApiUsageException("NearQuery must not be null");
        }
        if (domainType == null) {
            throw new InvalidDataAccessApiUsageException("Entity class must not be null");
        }
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(returnType, (String)"ReturnType must not be null");
        String collection = StringUtils.hasText((String)collectionName) ? collectionName : this.getCollectionName(domainType);
        String distanceField = this.operations.nearQueryDistanceFieldName(domainType);
        AggregationOptions.Builder optionsBuilder = AggregationOptions.builder().collation(near.getCollation());
        if (near.hasReadPreference()) {
            optionsBuilder.readPreference(near.getReadPreference());
        }
        if (near.hasReadConcern()) {
            optionsBuilder.readConcern(near.getReadConcern());
        }
        Aggregation $geoNear = TypedAggregation.newAggregation(domainType, Aggregation.geoNear(near, distanceField)).withOptions(optionsBuilder.build());
        AggregationResults<Document> results = this.aggregate($geoNear, collection, Document.class);
        EntityProjection<T, ?> projection = this.operations.introspectProjection(returnType, domainType);
        GeoNearResultDocumentCallback callback = new GeoNearResultDocumentCallback(distanceField, new ProjectingReadCallback(this.mongoConverter, projection, collection), near.getMetric());
        ArrayList<GeoResult> result = new ArrayList<GeoResult>(results.getMappedResults().size());
        BigDecimal aggregate = BigDecimal.ZERO;
        for (Document element : results) {
            GeoResult geoResult = (GeoResult)callback.doWith(element);
            aggregate = aggregate.add(BigDecimal.valueOf(geoResult.getDistance().getValue()));
            result.add(geoResult);
        }
        Distance avgDistance = new Distance(result.size() == 0 ? 0.0 : aggregate.divide(new BigDecimal(result.size()), RoundingMode.HALF_UP).doubleValue(), near.getMetric());
        return new GeoResults(result, avgDistance);
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, Class<T> entityClass) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, Class<T> entityClass, String collectionName) {
        return this.findAndModify(query, update, new FindAndModifyOptions(), entityClass, collectionName);
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, FindAndModifyOptions options, Class<T> entityClass) {
        return this.findAndModify(query, update, options, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndModify(Query query, UpdateDefinition update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        FindAndModifyOptions optionsToUse = FindAndModifyOptions.of(options);
        Optionals.ifAllPresent(query.getCollation(), optionsToUse.getCollation(), (l, r) -> {
            throw new IllegalArgumentException("Both Query and FindAndModifyOptions define a collation; Please provide the collation only via one of the two");
        });
        if (!options.getCollation().isPresent()) {
            this.operations.forType(entityClass).getCollation(query).ifPresent(optionsToUse::collation);
        }
        return this.doFindAndModify(this.createDelegate(query), collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), entityClass, update, optionsToUse);
    }

    @Override
    public <S, T> T findAndReplace(Query query, S replacement, FindAndReplaceOptions options, Class<S> entityType, String collectionName, Class<T> resultType) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(replacement, (String)"Replacement must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null Use FindAndReplaceOptions#empty() instead");
        Assert.notNull(entityType, (String)"EntityType must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull(resultType, (String)"ResultType must not be null Use Object.class instead");
        Assert.isTrue((query.getLimit() <= 1 ? 1 : 0) != 0, (String)"Query must not define a limit other than 1 ore none");
        Assert.isTrue((query.getSkip() <= 0L ? 1 : 0) != 0, (String)"Query must not define skip");
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(query);
        EntityProjection<T, S> projection = this.operations.introspectProjection(resultType, entityType);
        CollectionPreparerSupport.CollectionPreparerDelegate collectionPreparer = this.createDelegate(query);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        Document mappedFields = queryContext.getMappedFields(entity, projection);
        Document mappedSort = queryContext.getMappedSort(entity);
        replacement = this.maybeCallBeforeConvert(replacement, collectionName);
        Document mappedReplacement = this.operations.forEntity(replacement).toMappedDocument(this.mongoConverter).getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent<S>(replacement, mappedReplacement, collectionName));
        this.maybeCallBeforeSave(replacement, mappedReplacement, collectionName);
        T saved = this.doFindAndReplace((CollectionPreparer)collectionPreparer, collectionName, mappedQuery, mappedFields, mappedSort, (com.mongodb.client.model.Collation)queryContext.getCollation(entityType).orElse(null), entityType, mappedReplacement, options, projection);
        if (saved != null) {
            this.maybeEmitEvent(new AfterSaveEvent<T>(saved, mappedReplacement, collectionName));
            return this.maybeCallAfterSave(saved, mappedReplacement, collectionName);
        }
        return saved;
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    @Nullable
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.doFindAndRemove(this.createDelegate(query), collectionName, query.getQueryObject(), query.getFieldsObject(), this.getMappedSortObject(query, entityClass), this.operations.forType(entityClass).getCollation(query).orElse(null), entityClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return this.count(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public long count(Query query, @Nullable Class<?> entityClass, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        QueryOperations.CountContext countContext = this.queryOperations.countQueryContext(query);
        CountOptions options = countContext.getCountOptions(entityClass);
        Document mappedQuery = countContext.getMappedQuery(entityClass, arg_0 -> this.mappingContext.getPersistentEntity(arg_0));
        CollectionPreparerSupport.CollectionPreparerDelegate readPreference = this.createDelegate(query);
        return this.doCount(readPreference, collectionName, mappedQuery, options);
    }

    protected long doCount(CollectionPreparer collectionPreparer, String collectionName, Document filter, CountOptions options) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Executing count: %s in collection: %s", SerializationUtils.serializeToJsonSafely(filter), collectionName));
        }
        return this.countExecution.countDocuments(collectionPreparer, collectionName, filter, options);
    }

    @Override
    public long estimatedCount(String collectionName) {
        return this.doEstimatedCount(CollectionPreparerSupport.CollectionPreparerDelegate.of(this), collectionName, new EstimatedDocumentCountOptions());
    }

    protected long doEstimatedCount(CollectionPreparer<MongoCollection<Document>> collectionPreparer, String collectionName, EstimatedDocumentCountOptions options) {
        return this.execute(collectionName, (MongoCollection<Document> collection) -> collectionPreparer.prepare(collection).estimatedDocumentCount(options));
    }

    @Override
    public long exactCount(Query query, @Nullable Class<?> entityClass, String collectionName) {
        QueryOperations.CountContext countContext = this.queryOperations.countQueryContext(query);
        CountOptions options = countContext.getCountOptions(entityClass);
        Document mappedQuery = countContext.getMappedQuery(entityClass, arg_0 -> this.mappingContext.getPersistentEntity(arg_0));
        return this.doExactCount(this.createDelegate(query), collectionName, mappedQuery, options);
    }

    protected long doExactCount(CollectionPreparer<MongoCollection<Document>> collectionPreparer, String collectionName, Document filter, CountOptions options) {
        return this.execute(collectionName, (MongoCollection<Document> collection) -> collectionPreparer.prepare(collection).countDocuments((Bson)CountQuery.of(filter).toQueryDocument(), options));
    }

    protected boolean countCanBeEstimated(Document filter, CountOptions options) {
        return filter.isEmpty() && this.isEmptyOptions(options) && !MongoDatabaseUtils.isTransactionActive(this.getMongoDatabaseFactory());
    }

    private boolean isEmptyOptions(CountOptions options) {
        return options.getLimit() <= 0 && options.getSkip() <= 0;
    }

    @Override
    public <T> T insert(T objectToSave) {
        Assert.notNull(objectToSave, (String)"ObjectToSave must not be null");
        this.ensureNotCollectionLike(objectToSave);
        return this.insert(objectToSave, this.getCollectionName(ClassUtils.getUserClass(objectToSave)));
    }

    @Override
    public <T> T insert(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, (String)"ObjectToSave must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        this.ensureNotCollectionLike(objectToSave);
        return (T)this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotCollectionLike(@Nullable Object source) {
        if (EntityOperations.isCollectionLike(source)) {
            throw new IllegalArgumentException("Cannot use a collection here");
        }
    }

    protected MongoCollection<Document> prepareCollection(MongoCollection<Document> collection) {
        if (this.readPreference != null && this.readPreference != collection.getReadPreference()) {
            return collection.withReadPreference(this.readPreference);
        }
        return collection;
    }

    @Nullable
    protected WriteConcern prepareWriteConcern(MongoAction mongoAction) {
        WriteConcern wc = this.writeConcernResolver.resolve(mongoAction);
        return this.potentiallyForceAcknowledgedWrite(wc);
    }

    @Nullable
    private WriteConcern potentiallyForceAcknowledgedWrite(@Nullable WriteConcern wc) {
        Number concern;
        Object object;
        if (ObjectUtils.nullSafeEquals((Object)((Object)WriteResultChecking.EXCEPTION), (Object)((Object)this.writeResultChecking)) && (wc == null || wc.getWObject() == null || (object = wc.getWObject()) instanceof Number && (concern = (Number)object).intValue() < 1)) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return wc;
    }

    protected <T> T doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BeforeConvertEvent<T> event = new BeforeConvertEvent<T>(objectToSave, collectionName);
        Object toConvert = this.maybeEmitEvent(event).getSource();
        toConvert = this.maybeCallBeforeConvert(toConvert, collectionName);
        EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(toConvert, this.mongoConverter.getConversionService());
        entity.assertUpdateableIdIfNotSet();
        Object initialized = entity.initializeVersionProperty();
        Document dbDoc = entity.toMappedDocument(writer).getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent(initialized, dbDoc, collectionName));
        initialized = this.maybeCallBeforeSave(initialized, dbDoc, collectionName);
        Object id = this.insertDocument(collectionName, dbDoc, initialized.getClass());
        Object saved = this.populateIdIfNecessary(initialized, id);
        this.maybeEmitEvent(new AfterSaveEvent(saved, dbDoc, collectionName));
        return this.maybeCallAfterSave(saved, dbDoc, collectionName);
    }

    @Override
    public <T> Collection<T> insert(Collection<? extends T> batchToSave, Class<?> entityClass) {
        Assert.notNull(batchToSave, (String)"BatchToSave must not be null");
        return this.doInsertBatch(this.getCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Collection<T> insert(Collection<? extends T> batchToSave, String collectionName) {
        Assert.notNull(batchToSave, (String)"BatchToSave must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        return this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public <T> Collection<T> insertAll(Collection<? extends T> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"ObjectsToSave must not be null");
        return this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> Collection<T> doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, List> elementsByCollection = new HashMap<String, List>();
        ArrayList<Object> savedObjects = new ArrayList<Object>(listToSave.size());
        for (T t : listToSave) {
            if (t == null) continue;
            String collection = this.getCollectionName(ClassUtils.getUserClass(t));
            List collectionElements = elementsByCollection.computeIfAbsent(collection, k -> new ArrayList());
            collectionElements.add(t);
        }
        for (Map.Entry entry : elementsByCollection.entrySet()) {
            savedObjects.addAll(this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter));
        }
        return savedObjects;
    }

    protected <T> Collection<T> doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer, (String)"MongoWriter must not be null");
        ArrayList<Document> documentList = new ArrayList<Document>(batchToSave.size());
        ArrayList initializedBatchToSave = new ArrayList(batchToSave.size());
        for (T uninitialized : batchToSave) {
            BeforeConvertEvent<T> event = new BeforeConvertEvent<T>(uninitialized, collectionName);
            Object toConvert = this.maybeEmitEvent(event).getSource();
            toConvert = this.maybeCallBeforeConvert(toConvert, collectionName);
            EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(toConvert, this.mongoConverter.getConversionService());
            entity.assertUpdateableIdIfNotSet();
            Object initialized = entity.initializeVersionProperty();
            Document document = entity.toMappedDocument(writer).getDocument();
            this.maybeEmitEvent(new BeforeSaveEvent(initialized, document, collectionName));
            initialized = this.maybeCallBeforeSave(initialized, document, collectionName);
            documentList.add(document);
            initializedBatchToSave.add(initialized);
        }
        List<Object> ids = this.insertDocumentList(collectionName, documentList);
        ArrayList savedObjects = new ArrayList(documentList.size());
        int i = 0;
        for (Object obj : initializedBatchToSave) {
            if (i < ids.size()) {
                Object saved = this.populateIdIfNecessary(obj, ids.get(i));
                Document doc = (Document)documentList.get(i);
                this.maybeEmitEvent(new AfterSaveEvent(saved, doc, collectionName));
                savedObjects.add(this.maybeCallAfterSave(saved, doc, collectionName));
            } else {
                savedObjects.add(obj);
            }
            ++i;
        }
        return savedObjects;
    }

    @Override
    public <T> T save(T objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null");
        return this.save(objectToSave, this.getCollectionName(ClassUtils.getUserClass(objectToSave)));
    }

    @Override
    public <T> T save(T objectToSave, String collectionName) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        this.ensureNotCollectionLike(objectToSave);
        EntityOperations.AdaptibleEntity<T> source = this.operations.forEntity(objectToSave, this.mongoConverter.getConversionService());
        return (T)(source.isVersionedEntity() ? this.doSaveVersioned(source, collectionName) : this.doSave(collectionName, objectToSave, this.mongoConverter));
    }

    private <T> T doSaveVersioned(EntityOperations.AdaptibleEntity<T> source, String collectionName) {
        if (source.isNew()) {
            return (T)this.doInsert(collectionName, source.getBean(), this.mongoConverter);
        }
        Query query = source.getQueryForVersion();
        T toSave = source.incrementVersion();
        toSave = this.maybeEmitEvent(new BeforeConvertEvent<T>(toSave, collectionName)).getSource();
        toSave = this.maybeCallBeforeConvert(toSave, collectionName);
        if (source.getBean() != toSave) {
            source = this.operations.forEntity(toSave, this.mongoConverter.getConversionService());
        }
        source.assertUpdateableIdIfNotSet();
        MappedDocument mapped = source.toMappedDocument(this.mongoConverter);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(toSave, mapped.getDocument(), collectionName));
        toSave = this.maybeCallBeforeSave(toSave, mapped.getDocument(), collectionName);
        UpdateDefinition update = mapped.updateWithoutId();
        UpdateResult result = this.doUpdate(collectionName, query, update, toSave.getClass(), false, false);
        if (result.getModifiedCount() == 0L) {
            throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to collection %s; Has it been modified meanwhile", source.getId(), source.getVersion(), collectionName));
        }
        this.maybeEmitEvent(new AfterSaveEvent<T>(toSave, mapped.getDocument(), collectionName));
        return this.maybeCallAfterSave(toSave, mapped.getDocument(), collectionName);
    }

    protected <T> T doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        objectToSave = this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave, collectionName)).getSource();
        objectToSave = this.maybeCallBeforeConvert(objectToSave, collectionName);
        EntityOperations.AdaptibleEntity<T> entity = this.operations.forEntity(objectToSave, this.mongoConverter.getConversionService());
        entity.assertUpdateableIdIfNotSet();
        MappedDocument mapped = entity.toMappedDocument(writer);
        Document dbDoc = mapped.getDocument();
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, dbDoc, collectionName));
        objectToSave = this.maybeCallBeforeSave(objectToSave, dbDoc, collectionName);
        Object id = this.saveDocument(collectionName, dbDoc, objectToSave.getClass());
        T saved = this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(saved, dbDoc, collectionName));
        return this.maybeCallAfterSave(saved, dbDoc, collectionName);
    }

    protected Object insertDocument(String collectionName, Document document, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Inserting Document containing fields: %s in collection: %s", document.keySet(), collectionName));
        }
        MappedDocument mappedDocument = this.queryOperations.createInsertContext(MappedDocument.of(document)).prepareId(entityClass);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT, collectionName, entityClass, mappedDocument.getDocument(), null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            if (writeConcernToUse == null) {
                collection.insertOne((Object)mappedDocument.getDocument());
            } else {
                collection.withWriteConcern(writeConcernToUse).insertOne((Object)mappedDocument.getDocument());
            }
            return this.operations.forEntity(mappedDocument.getDocument()).getId();
        });
    }

    protected List<Object> insertDocumentList(String collectionName, List<Document> documents) {
        if (documents.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Inserting list of Documents containing %s items", documents.size()));
        }
        this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.INSERT_LIST, collectionName, null, null, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            if (writeConcernToUse == null) {
                collection.insertMany(documents);
            } else {
                collection.withWriteConcern(writeConcernToUse).insertMany(documents);
            }
            return null;
        });
        return MappedDocument.toIds(documents);
    }

    protected Object saveDocument(String collectionName, Document dbDoc, Class<?> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Saving Document containing fields: %s", dbDoc.keySet()));
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            MongoCollection collectionToUse;
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.SAVE, collectionName, entityClass, dbDoc, null);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            MappedDocument mapped = MappedDocument.of(dbDoc);
            MongoCollection mongoCollection = collectionToUse = writeConcernToUse == null ? collection : collection.withWriteConcern(writeConcernToUse);
            if (!mapped.hasId()) {
                mapped = this.queryOperations.createInsertContext(mapped).prepareId((MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass));
                collectionToUse.insertOne((Object)mapped.getDocument());
            } else {
                MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
                QueryOperations.UpdateContext updateContext = this.queryOperations.replaceSingleContext(mapped, true);
                Document replacement = updateContext.getMappedUpdate(entity);
                Document filter = updateContext.getMappedQuery(entity);
                if (updateContext.requiresShardKey(filter, entity)) {
                    filter = entity.getShardKey().isImmutable() ? updateContext.applyShardKey(entity, filter, null) : updateContext.applyShardKey(entity, filter, (Document)collection.find((Bson)filter, Document.class).projection((Bson)updateContext.getMappedShardKey(entity)).first());
                }
                collectionToUse.replaceOne((Bson)filter, (Object)replacement, new com.mongodb.client.model.ReplaceOptions().upsert(true));
            }
            return mapped.getId();
        });
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, true, false);
    }

    @Override
    public UpdateResult upsert(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doUpdate(collectionName, query, update, entityClass, true, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public UpdateResult updateFirst(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doUpdate(collectionName, query, update, entityClass, false, false);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, Class<?> entityClass) {
        return this.doUpdate(this.getCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    @Override
    public UpdateResult updateMulti(Query query, UpdateDefinition update, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doUpdate(collectionName, query, update, entityClass, false, true);
    }

    protected UpdateResult doUpdate(String collectionName, Query query, UpdateDefinition update, @Nullable Class<?> entityClass, boolean upsert, boolean multi) {
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        if (query.isSorted() && LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)String.format("%s does not support sort ('%s'); Please use findAndModify() instead", upsert ? "Upsert" : "UpdateFirst", SerializationUtils.serializeToJsonSafely(query.getSortObject())));
        }
        MongoPersistentEntity<?> entity = entityClass == null ? null : this.getPersistentEntity(entityClass);
        QueryOperations.UpdateContext updateContext = multi ? this.queryOperations.updateContext(update, query, upsert) : this.queryOperations.updateSingleContext(update, query, upsert);
        updateContext.increaseVersionForUpdateIfNecessary(entity);
        Document queryObj = updateContext.getMappedQuery(entity);
        UpdateOptions opts = updateContext.getUpdateOptions(entityClass);
        if (updateContext.isAggregationUpdate()) {
            List<Document> pipeline = updateContext.getUpdatePipeline(entityClass);
            MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, update.getUpdateObject(), queryObj);
            WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
            return this.execute(collectionName, (MongoCollection<Document> collection) -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("Calling update using query: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(pipeline), collectionName));
                }
                collection = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
                return multi ? collection.updateMany((Bson)queryObj, pipeline, opts) : collection.updateOne((Bson)queryObj, pipeline, opts);
            });
        }
        Document updateObj = updateContext.getMappedUpdate(entity);
        MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.UPDATE, collectionName, entityClass, updateObj, queryObj);
        WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Calling update using query: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(queryObj), SerializationUtils.serializeToJsonSafely(updateObj), collectionName));
            }
            MongoCollection mongoCollection = collection = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
            if (!UpdateMapper.isUpdateObject(updateObj)) {
                Document filter = new Document((Map)queryObj);
                if (updateContext.requiresShardKey(filter, entity)) {
                    filter = entity.getShardKey().isImmutable() ? updateContext.applyShardKey(entity, filter, null) : updateContext.applyShardKey(entity, filter, (Document)collection.find((Bson)filter, Document.class).projection((Bson)updateContext.getMappedShardKey(entity)).first());
                }
                com.mongodb.client.model.ReplaceOptions replaceOptions = updateContext.getReplaceOptions(entityClass);
                return collection.replaceOne((Bson)filter, (Object)updateObj, replaceOptions);
            }
            return multi ? collection.updateMany((Bson)queryObj, (Bson)updateObj, opts) : collection.updateOne((Bson)queryObj, (Bson)updateObj, opts);
        });
    }

    @Override
    public DeleteResult remove(Object object) {
        Assert.notNull((Object)object, (String)"Object must not be null");
        return this.remove(object, this.getCollectionName(object.getClass()));
    }

    @Override
    public DeleteResult remove(Object object, String collectionName) {
        Assert.notNull((Object)object, (String)"Object must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        Query query = this.operations.forEntity(object).getRemoveByQuery();
        return this.doRemove(collectionName, query, object.getClass(), false);
    }

    @Override
    public DeleteResult remove(Query query, String collectionName) {
        return this.doRemove(collectionName, query, null, true);
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass) {
        return this.remove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public DeleteResult remove(Query query, Class<?> entityClass, String collectionName) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null");
        return this.doRemove(collectionName, query, entityClass, true);
    }

    protected <T> DeleteResult doRemove(String collectionName, Query query, @Nullable Class<T> entityClass, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        QueryOperations.DeleteContext deleteContext = multi ? this.queryOperations.deleteQueryContext(query) : this.queryOperations.deleteSingleContext(query);
        Document queryObject = deleteContext.getMappedQuery(entity);
        DeleteOptions options = deleteContext.getDeleteOptions(entityClass);
        MongoAction mongoAction = new MongoAction(this.writeConcern, MongoActionOperation.REMOVE, collectionName, entityClass, null, queryObject);
        WriteConcern writeConcernToUse = this.prepareWriteConcern(mongoAction);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            this.maybeEmitEvent(new BeforeDeleteEvent(queryObject, entityClass, collectionName));
            Document removeQuery = queryObject;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Remove using query: %s in collection: %s.", SerializationUtils.serializeToJsonSafely(removeQuery), collectionName));
            }
            if (query.getLimit() > 0 || query.getSkip() > 0L) {
                MongoCursor cursor = new QueryCursorPreparer(query, entityClass).prepare((FindIterable<Document>)collection.find((Bson)removeQuery).projection((Bson)MappedDocument.getIdOnlyProjection())).iterator();
                LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
                while (cursor.hasNext()) {
                    ids.add(MappedDocument.of((Document)cursor.next()).getId());
                }
                removeQuery = MappedDocument.getIdIn(ids);
            }
            MongoCollection collectionToUse = writeConcernToUse != null ? collection.withWriteConcern(writeConcernToUse) : collection;
            DeleteResult result = multi ? collectionToUse.deleteMany((Bson)removeQuery, options) : collectionToUse.deleteOne((Bson)removeQuery, options);
            this.maybeEmitEvent(new AfterDeleteEvent(queryObject, entityClass, collectionName));
            return result;
        });
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(CollectionPreparer.identity(), new Document(), new Document(), this.operations.forType(entityClass).getCollation().map(Collation::toMongoCollation).orElse(null)), CursorPreparer.NO_OP_PREPARER, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return this.mapReduce(new Query(), inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return this.mapReduce(query, inputCollectionName, mapFunction, reduceFunction, new MapReduceOptions(), entityClass);
    }

    @Override
    public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return new MapReduceResults<T>(this.mapReduce(query, entityClass, inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass), new Document());
    }

    @Deprecated
    public <T> List<T> mapReduce(Query query, Class<?> domainType, String inputCollectionName, String mapFunction, String reduceFunction, @Nullable MapReduceOptions mapReduceOptions, Class<T> resultType) {
        Document mappedSort;
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Assert.notNull((Object)inputCollectionName, (String)"Input collection name must not be null");
        Assert.notNull(resultType, (String)"Result type must not be null");
        Assert.notNull((Object)mapFunction, (String)"Map function must not be null");
        Assert.notNull((Object)reduceFunction, (String)"Reduce function must not be null");
        String mapFunc = this.replaceWithResourceIfNecessary(mapFunction);
        String reduceFunc = this.replaceWithResourceIfNecessary(reduceFunction);
        CollectionPreparerSupport.CollectionPreparerDelegate readPreference = this.createDelegate(query);
        MongoCollection<Document> inputCollection = readPreference.prepare(this.getAndPrepareCollection(this.doGetDatabase(), inputCollectionName));
        MapReduceIterable mapReduce = inputCollection.mapReduce(mapFunc, reduceFunc, Document.class);
        if (query.getLimit() > 0 && mapReduceOptions != null && mapReduceOptions.getLimit() == null) {
            mapReduce = mapReduce.limit(query.getLimit());
        }
        if (query.getMeta().hasMaxTime()) {
            mapReduce = mapReduce.maxTime(query.getMeta().getMaxTimeMsec().longValue(), TimeUnit.MILLISECONDS);
        }
        if ((mappedSort = this.getMappedSortObject(query, domainType)) != null && !mappedSort.isEmpty()) {
            mapReduce = mapReduce.sort((Bson)mappedSort);
        }
        mapReduce = mapReduce.filter((Bson)this.queryMapper.getMappedObject((Bson)query.getQueryObject(), (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainType)));
        Optional<Collation> collation = query.getCollation();
        if (mapReduceOptions != null) {
            Optionals.ifAllPresent(collation, mapReduceOptions.getCollation(), (l, r) -> {
                throw new IllegalArgumentException("Both Query and MapReduceOptions define a collation; Please provide the collation only via one of the two.");
            });
            if (mapReduceOptions.getCollation().isPresent()) {
                collation = mapReduceOptions.getCollation();
            }
            if (!CollectionUtils.isEmpty(mapReduceOptions.getScopeVariables())) {
                mapReduce = mapReduce.scope((Bson)new Document(mapReduceOptions.getScopeVariables()));
            }
            if (mapReduceOptions.getLimit() != null && mapReduceOptions.getLimit() > 0) {
                mapReduce = mapReduce.limit(mapReduceOptions.getLimit().intValue());
            }
            if (mapReduceOptions.getFinalizeFunction().filter(StringUtils::hasText).isPresent()) {
                mapReduce = mapReduce.finalizeFunction(mapReduceOptions.getFinalizeFunction().get());
            }
            if (mapReduceOptions.getJavaScriptMode() != null) {
                mapReduce = mapReduce.jsMode(mapReduceOptions.getJavaScriptMode().booleanValue());
            }
            if (mapReduceOptions.getOutputSharded().isPresent()) {
                mapReduce = mapReduce.sharded(mapReduceOptions.getOutputSharded().get().booleanValue());
            }
            if (StringUtils.hasText((String)mapReduceOptions.getOutputCollection()) && !mapReduceOptions.usesInlineOutput()) {
                mapReduce = mapReduce.collectionName(mapReduceOptions.getOutputCollection()).action(mapReduceOptions.getMapReduceAction());
                if (mapReduceOptions.getOutputDatabase().isPresent()) {
                    mapReduce = mapReduce.databaseName(mapReduceOptions.getOutputDatabase().get());
                }
            }
        }
        if (!collation.isPresent()) {
            collation = this.operations.forType(domainType).getCollation();
        }
        mapReduce = collation.map(Collation::toMongoCollation).map(arg_0 -> ((MapReduceIterable)mapReduce).collation(arg_0)).orElse(mapReduce);
        ArrayList mappedResults = new ArrayList();
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, resultType, inputCollectionName);
        for (Document document : mapReduce) {
            mappedResults.add(callback.doWith(document));
        }
        return mappedResults;
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null");
        return this.aggregate(aggregation, this.getCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        return this.aggregate(aggregation, inputCollectionName, outputType, null);
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null");
        return this.aggregate(aggregation, this.getCollectionName(inputType), outputType, this.queryOperations.createAggregation(aggregation, inputType).getAggregationOperationContext());
    }

    @Override
    public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregate(aggregation, collectionName, outputType, null);
    }

    @Override
    public <O> Stream<O> aggregateStream(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        return this.aggregateStream(aggregation, inputCollectionName, outputType, null);
    }

    @Override
    public <O> Stream<O> aggregateStream(TypedAggregation<?> aggregation, Class<O> outputType) {
        Assert.notNull(aggregation, (String)"Aggregation pipeline must not be null");
        return this.aggregateStream(aggregation, this.getCollectionName(aggregation.getInputType()), outputType);
    }

    @Override
    public <O> Stream<O> aggregateStream(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null");
        return this.aggregateStream(aggregation, this.getCollectionName(inputType), outputType, this.queryOperations.createAggregation(aggregation, inputType).getAggregationOperationContext());
    }

    @Override
    public <O> Stream<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return this.aggregateStream(aggregation, collectionName, outputType, null);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, String collectionName) {
        return this.findAllAndRemove(query, Object.class, collectionName);
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return this.findAllAndRemove(query, entityClass, this.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndDelete(collectionName, query, entityClass);
    }

    @Override
    public <T> UpdateResult replace(Query query, T replacement, ReplaceOptions options, String collectionName) {
        Assert.notNull(replacement, (String)"Replacement must not be null");
        return this.replace(query, ClassUtils.getUserClass(replacement), replacement, options, collectionName);
    }

    protected <S, T> UpdateResult replace(Query query, Class<S> entityType, T replacement, ReplaceOptions options, String collectionName) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(replacement, (String)"Replacement must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null Use ReplaceOptions#none() instead");
        Assert.notNull(entityType, (String)"EntityType must not be null");
        Assert.notNull((Object)collectionName, (String)"CollectionName must not be null");
        Assert.isTrue((query.getLimit() <= 1 ? 1 : 0) != 0, (String)"Query must not define a limit other than 1 ore none");
        Assert.isTrue((query.getSkip() <= 0L ? 1 : 0) != 0, (String)"Query must not define skip");
        QueryOperations.UpdateContext updateContext = this.queryOperations.replaceSingleContext(query, this.operations.forEntity(replacement).toMappedDocument(this.mongoConverter), options.isUpsert());
        replacement = this.maybeCallBeforeConvert(replacement, collectionName);
        Document mappedReplacement = updateContext.getMappedUpdate((MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityType));
        this.maybeEmitEvent(new BeforeSaveEvent<T>(replacement, mappedReplacement, collectionName));
        replacement = this.maybeCallBeforeSave(replacement, mappedReplacement, collectionName);
        MongoAction action = new MongoAction(this.writeConcern, MongoActionOperation.REPLACE, collectionName, entityType, mappedReplacement, updateContext.getQueryObject());
        UpdateResult result = this.doReplace(options, entityType, collectionName, updateContext, this.createCollectionPreparer(query, action), mappedReplacement);
        if (result.wasAcknowledged()) {
            this.maybeEmitEvent(new AfterSaveEvent<T>(replacement, mappedReplacement, collectionName));
            this.maybeCallAfterSave(replacement, mappedReplacement, collectionName);
        }
        return result;
    }

    protected <T> List<T> doFindAndDelete(String collectionName, Query query, Class<T> entityClass) {
        List<T> result = this.find(query, entityClass, collectionName);
        if (!CollectionUtils.isEmpty(result)) {
            Query byIdInQuery = this.operations.getByIdInQuery(result);
            if (query.hasReadPreference()) {
                byIdInQuery.withReadPreference(query.getReadPreference());
            }
            this.remove(byIdInQuery, entityClass, collectionName);
        }
        return result;
    }

    protected <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null");
        Assert.notNull(outputType, (String)"Output type must not be null");
        return this.doAggregate(aggregation, collectionName, outputType, this.queryOperations.createAggregation(aggregation, context));
    }

    private <O> AggregationResults<O> doAggregate(Aggregation aggregation, String collectionName, Class<O> outputType, QueryOperations.AggregationDefinition context) {
        return this.doAggregate(aggregation, collectionName, outputType, context.getAggregationOperationContext());
    }

    protected <O> AggregationResults<O> doAggregate(Aggregation aggregation, String collectionName, Class<O> outputType, AggregationOperationContext context) {
        ReadDocumentCallback<Object> callback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        AggregationOptions options = aggregation.getOptions();
        AggregationUtil aggregationUtil = new AggregationUtil(this.queryMapper, this.mappingContext);
        if (options.isExplain()) {
            Document command = aggregationUtil.createCommand(collectionName, aggregation, context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Executing aggregation: %s", SerializationUtils.serializeToJsonSafely(command)));
            }
            Document commandResult = this.executeCommand(command);
            return new AggregationResults(((ArrayList)commandResult.get((Object)"results", new ArrayList(0))).stream().map(callback::doWith).collect(Collectors.toList()), commandResult);
        }
        List<Document> pipeline = aggregationUtil.createPipeline(aggregation, context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Executing aggregation: %s in collection %s", SerializationUtils.serializeToJsonSafely(pipeline), collectionName));
        }
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            ArrayList rawResult = new ArrayList();
            CollectionPreparerSupport.CollectionPreparerDelegate delegate = CollectionPreparerSupport.CollectionPreparerDelegate.of(options);
            Class domainType = aggregation instanceof TypedAggregation ? ((TypedAggregation)aggregation).getInputType() : null;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = options::getCollation;
            supplierArray[1] = () -> this.operations.forType(domainType).getCollation();
            Optional collation = Optionals.firstNonEmpty((Supplier[])supplierArray);
            AggregateIterable aggregateIterable = delegate.prepare((MongoCollection<Document>)collection).aggregate(pipeline, Document.class).collation((com.mongodb.client.model.Collation)collation.map(Collation::toMongoCollation).orElse(null)).allowDiskUse(Boolean.valueOf(options.isAllowDiskUse()));
            if (options.getCursorBatchSize() != null) {
                aggregateIterable = aggregateIterable.batchSize(options.getCursorBatchSize().intValue());
            }
            options.getComment().ifPresent(arg_0 -> ((AggregateIterable)aggregateIterable).comment(arg_0));
            HintFunction hintFunction = options.getHintObject().map(HintFunction::from).orElseGet(HintFunction::empty);
            if (hintFunction.isPresent()) {
                aggregateIterable = hintFunction.apply(this.mongoDbFactory, arg_0 -> ((AggregateIterable)aggregateIterable).hintString(arg_0), arg_0 -> ((AggregateIterable)aggregateIterable).hint(arg_0));
            }
            if (options.hasExecutionTimeLimit()) {
                aggregateIterable = aggregateIterable.maxTime(options.getMaxTime().toMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.isSkipResults()) {
                if (aggregation.getPipeline().isOutOrMerge()) {
                    aggregateIterable.toCollection();
                } else {
                    aggregateIterable.first();
                }
                return new AggregationResults(Collections.emptyList(), new Document());
            }
            MongoIterable iterable = aggregateIterable.map(val -> {
                rawResult.add(val);
                return callback.doWith((Document)val);
            });
            return new AggregationResults((List)iterable.into(new ArrayList()), new Document("results", rawResult).append("ok", (Object)1.0));
        });
    }

    protected <O> Stream<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType, @Nullable AggregationOperationContext context) {
        Assert.notNull((Object)aggregation, (String)"Aggregation pipeline must not be null");
        Assert.hasText((String)collectionName, (String)"Collection name must not be null or empty");
        Assert.notNull(outputType, (String)"Output type must not be null");
        Assert.isTrue((!aggregation.getOptions().isExplain() ? 1 : 0) != 0, (String)"Can't use explain option with streaming");
        QueryOperations.AggregationDefinition aggregationDefinition = this.queryOperations.createAggregation(aggregation, context);
        AggregationOptions options = aggregation.getOptions();
        List<Document> pipeline = aggregationDefinition.getAggregationPipeline();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Streaming aggregation: %s in collection %s", SerializationUtils.serializeToJsonSafely(pipeline), collectionName));
        }
        ReadDocumentCallback<Object> readCallback = new ReadDocumentCallback<Object>(this.mongoConverter, outputType, collectionName);
        return this.execute(collectionName, (MongoCollection<Document> collection) -> {
            Class clazz;
            CollectionPreparerSupport.CollectionPreparerDelegate delegate = CollectionPreparerSupport.CollectionPreparerDelegate.of(options);
            AggregateIterable cursor = delegate.prepare((MongoCollection<Document>)collection).aggregate(pipeline, Document.class).allowDiskUse(Boolean.valueOf(options.isAllowDiskUse()));
            if (options.getCursorBatchSize() != null) {
                cursor = cursor.batchSize(options.getCursorBatchSize().intValue());
            }
            options.getComment().ifPresent(arg_0 -> ((AggregateIterable)cursor).comment(arg_0));
            HintFunction hintFunction = options.getHintObject().map(HintFunction::from).orElseGet(HintFunction::empty);
            if (options.getHintObject().isPresent()) {
                cursor = hintFunction.apply(this.mongoDbFactory, arg_0 -> ((AggregateIterable)cursor).hintString(arg_0), arg_0 -> ((AggregateIterable)cursor).hint(arg_0));
            }
            if (options.hasExecutionTimeLimit()) {
                cursor = cursor.maxTime(options.getMaxTime().toMillis(), TimeUnit.MILLISECONDS);
            }
            if (aggregation instanceof TypedAggregation) {
                TypedAggregation typedAggregation = (TypedAggregation)aggregation;
                clazz = typedAggregation.getInputType();
            } else {
                clazz = null;
            }
            Class domainType = clazz;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = options::getCollation;
            supplierArray[1] = () -> this.operations.forType(domainType).getCollation();
            Optionals.firstNonEmpty((Supplier[])supplierArray).map(Collation::toMongoCollation).ifPresent(arg_0 -> ((AggregateIterable)cursor).collation(arg_0));
            return new CloseableIterableCursorAdapter((MongoIterable<Document>)cursor, this.exceptionTranslator, readCallback).stream();
        });
    }

    @Override
    public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        return new ExecutableFindOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        return new ExecutableRemoveOperationSupport(this).remove(domainType);
    }

    @Override
    public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        return new ExecutableAggregationOperationSupport(this).aggregateAndReturn(domainType);
    }

    public <T> ExecutableMapReduceOperation.ExecutableMapReduce<T> mapReduce(Class<T> domainType) {
        return new ExecutableMapReduceOperationSupport(this).mapReduce((Class)domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    protected String replaceWithResourceIfNecessary(String function) {
        if (this.resourceLoader != null && ResourceUtils.isUrl((String)function)) {
            Resource functionResource = this.resourceLoader.getResource(function);
            if (!functionResource.exists()) {
                throw new InvalidDataAccessApiUsageException(String.format("Resource %s not found", function));
            }
            try (Scanner scanner = null;){
                scanner = new Scanner(functionResource.getInputStream());
                String string = scanner.useDelimiter("\\A").next();
                return string;
            }
        }
        return function;
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(db -> {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String name : db.listCollectionNames()) {
                result.add(name);
            }
            return result;
        });
    }

    public MongoDatabase getDb() {
        return this.doGetDatabase();
    }

    protected MongoDatabase doGetDatabase() {
        return MongoDatabaseUtils.getDatabase(this.mongoDbFactory, this.sessionSynchronization);
    }

    protected MongoDatabase prepareDatabase(MongoDatabase database) {
        return database;
    }

    protected <E extends MongoMappingEvent<T>, T> E maybeEmitEvent(E event) {
        this.eventDelegate.publishEvent(event);
        return event;
    }

    protected <T> T maybeCallBeforeConvert(T object, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{collection});
        }
        return object;
    }

    protected <T> T maybeCallBeforeSave(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, object, new Object[]{document, collection});
        }
        return object;
    }

    protected <T> T maybeCallAfterSave(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterSaveCallback.class, object, new Object[]{document, collection});
        }
        return object;
    }

    protected <T> T maybeCallAfterConvert(T object, Document document, String collection) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        return object;
    }

    protected MongoCollection<Document> doCreateCollection(String collectionName, Document collectionOptions) {
        return this.doCreateCollection(collectionName, this.getCreateCollectionOptions(collectionOptions));
    }

    protected MongoCollection<Document> doCreateCollection(String collectionName, CreateCollectionOptions collectionOptions) {
        return this.execute(db -> {
            db.createCollection(collectionName, collectionOptions);
            MongoCollection coll = db.getCollection(collectionName, Document.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Created collection [%s]", coll.getNamespace() != null ? coll.getNamespace().getCollectionName() : collectionName));
            }
            return coll;
        });
    }

    private CreateCollectionOptions getCreateCollectionOptions(Document document) {
        CreateCollectionOptions options = new CreateCollectionOptions();
        if (document.containsKey((Object)"capped")) {
            options.capped(((Boolean)document.get((Object)"capped")).booleanValue());
        }
        if (document.containsKey((Object)"size")) {
            options.sizeInBytes(((Number)document.get((Object)"size")).longValue());
        }
        if (document.containsKey((Object)"max")) {
            options.maxDocuments(((Number)document.get((Object)"max")).longValue());
        }
        if (document.containsKey((Object)"collation")) {
            options.collation(IndexConverters.fromDocument((Document)document.get((Object)"collation", Document.class)));
        }
        if (document.containsKey((Object)"validator")) {
            ValidationOptions validation = new ValidationOptions();
            if (document.containsKey((Object)"validationLevel")) {
                validation.validationLevel(ValidationLevel.fromString((String)document.getString((Object)"validationLevel")));
            }
            if (document.containsKey((Object)"validationAction")) {
                validation.validationAction(ValidationAction.fromString((String)document.getString((Object)"validationAction")));
            }
            validation.validator((Bson)document.get((Object)"validator", Document.class));
            options.validationOptions(validation);
        }
        if (document.containsKey((Object)"timeseries")) {
            Document timeSeries = (Document)document.get((Object)"timeseries", Document.class);
            TimeSeriesOptions timeseries = new TimeSeriesOptions(timeSeries.getString((Object)"timeField"));
            if (timeSeries.containsKey((Object)"metaField")) {
                timeseries.metaField(timeSeries.getString((Object)"metaField"));
            }
            if (timeSeries.containsKey((Object)"granularity")) {
                timeseries.granularity(TimeSeriesGranularity.valueOf((String)timeSeries.getString((Object)"granularity").toUpperCase()));
            }
            options.timeSeriesOptions(timeseries);
        }
        return options;
    }

    @Nullable
    protected <T> T doFindOne(String collectionName, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Class<T> entityClass) {
        return this.doFindOne(collectionName, collectionPreparer, query, fields, CursorPreparer.NO_OP_PREPARER, entityClass);
    }

    @Nullable
    protected <T> T doFindOne(String collectionName, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, CursorPreparer preparer, Class<T> entityClass) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, EntityProjection.nonProjecting(entityClass));
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("findOne using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), mappedFields, entityClass, collectionName));
        }
        return (T)this.executeFindOneInternal(new FindOneCallback(collectionPreparer, mappedQuery, mappedFields, preparer), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Class<T> entityClass) {
        return this.doFind(collectionName, collectionPreparer, query, fields, entityClass, null, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <T> List<T> doFind(String collectionName, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Class<T> entityClass, CursorPreparer preparer) {
        return this.doFind(collectionName, collectionPreparer, query, fields, entityClass, preparer, new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName));
    }

    protected <S, T> List<T> doFind(String collectionName, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Class<S> entityClass, @Nullable CursorPreparer preparer, DocumentCallback<T> objectCallback) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, EntityProjection.nonProjecting(entityClass));
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("find using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, entityClass, collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(collectionPreparer, mappedQuery, mappedFields, null), preparer != null ? preparer : CursorPreparer.NO_OP_PREPARER, objectCallback, collectionName);
    }

    <S, T> List<T> doFind(CollectionPreparer<MongoCollection<Document>> collectionPreparer, String collectionName, Document query, Document fields, Class<S> sourceClass, Class<T> targetClass, CursorPreparer preparer) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(sourceClass);
        EntityProjection<T, S> projection = this.operations.introspectProjection(targetClass, sourceClass);
        QueryOperations.QueryContext queryContext = this.queryOperations.createQueryContext(new BasicQuery(query, fields));
        Document mappedFields = queryContext.getMappedFields(entity, projection);
        Document mappedQuery = queryContext.getMappedQuery(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("find using query: %s fields: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), mappedFields, sourceClass, collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(collectionPreparer, mappedQuery, mappedFields, null), preparer, new ProjectingReadCallback<S, T>(this.mongoConverter, projection, collectionName), collectionName);
    }

    protected Document convertToDocument(@Nullable CollectionOptions collectionOptions, Class<?> targetType) {
        if (collectionOptions == null) {
            return new Document();
        }
        Document doc = new Document();
        collectionOptions.getCapped().ifPresent(val -> doc.put("capped", val));
        collectionOptions.getSize().ifPresent(val -> doc.put("size", val));
        collectionOptions.getMaxDocuments().ifPresent(val -> doc.put("max", val));
        collectionOptions.getCollation().ifPresent(val -> doc.append("collation", (Object)val.toDocument()));
        collectionOptions.getValidationOptions().ifPresent(it -> {
            it.getValidationLevel().ifPresent(val -> doc.append("validationLevel", (Object)val.getValue()));
            it.getValidationAction().ifPresent(val -> doc.append("validationAction", (Object)val.getValue()));
            it.getValidator().ifPresent(val -> doc.append("validator", (Object)this.getMappedValidator((Validator)val, targetType)));
        });
        collectionOptions.getTimeSeriesOptions().map(this.operations.forType(targetType)::mapTimeSeriesOptions).ifPresent(it -> {
            Document timeseries = new Document("timeField", (Object)it.getTimeField());
            if (StringUtils.hasText((String)it.getMetaField())) {
                timeseries.append("metaField", (Object)it.getMetaField());
            }
            if (!Granularity.DEFAULT.equals(it.getGranularity())) {
                timeseries.append("granularity", (Object)it.getGranularity().name().toLowerCase());
            }
            doc.put("timeseries", (Object)timeseries);
        });
        collectionOptions.getChangeStreamOptions().map(it -> new Document("enabled", (Object)it.getPreAndPostImages())).ifPresent(it -> doc.put("changeStreamPreAndPostImages", it));
        return doc;
    }

    Document getMappedValidator(Validator validator, Class<?> domainType) {
        Document validationRules = validator.toDocument();
        if (validationRules.containsKey((Object)"$jsonSchema")) {
            return this.schemaMapper.mapSchema(validationRules, domainType);
        }
        return this.queryMapper.getMappedObject((Bson)validationRules, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainType));
    }

    protected <T> T doFindAndRemove(CollectionPreparer collectionPreparer, String collectionName, Document query, Document fields, Document sort, @Nullable Collation collation, Class<T> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("findAndRemove using query: %s fields: %s sort: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(query), fields, sort, entityClass, collectionName));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(collectionPreparer, this.queryMapper.getMappedObject((Bson)query, entity), fields, sort, collation), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    protected <T> T doFindAndModify(CollectionPreparer collectionPreparer, String collectionName, Document query, Document fields, Document sort, Class<T> entityClass, UpdateDefinition update, @Nullable FindAndModifyOptions options) {
        Document mappedUpdate;
        if (options == null) {
            options = new FindAndModifyOptions();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        QueryOperations.UpdateContext updateContext = this.queryOperations.updateSingleContext(update, query, false);
        updateContext.increaseVersionForUpdateIfNecessary(entity);
        Document mappedQuery = updateContext.getMappedQuery(entity);
        Document document = mappedUpdate = updateContext.isAggregationUpdate() ? updateContext.getUpdatePipeline(entityClass) : updateContext.getMappedUpdate(entity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("findAndModify using query: %s fields: %s sort: %s for class: %s and update: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), fields, sort, entityClass, SerializationUtils.serializeToJsonSafely(mappedUpdate), collectionName));
        }
        return (T)this.executeFindOneInternal(new FindAndModifyCallback(collectionPreparer, mappedQuery, fields, sort, mappedUpdate, update.getArrayFilters().stream().map(UpdateDefinition.ArrayFilter::asDocument).collect(Collectors.toList()), options), new ReadDocumentCallback<Object>(this.mongoConverter, entityClass, collectionName), collectionName);
    }

    @Nullable
    protected <T> T doFindAndReplace(CollectionPreparer collectionPreparer, String collectionName, Document mappedQuery, Document mappedFields, Document mappedSort, @Nullable com.mongodb.client.model.Collation collation, Class<?> entityType, Document replacement, FindAndReplaceOptions options, Class<T> resultType) {
        EntityProjection<T, ?> projection = this.operations.introspectProjection(resultType, entityType);
        return this.doFindAndReplace(collectionPreparer, collectionName, mappedQuery, mappedFields, mappedSort, collation, entityType, replacement, options, projection);
    }

    CollectionPreparerSupport.CollectionPreparerDelegate createDelegate(Query query) {
        return CollectionPreparerSupport.CollectionPreparerDelegate.of(query);
    }

    CollectionPreparer<MongoCollection<Document>> createCollectionPreparer(Query query, @Nullable MongoAction action) {
        CollectionPreparerSupport.CollectionPreparerDelegate collectionPreparer = this.createDelegate(query);
        if (action == null) {
            return collectionPreparer;
        }
        return collectionPreparer.andThen(collection -> {
            WriteConcern writeConcern = this.prepareWriteConcern(action);
            return writeConcern != null ? collection.withWriteConcern(writeConcern) : collection;
        });
    }

    @Nullable
    private <T> T doFindAndReplace(CollectionPreparer collectionPreparer, String collectionName, Document mappedQuery, Document mappedFields, Document mappedSort, @Nullable com.mongodb.client.model.Collation collation, Class<?> entityType, Document replacement, FindAndReplaceOptions options, EntityProjection<T, ?> projection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("findAndReplace using query: %s fields: %s sort: %s for class: %s and replacement: %s in collection: %s", SerializationUtils.serializeToJsonSafely(mappedQuery), SerializationUtils.serializeToJsonSafely(mappedFields), SerializationUtils.serializeToJsonSafely(mappedSort), entityType, SerializationUtils.serializeToJsonSafely(replacement), collectionName));
        }
        return this.executeFindOneInternal(new FindAndReplaceCallback(collectionPreparer, mappedQuery, mappedFields, mappedSort, replacement, collation, options), new ProjectingReadCallback(this.mongoConverter, projection, collectionName), collectionName);
    }

    private <S> UpdateResult doReplace(ReplaceOptions options, Class<S> entityType, String collectionName, QueryOperations.UpdateContext updateContext, CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document replacement) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityType);
        ReplaceCallback replaceCallback = new ReplaceCallback(collectionPreparer, updateContext.getMappedQuery(persistentEntity), replacement, updateContext.getReplaceOptions(entityType, it -> it.upsert(options.isUpsert())));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("replace one using query: %s for class: %s in collection: %s", SerializationUtils.serializeToJsonSafely(updateContext.getMappedQuery(persistentEntity)), entityType, collectionName));
        }
        return this.execute(collectionName, replaceCallback);
    }

    protected <T> T populateIdIfNecessary(T savedObject, Object id) {
        return this.operations.forEntity(savedObject, this.mongoConverter.getConversionService()).populateIdIfNecessary(id);
    }

    private MongoCollection<Document> getAndPrepareCollection(MongoDatabase db, String collectionName) {
        try {
            MongoCollection<Document> collection = db.getCollection(collectionName, Document.class);
            collection = this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    @Nullable
    private <T> T executeFindOneInternal(CollectionCallback<Document> collectionCallback, DocumentCallback<T> documentCallback, String collectionName) {
        try {
            Document document = collectionCallback.doInCollection(this.getAndPrepareCollection(this.doGetDatabase(), collectionName));
            return document != null ? (T)documentCallback.doWith(document) : null;
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    private <T> List<T> executeFindMultiInternal(CollectionCallback<FindIterable<Document>> collectionCallback, CursorPreparer preparer, DocumentCallback<T> documentCallback, String collectionName) {
        ArrayList<T> arrayList;
        block9: {
            MongoCursor cursor = preparer.initiateFind(this.getAndPrepareCollection(this.doGetDatabase(), collectionName), collectionCallback::doInCollection).iterator();
            try {
                ArrayList<T> result;
                int available = cursor.available();
                ArrayList<Object> arrayList2 = result = available > 0 ? new ArrayList<T>(available) : new ArrayList();
                while (cursor.hasNext()) {
                    Document object = (Document)cursor.next();
                    result.add(documentCallback.doWith(object));
                }
                arrayList = result;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
                }
            }
            cursor.close();
        }
        return arrayList;
    }

    private void executeQueryInternal(CollectionCallback<FindIterable<Document>> collectionCallback, CursorPreparer preparer, DocumentCallbackHandler callbackHandler, String collectionName) {
        try (MongoCursor cursor = preparer.initiateFind(this.getAndPrepareCollection(this.doGetDatabase(), collectionName), collectionCallback::doInCollection).iterator();){
            while (cursor.hasNext()) {
                callbackHandler.processDocument((Document)cursor.next());
            }
        }
        catch (RuntimeException e) {
            throw MongoTemplate.potentiallyConvertRuntimeException(e, this.exceptionTranslator);
        }
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Nullable
    private MongoPersistentEntity<?> getPersistentEntity(@Nullable Class<?> type) {
        return type != null ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type) : null;
    }

    private static MongoConverter getDefaultMongoConverter(MongoDatabaseFactory factory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MongoCustomConversions conversions = new MongoCustomConversions(Collections.emptyList());
        MongoMappingContext mappingContext = new MongoMappingContext();
        mappingContext.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        mappingContext.afterPropertiesSet();
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)mappingContext);
        converter.setCustomConversions(conversions);
        converter.setCodecRegistryProvider(factory);
        converter.afterPropertiesSet();
        return converter;
    }

    @Nullable
    private Document getMappedSortObject(@Nullable Query query, Class<?> type) {
        if (query == null) {
            return null;
        }
        return this.getMappedSortObject(query.getSortObject(), type);
    }

    @Nullable
    private Document getMappedSortObject(Document sortObject, Class<?> type) {
        if (ObjectUtils.isEmpty((Object)sortObject)) {
            return null;
        }
        return this.queryMapper.getMappedSort(sortObject, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type));
    }

    static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    public MongoDatabaseFactory getMongoDatabaseFactory() {
        return this.mongoDbFactory;
    }

    @FunctionalInterface
    static interface CountExecution {
        public long countDocuments(CollectionPreparer var1, String var2, Document var3, CountOptions var4);
    }

    class QueryCursorPreparer
    implements CursorPreparer {
        private final Query query;
        private final Document sortObject;
        private final int limit;
        private final long skip;
        @Nullable
        private final Class<?> type;

        QueryCursorPreparer(@Nullable Query query, Class<?> type) {
            this(query, query.getSortObject(), query.getLimit(), query.getSkip(), type);
        }

        QueryCursorPreparer(Query query, Document sortObject, int limit, @Nullable long skip, Class<?> type) {
            this.query = query;
            this.sortObject = sortObject;
            this.limit = limit;
            this.skip = skip;
            this.type = type;
        }

        @Override
        public FindIterable<Document> prepare(FindIterable<Document> iterable) {
            FindIterable cursorToUse = iterable;
            MongoTemplate.this.operations.forType(this.type).getCollation(this.query).map(Collation::toMongoCollation).ifPresent(arg_0 -> cursorToUse.collation(arg_0));
            Meta meta = this.query.getMeta();
            HintFunction hintFunction = HintFunction.from(this.query.getHint());
            if (this.skip <= 0L && this.limit <= 0 && ObjectUtils.isEmpty((Object)this.sortObject) && hintFunction.isEmpty() && !meta.hasValues() && this.query.getCollation().isEmpty()) {
                return cursorToUse;
            }
            try {
                if (this.skip > 0L) {
                    cursorToUse = cursorToUse.skip((int)this.skip);
                }
                if (this.limit > 0) {
                    cursorToUse = cursorToUse.limit(this.limit);
                }
                if (!ObjectUtils.isEmpty((Object)this.sortObject)) {
                    Document sort = this.type != null ? MongoTemplate.this.getMappedSortObject(this.sortObject, this.type) : this.sortObject;
                    cursorToUse = cursorToUse.sort((Bson)sort);
                }
                if (hintFunction.isPresent()) {
                    cursorToUse = hintFunction.apply(MongoTemplate.this.mongoDbFactory, arg_0 -> ((FindIterable)cursorToUse).hintString(arg_0), arg_0 -> ((FindIterable)cursorToUse).hint(arg_0));
                }
                if (meta.hasValues()) {
                    if (meta.hasComment()) {
                        cursorToUse = cursorToUse.comment(meta.getRequiredComment());
                    }
                    if (meta.hasMaxTime()) {
                        cursorToUse = cursorToUse.maxTime(meta.getRequiredMaxTimeMsec().longValue(), TimeUnit.MILLISECONDS);
                    }
                    if (meta.getCursorBatchSize() != null) {
                        cursorToUse = cursorToUse.batchSize(meta.getCursorBatchSize().intValue());
                    }
                    if (meta.getAllowDiskUse() != null) {
                        cursorToUse = cursorToUse.allowDiskUse(meta.getAllowDiskUse());
                    }
                    block7: for (Meta.CursorOption option : meta.getFlags()) {
                        switch (option) {
                            case NO_TIMEOUT: {
                                cursorToUse = cursorToUse.noCursorTimeout(true);
                                continue block7;
                            }
                            case PARTIAL: {
                                cursorToUse = cursorToUse.partial(true);
                                continue block7;
                            }
                            case SECONDARY_READS: {
                                continue block7;
                            }
                        }
                        throw new IllegalArgumentException(String.format("%s is no supported flag.", new Object[]{option}));
                    }
                }
            }
            catch (RuntimeException e) {
                throw MongoTemplate.potentiallyConvertRuntimeException(e, MongoTemplate.this.exceptionTranslator);
            }
            return cursorToUse;
        }
    }

    private static class FindCallback
    implements CollectionCallback<FindIterable<Document>> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Document fields;
        @Nullable
        private final com.mongodb.client.model.Collation collation;

        public FindCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, @Nullable com.mongodb.client.model.Collation collation) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            Assert.notNull((Object)fields, (String)"Fields must not be null");
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.fields = fields;
            this.collation = collation;
        }

        @Override
        public FindIterable<Document> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindIterable findIterable = this.collectionPreparer.prepare(collection).find((Bson)this.query, Document.class).projection((Bson)this.fields);
            if (this.collation != null) {
                findIterable = findIterable.collation(this.collation);
            }
            return findIterable;
        }
    }

    static class SessionBoundMongoTemplate
    extends MongoTemplate {
        private final MongoTemplate delegate;
        private final ClientSession session;

        SessionBoundMongoTemplate(ClientSession session, MongoTemplate that) {
            super(that.getMongoDatabaseFactory().withSession(session), that);
            this.delegate = that;
            this.session = session;
        }

        @Override
        public MongoCollection<Document> getCollection(String collectionName) {
            return this.delegate.getCollection(collectionName);
        }

        @Override
        public MongoDatabase getDb() {
            return this.delegate.getDb();
        }

        @Override
        protected boolean countCanBeEstimated(Document filter, CountOptions options) {
            return false;
        }
    }

    private class ExistsCallback
    implements CollectionCallback<Boolean> {
        private final CollectionPreparer collectionPreparer;
        private final Document mappedQuery;
        private final com.mongodb.client.model.Collation collation;

        ExistsCallback(CollectionPreparer collectionPreparer, Document mappedQuery, com.mongodb.client.model.Collation collation) {
            this.collectionPreparer = collectionPreparer;
            this.mappedQuery = mappedQuery;
            this.collation = collation;
        }

        @Override
        public Boolean doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            return MongoTemplate.this.doCount(this.collectionPreparer, collection.getNamespace().getCollectionName(), this.mappedQuery, new CountOptions().limit(1).collation(this.collation)) > 0L;
        }
    }

    private class ProjectingReadCallback<S, T>
    implements DocumentCallback<T> {
        private final MongoConverter mongoConverter;
        private final EntityProjection<T, S> projection;
        private final String collectionName;

        ProjectingReadCallback(MongoConverter mongoConverter, EntityProjection<T, S> projection, String collectionName) {
            this.mongoConverter = mongoConverter;
            this.projection = projection;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(Document document) {
            if (document == null) {
                return null;
            }
            MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent(document, this.projection.getMappedType().getType(), this.collectionName));
            T entity = this.mongoConverter.project(this.projection, (Bson)document);
            if (entity == null) {
                throw new MappingException(String.format("EntityReader %s returned null", this.mongoConverter));
            }
            MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<T>(document, entity, this.collectionName));
            return MongoTemplate.this.maybeCallAfterConvert(entity, document, this.collectionName);
        }
    }

    static interface DocumentCallback<T> {
        public T doWith(Document var1);
    }

    static class GeoNearResultDocumentCallback<T>
    implements DocumentCallback<GeoResult<T>> {
        private final String distanceField;
        private final DocumentCallback<T> delegate;
        private final Metric metric;

        GeoNearResultDocumentCallback(String distanceField, DocumentCallback<T> delegate, Metric metric) {
            Assert.notNull(delegate, (String)"DocumentCallback must not be null");
            this.distanceField = distanceField;
            this.delegate = delegate;
            this.metric = metric;
        }

        @Override
        public GeoResult<T> doWith(Document object) {
            double distance = Double.NaN;
            if (object.containsKey((Object)this.distanceField)) {
                distance = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)object.get((Object)this.distanceField, Number.class)), Double.class);
            }
            T doWith = this.delegate.doWith(object);
            return new GeoResult(doWith, new Distance(distance, this.metric));
        }
    }

    private class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Bson> reader;
        private final Class<T> type;
        private final String collectionName;

        ReadDocumentCallback(EntityReader<? super T, Bson> reader, Class<T> type, String collectionName) {
            this.reader = reader;
            this.type = type;
            this.collectionName = collectionName;
        }

        @Override
        public T doWith(Document document) {
            MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<T>(document, this.type, this.collectionName));
            Object entity = this.reader.read(this.type, (Object)document);
            if (entity == null) {
                throw new MappingException(String.format("EntityReader %s returned null", this.reader));
            }
            MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<Object>(document, entity, this.collectionName));
            entity = MongoTemplate.this.maybeCallAfterConvert(entity, document, this.collectionName);
            return (T)entity;
        }
    }

    private static class FindOneCallback
    implements CollectionCallback<Document> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Optional<Document> fields;
        private final CursorPreparer cursorPreparer;

        FindOneCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, CursorPreparer preparer) {
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.fields = Optional.of(fields).filter(it -> !ObjectUtils.isEmpty((Object)fields));
            this.cursorPreparer = preparer;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindIterable iterable = this.cursorPreparer.initiateFind(collection, col -> this.collectionPreparer.prepare((MongoCollection<Document>)col).find((Bson)this.query, Document.class));
            if (this.fields.isPresent()) {
                iterable = iterable.projection((Bson)this.fields.get());
            }
            return (Document)iterable.first();
        }
    }

    private static class FindAndRemoveCallback
    implements CollectionCallback<Document> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Optional<Collation> collation;

        FindAndRemoveCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Document sort, @Nullable Collation collation) {
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.collation = Optional.ofNullable(collation);
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndDeleteOptions opts = new FindOneAndDeleteOptions().sort((Bson)this.sort).projection((Bson)this.fields);
            this.collation.map(Collation::toMongoCollation).ifPresent(arg_0 -> ((FindOneAndDeleteOptions)opts).collation(arg_0));
            return (Document)this.collectionPreparer.prepare(collection).findOneAndDelete((Bson)this.query, opts);
        }
    }

    private static class FindAndModifyCallback
    implements CollectionCallback<Document> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Object update;
        private final List<Document> arrayFilters;
        private final FindAndModifyOptions options;

        FindAndModifyCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Document sort, Object update, List<Document> arrayFilters, FindAndModifyOptions options) {
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.arrayFilters = arrayFilters;
            this.options = options;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            Object object;
            FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions();
            opts.sort((Bson)this.sort);
            if (this.options.isUpsert()) {
                opts.upsert(true);
            }
            opts.projection((Bson)this.fields);
            if (this.options.isReturnNew()) {
                opts.returnDocument(ReturnDocument.AFTER);
            }
            this.options.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((FindOneAndUpdateOptions)opts).collation(arg_0));
            if (!this.arrayFilters.isEmpty()) {
                opts.arrayFilters(this.arrayFilters);
            }
            if ((object = this.update) instanceof Document) {
                Document document = (Document)object;
                return (Document)this.collectionPreparer.prepare(collection).findOneAndUpdate((Bson)this.query, (Bson)document, opts);
            }
            if (this.update instanceof List) {
                return (Document)this.collectionPreparer.prepare(collection).findOneAndUpdate((Bson)this.query, (List)this.update, opts);
            }
            throw new IllegalArgumentException(String.format("Using %s is not supported in findOneAndUpdate", this.update));
        }
    }

    private static class FindAndReplaceCallback
    implements CollectionCallback<Document> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Document fields;
        private final Document sort;
        private final Document update;
        @Nullable
        private final com.mongodb.client.model.Collation collation;
        private final FindAndReplaceOptions options;

        FindAndReplaceCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document fields, Document sort, Document update, @Nullable com.mongodb.client.model.Collation collation, FindAndReplaceOptions options) {
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.fields = fields;
            this.sort = sort;
            this.update = update;
            this.options = options;
            this.collation = collation;
        }

        @Override
        public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            FindOneAndReplaceOptions opts = new FindOneAndReplaceOptions();
            opts.sort((Bson)this.sort);
            opts.collation(this.collation);
            opts.projection((Bson)this.fields);
            if (this.options.isUpsert()) {
                opts.upsert(true);
            }
            if (this.options.isReturnNew()) {
                opts.returnDocument(ReturnDocument.AFTER);
            }
            return (Document)this.collectionPreparer.prepare(collection).findOneAndReplace((Bson)this.query, (Object)this.update, opts);
        }
    }

    private static class ReplaceCallback
    implements CollectionCallback<UpdateResult> {
        private final CollectionPreparer<MongoCollection<Document>> collectionPreparer;
        private final Document query;
        private final Document update;
        private final com.mongodb.client.model.ReplaceOptions options;

        ReplaceCallback(CollectionPreparer<MongoCollection<Document>> collectionPreparer, Document query, Document update, com.mongodb.client.model.ReplaceOptions options) {
            this.collectionPreparer = collectionPreparer;
            this.query = query;
            this.update = update;
            this.options = options;
        }

        @Override
        public UpdateResult doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
            return this.collectionPreparer.prepare(collection).replaceOne((Bson)this.query, (Object)this.update, this.options);
        }
    }

    static class CloseableIterableCursorAdapter<T>
    implements CloseableIterator<T> {
        @Nullable
        private volatile MongoCursor<Document> cursor;
        private PersistenceExceptionTranslator exceptionTranslator;
        private DocumentCallback<T> objectReadCallback;

        CloseableIterableCursorAdapter(MongoIterable<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor.iterator();
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        CloseableIterableCursorAdapter(MongoCursor<Document> cursor, PersistenceExceptionTranslator exceptionTranslator, DocumentCallback<T> objectReadCallback) {
            this.cursor = cursor;
            this.exceptionTranslator = exceptionTranslator;
            this.objectReadCallback = objectReadCallback;
        }

        public boolean hasNext() {
            MongoCursor<Document> cursor = this.cursor;
            if (cursor == null) {
                return false;
            }
            try {
                return cursor.hasNext();
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        @Nullable
        public T next() {
            if (this.cursor == null) {
                return null;
            }
            try {
                Document item = (Document)this.cursor.next();
                return this.objectReadCallback.doWith(item);
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
        }

        public void close() {
            MongoCursor<Document> c = this.cursor;
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (RuntimeException ex) {
                throw MongoTemplate.potentiallyConvertRuntimeException(ex, this.exceptionTranslator);
            }
            finally {
                this.cursor = null;
                this.exceptionTranslator = null;
                this.objectReadCallback = null;
            }
        }
    }
}

